/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal.model;

import java.nio.file.Path;
import jdk.jpackage.internal.util.CompositeProxy;

public interface MacPackage extends Package, MacPackageMixin {

    MacApplication app();

    @Override
    default AppImageLayout appImageLayout() {
        if (isRuntimeInstaller()) {
            return RUNTIME_PACKAGE_LAYOUT;
        } else {
            return Package.super.appImageLayout();
        }
    }

    default Path installDir() {
        return Path.of("/").resolve(relativeInstallDir());
    }

    public static MacPackage create(Package pkg, MacPackageMixin mixin) {
        return CompositeProxy.create(MacPackage.class, pkg, mixin);
    }

    public static final RuntimeLayout RUNTIME_PACKAGE_LAYOUT = RuntimeLayout.create(Path.of("Contents/Home"));
}
