/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal.model;

import java.util.List;
import java.util.Optional;

public interface MacFileAssociationMixin {

    String cfBundleTypeName();

    String cfBundleTypeRole();

    String lsHandlerRank();

    Optional<Boolean> lsTypeIsPackage();

    Optional<String> nsDocumentClass();

    Optional<String> nsPersistentStoreTypeKey();

    Optional<Boolean> lsSupportsOpeningDocumentsInPlace();

    Optional<Boolean> uiSupportsDocumentBrowser();

    List<String> utTypeConformsTo();

    List<String> nsExportableTypes();

    record Stub(String cfBundleTypeName, String cfBundleTypeRole,
            String lsHandlerRank, Optional<Boolean> lsTypeIsPackage, Optional<String> nsDocumentClass,
            Optional<String> nsPersistentStoreTypeKey,
            Optional<Boolean> lsSupportsOpeningDocumentsInPlace,
            Optional<Boolean> uiSupportsDocumentBrowser, List<String> utTypeConformsTo,
            List<String> nsExportableTypes) implements MacFileAssociationMixin {

    }
}
