/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.jpackage.internal;

import static jdk.jpackage.internal.CodesignConfig.ADHOC_SIGNING_IDENTITY;

import java.util.Objects;
import jdk.jpackage.internal.model.SigningIdentity;

record SigningIdentityImpl(String id) implements SigningIdentity {

    SigningIdentityImpl {
        Objects.requireNonNull(id);

        if (ADHOC_SIGNING_IDENTITY.equals(id)) {
            throw new IllegalArgumentException("Adhoc signing identity not allowed");
        }
    }
}
