// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: GraalCompilerOptions.java
package jdk.graal.compiler.core;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class GraalCompilerOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(GraalCompilerOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "CompilationBailoutAsFailure": {
            return OptionDescriptor.create(
                /*name*/ "CompilationBailoutAsFailure",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Treats compilation bailouts as compilation failures.",
                /*container*/ getContainer(),
                /*option*/ GraalCompilerOptions.CompilationBailoutAsFailure,
                /*fieldName*/ "CompilationBailoutAsFailure",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompilationFailureAction": {
            return OptionDescriptor.create(
                /*name*/ "CompilationFailureAction",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ jdk.graal.compiler.core.CompilationWrapper.ExceptionAction.class,
                /*help*/ """
Specifies the action to take when compilation fails.

The accepted values are:
    Silent  - Prints nothing to the console.
     Print  - Prints the stack trace to the console.
  Diagnose* - Retries the compilation with extra diagnostics.
    ExitVM  - Same as Diagnose except that the VM process exits after retrying.

* If the value is \"Diagnose\", compilation is retried with extra diagnostics enabled including dumping.
  Options specific to retry compilations can be modified using the DiagnoseOptions meta-option.
  For example, to enable full debug dumping and logging during all retry compilations, use \"-Djdk.graal.DiagnoseOptions=Dump=:5 Log=:5\".
  If the option value starts with a non-word character, that character is used as the separator between options instead of a space.
  For example: \"-Djdk.graal.DiagnoseOptions=@Log=Inlining@LogFile=/path/with space\".""",
                /*container*/ getContainer(),
                /*option*/ GraalCompilerOptions.CompilationFailureAction,
                /*fieldName*/ "CompilationFailureAction",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CrashAt": {
            return OptionDescriptor.create(
                /*name*/ "CrashAt",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ """
Pattern for method(s) that will trigger an exception when compiled.
This option exists to test handling compilation crashes gracefully.
See the MethodFilter option for the pattern syntax. A ':Bailout'
suffix will raise a bailout exception and a ':PermanentBailout'
suffix will raise a permanent bailout exception.""",
                /*container*/ getContainer(),
                /*option*/ GraalCompilerOptions.CrashAt,
                /*fieldName*/ "CrashAt",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpHeapAfter": {
            return OptionDescriptor.create(
                /*name*/ "DumpHeapAfter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ """
Emit a heap dump after each phase matching the given phase filter(s).

Use DumpPath or ShowDumpFiles to set or see where dumps are written.

The special phase name \"<compilation>\" means dump after compilation
instead of after any specific phase.

A phase filter is a phase name, optionally followed by '=' and a method
filter. Multiple phase filters can be specified, separated by ':'.
A phase name is matched as a substring.

For example:

   PartialEscape:Loop=B.foo,A.*

matches PartialEscapePhase for compilation of all methods and any phase
containing \"Loop\" in its name for compilation of B.foo as well as all
methods in class A.

A phase filter specification cannot be empty. Specify \"*\" to match
any phase.""",
                /*container*/ getContainer(),
                /*option*/ GraalCompilerOptions.DumpHeapAfter,
                /*fieldName*/ "DumpHeapAfter",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InjectedCompilationDelay": {
            return OptionDescriptor.create(
                /*name*/ "InjectedCompilationDelay",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The number of seconds by which to slow down each compilation. The compilations slowed down can be restricted with MethodFilter. This option exists to test the compilation watchdog.",
                /*container*/ getContainer(),
                /*option*/ GraalCompilerOptions.InjectedCompilationDelay,
                /*fieldName*/ "InjectedCompilationDelay",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxCompilationProblemsPerAction": {
            return OptionDescriptor.create(
                /*name*/ "MaxCompilationProblemsPerAction",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the maximum number of compilation failures to handle with the action specified by CompilationFailureAction before changing to a less verbose action. This does not apply to the ExitVM action..",
                /*container*/ getContainer(),
                /*option*/ GraalCompilerOptions.MaxCompilationProblemsPerAction,
                /*fieldName*/ "MaxCompilationProblemsPerAction",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintCompilation": {
            return OptionDescriptor.create(
                /*name*/ "PrintCompilation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print an informational line to the console for each completed compilation.",
                /*container*/ getContainer(),
                /*option*/ GraalCompilerOptions.PrintCompilation,
                /*fieldName*/ "PrintCompilation",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SystemicCompilationFailureRate": {
            return OptionDescriptor.create(
                /*name*/ "SystemicCompilationFailureRate",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the compilation failure rate that indicates a systemic compilation problem (and a resulting warning). The value is made absolute and clamped to produce P, a value between 0 and 100. Systemic failure is detected if the percentage of failing compilations in a sliding time window >= P. A negative value will cause the VM to exit after issuing the warning. Set to 0 to disable systemic compilation problem detection.",
                /*container*/ getContainer(),
                /*option*/ GraalCompilerOptions.SystemicCompilationFailureRate,
                /*fieldName*/ "SystemicCompilationFailureRate",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 8;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("CompilationBailoutAsFailure");
                    case 1: return get("CompilationFailureAction");
                    case 2: return get("CrashAt");
                    case 3: return get("DumpHeapAfter");
                    case 4: return get("InjectedCompilationDelay");
                    case 5: return get("MaxCompilationProblemsPerAction");
                    case 6: return get("PrintCompilation");
                    case 7: return get("SystemicCompilationFailureRate");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
