/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * Provides interfaces and classes for the Java Sound API.
 * The API is divided into sub-packages.
 * <ul>
 *  <li>Capture, processing and playback of sampled audio data is under {@link javax.sound.sampled}.
 *  <li>Sequencing, and synthesis of MIDI (Musical Instrument Digital Interface) data is under {@link javax.sound.midi}.
 * </ul>
 *
 * <h2>Related Documentation</h2>
 * For more information on using Java Sound see:
 * <ul>
 *   <li><a href="https://docs.oracle.com/javase/tutorial/sound/">
 *   The Java Sound Tutorial</a>
 * </ul>
 *
 * @since 25
 */
package javax.sound;
