#### Why

The JDWP implementation is split into two parties, (1) the resident which resides in the application image and (2) the server which is either a Native Image application itself or runs on HotSpot. Those parties communicate over JNI, and live in the same process.

The boilerplate code for that communication was generated by the native bridge annotation processor.  The same library (`sdk:nativebridge`) is also used for Polyglot Isolates in Truffle, and therefore is not part of a GraalVM but is obtained via maven or other means if needed.  This means the JDWP implementation cannot use the same library, as the JDWP implementation is a component of GraalVM.

One way to solve this would be shadowing, however that is potentially tricky as an annotation processor is involved.  Since the interface isn't expected to change much anymore, we decided to check in the generated code instead and duplicate dependencies to it, see subpackages `jnuitils` and `nativebridge` in this project.


The sources of `jniutils` and `nativebridge` packages are a copy based on 199e453676902b74bba06581b259bb928d5f9a27 in the CE repository.

### How to upgrade `NativeToHSJDWPEventHandlerBridgeGen` and `HSToNativeJDWPBridgeGen`

1. Uncomment `@GenerateNativeToHotSpotBridge` annotation in `NativeToHSJDWPEventHandlerBridge` and `@GenerateHotSpotToNativeBridge` in `HSToNativeJDWPBridge`
2. Adapt imports in generated file accordingly.
3. There are a few cases where the fully qualified name to a class is used in a string, those must be updated as well.
4. Sync sources in `jniutils` and `nativebridge` if a newer revision is used.
5. Add `sdk:NATIVEBRIDGE_PROCESSOR` as `annotationProcessors` and `sdk:NATIVEBRIDGE` as dependency for this project, and build the project specifically with `mx build --target com.oracle.svm.jdwp.server`.
