/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.isolated;

import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.graal.isolated.ClientHandle;
import com.oracle.svm.core.graal.isolated.CompilerHandle;
import com.oracle.svm.core.graal.isolated.CompilerIsolateThread;
import com.oracle.svm.core.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.core.graal.isolated.IsolatedCompileContext;
import com.oracle.truffle.compiler.TruffleCompilerListener;
import org.graalvm.nativeimage.c.function.CEntryPoint;

final class IsolatedGraphInfo
implements TruffleCompilerListener.GraphInfo {
    private final CompilerHandle<TruffleCompilerListener.GraphInfo> originalObjectHandle;
    private final int nodeCount;

    IsolatedGraphInfo(CompilerHandle<TruffleCompilerListener.GraphInfo> originalObjectHandle, int nodeCount) {
        this.originalObjectHandle = originalObjectHandle;
        this.nodeCount = nodeCount;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public String[] getNodeTypes(boolean simpleNames) {
        ClientHandle<String[]> handle = IsolatedGraphInfo.getNodeTypes0(IsolatedCompileClient.get().getCompiler(), this.originalObjectHandle, simpleNames);
        return (String[])IsolatedCompileClient.get().unhand(handle);
    }

    @CEntryPoint(exceptionHandler=IsolatedCompileContext.WordExceptionHandler.class, include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    @CEntryPointOptions(callerEpilogue=IsolatedCompileContext.ExceptionRethrowCallerEpilogue.class)
    private static ClientHandle<String[]> getNodeTypes0(CompilerIsolateThread compiler, CompilerHandle<TruffleCompilerListener.GraphInfo> infoHandle, boolean simpleNames) {
        TruffleCompilerListener.GraphInfo info = (TruffleCompilerListener.GraphInfo)IsolatedCompileContext.get().unhand(infoHandle);
        return IsolatedCompileContext.get().createStringArrayInClient(info.getNodeTypes(simpleNames));
    }
}

