/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import com.oracle.svm.jdwp.server.impl.ServerToResidentCallThread;
import com.oracle.svm.jdwp.server.impl.SuspendedInfo;
import com.oracle.svm.jdwp.server.impl.ThreadRef;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ThreadsCollector {
    private final Map<Long, ThreadRef> threads = new HashMap<Long, ThreadRef>();
    private final ServerToResidentCallThread callToResidentThread = ServerToResidentCallThread.create();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Object vmSuspendLock = new Object();
    private int vmSuspendCount;
    private volatile boolean disposed;

    ThreadsCollector() {
    }

    ReentrantReadWriteLock getRWLock() {
        return this.rwLock;
    }

    ServerToResidentCallThread getCallToResidentThread() {
        return this.callToResidentThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadRef getThreadRef(long threadId) {
        ReentrantReadWriteLock.WriteLock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            ThreadRef thread = this.threads.get(threadId);
            if (thread == null) {
                thread = new ThreadRef(threadId, this);
                this.threads.put(threadId, thread);
            }
            ThreadRef threadRef = thread;
            return threadRef;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadRef getThreadRefIfExists(long threadId) {
        ReentrantReadWriteLock.ReadLock lock = this.rwLock.readLock();
        lock.lock();
        try {
            ThreadRef threadRef = this.threads.get(threadId);
            return threadRef;
        }
        finally {
            lock.unlock();
        }
    }

    public void suspendAll() {
        this.suspendAllBut(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspendAllBut(ThreadRef ignored) {
        long[] suspendedThreadIDs = new long[2];
        int lastIndex = 0;
        this.notifyVMSuspended();
        ReentrantReadWriteLock.WriteLock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            long[] newlySuspendedThreadIDs;
            if (this.disposed) {
                return;
            }
            for (ThreadRef thread : this.threads.values()) {
                if (thread == ignored || thread.getSuspendCount() <= 0) continue;
                thread.notifySuspended();
                if (lastIndex + 1 >= suspendedThreadIDs.length) {
                    suspendedThreadIDs = Arrays.copyOf(suspendedThreadIDs, suspendedThreadIDs.length + suspendedThreadIDs.length / 2);
                }
                suspendedThreadIDs[lastIndex++] = thread.getThreadId();
            }
            if (lastIndex < suspendedThreadIDs.length) {
                suspendedThreadIDs = Arrays.copyOf(suspendedThreadIDs, lastIndex);
            }
            for (long id : newlySuspendedThreadIDs = ServerJDWP.BRIDGE.vmSuspend(suspendedThreadIDs)) {
                ThreadRef threadRef = this.getThreadRef(id);
                threadRef.notifySuspended();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void suspendAllAt(ThreadRef threadRef, SuspendedInfo suspendedInfo, Runnable eventSender) {
        assert (this.rwLock.getWriteHoldCount() == 0) : "Must not reenter the write lock.";
        long[] suspendedThreadIDs = new long[2];
        long skipId = threadRef.getThreadId();
        int lastIndex = 1;
        suspendedThreadIDs[0] = skipId;
        this.notifyVMSuspended();
        AtomicReference<ReentrantReadWriteLock.WriteLock> lock = new AtomicReference<ReentrantReadWriteLock.WriteLock>(this.rwLock.writeLock());
        this.rwLock.writeLock().lock();
        try {
            long[] newlySuspendedThreadIDs;
            if (this.disposed) {
                return;
            }
            for (ThreadRef thread : this.threads.values()) {
                if (thread.getThreadId() == skipId || !thread.canParkOrIncreaseSuspend()) continue;
                if (lastIndex + 1 >= suspendedThreadIDs.length) {
                    suspendedThreadIDs = Arrays.copyOf(suspendedThreadIDs, suspendedThreadIDs.length + suspendedThreadIDs.length / 2);
                }
                suspendedThreadIDs[lastIndex++] = thread.getThreadId();
            }
            if (lastIndex < suspendedThreadIDs.length) {
                suspendedThreadIDs = Arrays.copyOf(suspendedThreadIDs, lastIndex);
            }
            threadRef.resumeResidentIfSuspended();
            for (long id : newlySuspendedThreadIDs = this.callToResidentThread.vmSuspend(suspendedThreadIDs)) {
                ThreadRef thread = this.getThreadRef(id);
                thread.notifySuspended();
            }
            threadRef.suspendedAt(suspendedInfo, () -> {
                ((Lock)lock.getAndSet(null)).unlock();
                assert (this.rwLock.getWriteHoldCount() == 0);
                assert (this.rwLock.getReadHoldCount() == 0);
                eventSender.run();
            });
        }
        finally {
            Lock l = lock.get();
            if (l != null) {
                l.unlock();
            }
        }
    }

    public void resumeAll() {
        this.resumeAllBut(null);
    }

    void resumeAllBut(ThreadRef ignored) {
        this.resumeAllBut(ignored, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeAllBut(ThreadRef ignored, boolean forceRelease) {
        long[] resumeThreadIDs = new long[8];
        HashSet<ThreadRef> parkedThreads = null;
        int lastIndex = 0;
        ReentrantReadWriteLock.WriteLock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            for (ThreadRef thread : this.threads.values()) {
                if (thread == ignored) continue;
                int suspendCount = thread.getSuspendCount();
                if (suspendCount == 1 || forceRelease && suspendCount > 1) {
                    if (!thread.isParked()) {
                        thread.notifyResumed();
                        if (lastIndex + 1 >= resumeThreadIDs.length) {
                            resumeThreadIDs = Arrays.copyOf(resumeThreadIDs, resumeThreadIDs.length + resumeThreadIDs.length / 2);
                        }
                        resumeThreadIDs[lastIndex++] = thread.getThreadId();
                        continue;
                    }
                    if (parkedThreads == null) {
                        parkedThreads = new HashSet<ThreadRef>();
                    }
                    parkedThreads.add(thread);
                    continue;
                }
                if (suspendCount <= 1) continue;
                thread.notifyResumed();
            }
            ServerJDWP.BRIDGE.vmResume(resumeThreadIDs);
            if (parkedThreads != null) {
                for (ThreadRef t : parkedThreads) {
                    t.resume(forceRelease);
                }
            }
            if (forceRelease) {
                this.threads.clear();
            }
        }
        finally {
            lock.unlock();
        }
        this.notifyVMResumed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllThreadsAndDispose() {
        this.disposed = true;
        this.resumeAllBut(null, true);
        Object object = this.vmSuspendLock;
        synchronized (object) {
            this.vmSuspendCount = 0;
            this.vmSuspendLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyVMSuspended() {
        Object object = this.vmSuspendLock;
        synchronized (object) {
            ++this.vmSuspendCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyVMResumed() {
        Object object = this.vmSuspendLock;
        synchronized (object) {
            if (this.vmSuspendCount == 0) {
                return;
            }
            --this.vmSuspendCount;
            if (this.vmSuspendCount == 0) {
                this.vmSuspendLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockIfVMSuspended() {
        try {
            Object object = this.vmSuspendLock;
            synchronized (object) {
                while (!this.disposed && this.vmSuspendCount > 0) {
                    this.vmSuspendLock.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

