/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.UnmodifiablePacket;
import com.oracle.svm.jdwp.server.impl.ConnectionClosedException;
import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SocketConnection
implements Runnable {
    private static final Packet END = UnmodifiablePacket.parseAndWrap((byte[])new byte[]{0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0});
    private final Socket socket;
    private final OutputStream socketOutput;
    private final InputStream socketInput;
    private final Object receiveLock = new Object();
    private final Object sendLock = new Object();
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final BlockingQueue<Packet> queue = new ArrayBlockingQueue<Packet>(4096);
    private Thread senderThread;

    SocketConnection(Socket socket) throws IOException {
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.socketInput = socket.getInputStream();
        this.socketOutput = socket.getOutputStream();
    }

    public void close() throws IOException {
        if (!this.isOpen.getAndSet(false)) {
            return;
        }
        this.queue.add(END);
        try {
            this.senderThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.socketOutput.flush();
        ServerJDWP.LOGGER.log("closing socket now");
        this.socketOutput.close();
        this.socketInput.close();
        this.socket.close();
        this.queue.clear();
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public Thread startSenderThread() {
        Thread jdwpSender = new Thread((Runnable)this, "jdwp-transmitter");
        jdwpSender.setDaemon(true);
        this.senderThread = jdwpSender;
        jdwpSender.start();
        return jdwpSender;
    }

    @Override
    public void run() {
        block4: {
            try {
                Packet take;
                while (END != (take = this.queue.take())) {
                    byte[] shipment = take.toByteArray();
                    this.writePacket(shipment);
                }
            }
            catch (ConnectionClosedException | InterruptedException e) {
            }
            catch (IOException ex) {
                if (!this.isOpen()) break block4;
                throw new RuntimeException("Failed sending packet to debugger instance", ex);
            }
        }
    }

    public void queuePacket(Packet packet) {
        assert (packet != null && packet != END);
        if (this.isOpen()) {
            this.queue.add(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readPacket() throws IOException, ConnectionClosedException {
        if (!this.isOpen() || Thread.currentThread().isInterrupted()) {
            throw new ConnectionClosedException();
        }
        Object object = this.receiveLock;
        synchronized (object) {
            int b4;
            int b3;
            int b2;
            int b1;
            try {
                b1 = this.socketInput.read();
                b2 = this.socketInput.read();
                b3 = this.socketInput.read();
                b4 = this.socketInput.read();
            }
            catch (IOException ioe) {
                if (!this.isOpen() || Thread.currentThread().isInterrupted()) {
                    throw new ConnectionClosedException();
                }
                throw ioe;
            }
            if (b1 < 0) {
                return new byte[0];
            }
            if (b2 < 0 || b3 < 0 || b4 < 0) {
                throw new IOException("Protocol error - premature EOF");
            }
            int len = b1 << 24 | b2 << 16 | b3 << 8 | b4;
            if (len < 0) {
                throw new IOException("Protocol error - invalid length");
            }
            byte[] b = new byte[len];
            b[0] = (byte)b1;
            b[1] = (byte)b2;
            b[2] = (byte)b3;
            b[3] = (byte)b4;
            int off = 4;
            len -= off;
            while (len > 0) {
                int count;
                try {
                    count = this.socketInput.read(b, off, len);
                }
                catch (IOException ioe) {
                    if (!this.isOpen() || Thread.currentThread().isInterrupted()) {
                        throw new ConnectionClosedException();
                    }
                    throw ioe;
                }
                if (count < 0) {
                    throw new IOException("Protocol error - premature EOF");
                }
                len -= count;
                off += count;
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePacket(byte[] b) throws IOException, ConnectionClosedException {
        if (b.length < 11) {
            throw new IllegalArgumentException("Packet is insufficient size");
        }
        int b0 = b[0] & 0xFF;
        int b1 = b[1] & 0xFF;
        int b2 = b[2] & 0xFF;
        int b3 = b[3] & 0xFF;
        int len = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        if (len < 11) {
            throw new IllegalArgumentException("Packet is insufficient size");
        }
        if (len > b.length) {
            throw new IllegalArgumentException("Length mis-match");
        }
        Object object = this.sendLock;
        synchronized (object) {
            try {
                this.socketOutput.write(b, 0, len);
            }
            catch (IOException ioe) {
                if (!this.isOpen()) {
                    throw new ConnectionClosedException();
                }
                throw ioe;
            }
        }
    }

    public void sendVMDied(Packet stream) {
        byte[] shipment = stream.toByteArray();
        try {
            this.writePacket(shipment);
            this.socketOutput.flush();
        }
        catch (Exception e) {
            ServerJDWP.LOGGER.log("Sending VM_DEATH packet to client failed");
        }
    }
}

