/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.virtualization.core;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.virtualization.core.VirtualizationConfigurationParserUtil;
import com.oracle.svm.enterprise.virtualization.core.VirtualizationTarget;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import jdk.graal.compiler.util.json.JsonParser;
import org.graalvm.collections.EconomicMap;

final class a {
    private final String GJ;
    private final EconomicMap<String, Object> GK;
    final String GL;

    static a aO(String string) {
        return new a(string);
    }

    private a(String string) {
        this.GJ = string;
        this.GK = a.aP(string);
        this.GL = a.u(this.GK);
    }

    private static EconomicMap<String, Object> aP(String string) {
        EconomicMap<String, Object> economicMap;
        Path path = Paths.get(string, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw UserError.abort((String)"Virtualization configuration file %s not found. Check if the file is at the specified path.", (Object[])new Object[]{path});
        }
        if (!Files.isReadable(path)) {
            throw UserError.abort((String)"Virtualization configuration file %s cannot be read. Check if you have read permissions for the file.", (Object[])new Object[]{path});
        }
        FileReader fileReader = new FileReader(path.toString());
        try {
            JsonParser jsonParser = new JsonParser((Reader)fileReader);
            Object object = jsonParser.parse();
            economicMap = VirtualizationConfigurationParserUtil.asMap(object, "Incorrect virtualization config file format. The top level of the document must be an object with key-pair options.");
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)fileReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw VMError.shouldNotReachHere((Throwable)iOException);
            }
        }
        ((Reader)fileReader).close();
        return economicMap;
    }

    private static String u(EconomicMap<String, Object> economicMap) {
        if (!economicMap.containsKey((Object)"target")) {
            throw UserError.abort((String)"Missing required attribute target in the top level.", (Object[])new Object[0]);
        }
        return VirtualizationConfigurationParserUtil.asString(economicMap.get((Object)"target"), "target");
    }

    void a(VirtualizationTarget virtualizationTarget) {
        this.b(virtualizationTarget);
        virtualizationTarget.validateConfiguration(this.GJ);
    }

    private void b(VirtualizationTarget virtualizationTarget) {
        if (this.GK.containsKey((Object)"include")) {
            this.a(virtualizationTarget, VirtualizationConfigurationParserUtil.asList(this.GK.get((Object)"include"), "include attribute in the top level is not in a correct format."));
        }
        virtualizationTarget.registerTargetSpecificOptions(this.GK);
    }

    private void a(VirtualizationTarget virtualizationTarget, List<Object> list) {
        for (Object object : list) {
            this.a(virtualizationTarget, VirtualizationConfigurationParserUtil.asMap(object, "Element of include array is not in a correct format."));
        }
    }

    private void a(VirtualizationTarget virtualizationTarget, EconomicMap<String, Object> economicMap) {
        if (!economicMap.containsKey((Object)"src")) {
            throw UserError.abort((String)"Missing required attribute 'src' in an include element.", (Object[])new Object[0]);
        }
        if (!economicMap.containsKey((Object)"dest")) {
            throw UserError.abort((String)"Missing required attribute 'dest' in an include element.", (Object[])new Object[0]);
        }
        Path path = Paths.get(VirtualizationConfigurationParserUtil.asString(economicMap.get((Object)"src"), "src"), new String[0]);
        Path path2 = Paths.get(VirtualizationConfigurationParserUtil.asString(economicMap.get((Object)"dest"), "dest"), new String[0]);
        virtualizationTarget.registerIncludedFile(this.GJ, path, path2);
    }
}

