/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.virtualization.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.virtualization.core.VirtualizationConfigurationParserUtil;
import com.oracle.svm.util.StringUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.graal.compiler.options.OptionKey;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Pair;

public abstract class VirtualizationTarget {
    private String Hc = "";
    private String Hd = "";
    private Long He = null;
    private boolean Hf = false;
    private List<Pair<Path, Path>> Hg = new ArrayList<Pair<Path, Path>>();
    private static final String[] Hh = new String[]{"raw", "qcow2"};

    public abstract String getConfigName();

    public void onOptionValueUpdate(EconomicMap<OptionKey<?>, Object> economicMap) {
        SubstrateOptions.StaticExecutable.update(economicMap, (Object)true);
        SubstrateOptions.SharedLibrary.update(economicMap, (Object)false);
    }

    public void registerIncludedFile(String string, Path path, Path path2) {
        Path path3;
        if (path.isAbsolute()) {
            path3 = path;
        } else {
            Path path4 = Paths.get(string, new String[0]).toAbsolutePath().getParent();
            assert (path4 != null);
            path3 = Paths.get(path4.toString(), path.toString());
        }
        this.Hg.add((Pair<Path, Path>)Pair.create((Object)path3, (Object)path2));
    }

    public void registerTargetSpecificOptions(EconomicMap<String, Object> economicMap) {
        if (!economicMap.containsKey((Object)"image-format")) {
            VirtualizationConfigurationParserUtil.throwTargetSpecificOptionMissing("image-format");
        }
        this.Hc = VirtualizationConfigurationParserUtil.asString(economicMap.get((Object)"image-format"), "image-format");
        if (!economicMap.containsKey((Object)"image")) {
            VirtualizationConfigurationParserUtil.throwTargetSpecificOptionMissing("image");
        }
        this.Hd = VirtualizationConfigurationParserUtil.asString(economicMap.get((Object)"image"), "image");
        if (economicMap.containsKey((Object)"max-file-system-size")) {
            this.He = VirtualizationConfigurationParserUtil.asBytesSize(economicMap.get((Object)"max-file-system-size"), "max-file-system-size");
            this.Hf = true;
        }
    }

    private static void j(String string, String string2) {
        throw UserError.abort((String)"In virtualization configuration file %s:%n%s", (Object[])new Object[]{string, System.lineSeparator(), string2});
    }

    public void validateConfiguration(String string) {
        if (!Arrays.asList(Hh).contains(this.Hc)) {
            VirtualizationTarget.j(string, "Invalid VMM image format ('image-format') for target. Supported formats are " + StringUtil.joinSingleQuoted((String[])Hh) + ".");
        }
        for (Pair<Path, Path> pair : this.Hg) {
            Path path2 = (Path)pair.getLeft();
            Path path3 = (Path)pair.getRight();
            if (!Files.exists(path2, new LinkOption[0])) {
                VirtualizationTarget.j(string, "In property 'include':" + System.lineSeparator() + "File " + String.valueOf(path2) + " does not exist. Check if the file is in the correct location.");
            }
            try {
                Files.walk(path2, new FileVisitOption[0]).forEach(path -> {
                    if (!Files.isReadable(path)) {
                        VirtualizationTarget.j(string, "In property 'include':" + System.lineSeparator() + "File " + String.valueOf(path) + " is not readable. Check if you have permission to read it.");
                    }
                    if (!Files.isRegularFile(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                        VirtualizationTarget.j(string, "In property 'include':" + System.lineSeparator() + "File " + String.valueOf(path) + " is neither a regular file or a directory. Remove the offending file or remove the selected path.");
                    }
                });
            }
            catch (IOException iOException) {
                VMError.shouldNotReachHere((Throwable)iOException);
            }
            if (path3.isAbsolute()) continue;
            VirtualizationTarget.j(string, "In property 'include':" + System.lineSeparator() + "File " + String.valueOf(path2) + " has an invalid destination. Destinations must be in the form of absolute paths.");
        }
    }

    public String getImagePath() {
        return this.Hd;
    }

    public boolean isFileSystemSizeSet() {
        return this.Hf;
    }

    public long getFileSystemSizeInBytes() {
        return this.He;
    }

    public List<Pair<Path, Path>> getFilesForTransfer() {
        return this.Hg;
    }

    public String getImageFormat() {
        return this.Hc;
    }
}

