/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.sampler.CallStackFrameMethodInfo;
import com.oracle.svm.core.sampler.SamplerStackTraceSerializer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.l;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.LockFreePrefixTree;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class j
implements SamplerStackTraceSerializer {
    private static final String Gs = ".";
    private static final CodeInfoDecoder.FrameInfoCursor Gt = new CodeInfoDecoder.FrameInfoCursor();
    private final boolean Gu;
    private final LockFreePrefixTree Gv = new LockFreePrefixTree((LockFreePrefixTree.Allocator)new LockFreePrefixTree.HeapAllocator());

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public j(boolean bl2) {
        this.Gu = bl2;
    }

    @Fold
    public static j singleton() {
        return (j)ImageSingletons.lookup(j.class);
    }

    public Pointer serializeStackTrace(Pointer pointer, Pointer pointer2, int n2, int n3, boolean bl2, long l2, long l3, long l4, int n4) {
        Pointer pointer3;
        assert (n4 == 0) : "the sampler shouldn't use a skip count";
        Pointer pointer4 = pointer3 = pointer.add(n2);
        LockFreePrefixTree.Node node = this.Gv.root();
        while (pointer4.aboveThan((UnsignedWord)pointer)) {
            pointer4 = pointer4.subtract(8);
            long l5 = pointer4.readLong(0);
            node = node.at(this.Gv.allocator(), l5);
        }
        node.incValue();
        return pointer3.add(8);
    }

    public void reset() {
        this.Gv.reset();
    }

    public boolean lq() {
        return this.Gu;
    }

    public LockFreePrefixTree lr() {
        return this.Gv;
    }

    public Map<String, long[]> ls() {
        HashMap<String, long[]> hashMap = new HashMap<String, long[]>();
        a a3 = new a(new d(), null);
        BiFunction<a, Long, a> biFunction = (a2, l2) -> {
            ArrayDeque<c> arrayDeque = j.j(l2);
            a a3 = a2;
            for (c c2 : arrayDeque) {
                a3 = new a(c2, a3);
            }
            return a3;
        };
        BiConsumer<a, Long> biConsumer = (a2, l2) -> {
            a a3;
            if (l2 == 0L) {
                return;
            }
            a a4 = a3 = this.lq() ? j.a(a2) : j.b(a2);
            if (a3 == null) {
                assert (this.lq()) : "The top frame might not be present only in the case of asynchronous sampling.";
                return;
            }
            l l3 = (l)ImageSingletons.lookup(CallStackFrameMethodInfo.class);
            StringBuilder stringBuilder = new StringBuilder(a3.Gw.a(l3::V));
            a3 = a3.Gx;
            while (a3.Gx != null) {
                stringBuilder.append("<").append(a3.Gw.a(l3::V));
                a3 = a3.Gx;
            }
            hashMap.compute(stringBuilder.toString(), (string, lArray) -> new long[]{lArray == null ? l2 : l2 + lArray[0]});
        };
        this.Gv.topDown((Object)a3, biFunction, biConsumer);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Ensure CodeInfo instance is bound with tether.", calleeMustBe=false)
    private static ArrayDeque<c> j(long l2) {
        CodePointer codePointer = (CodePointer)Word.pointer((long)l2);
        UntetheredCodeInfo untetheredCodeInfo = CodeInfoTable.lookupCodeInfo((CodePointer)codePointer);
        if (untetheredCodeInfo.isNull()) {
            VMError.shouldNotReachHere((String)"Stack walk must walk only frames of known code.");
        }
        Object object = CodeInfoAccess.acquireTether((UntetheredCodeInfo)untetheredCodeInfo);
        try {
            CodeInfo codeInfo = CodeInfoAccess.convert((UntetheredCodeInfo)untetheredCodeInfo, (Object)object);
            ArrayDeque<c> arrayDeque = j.a(codeInfo, codePointer);
            return arrayDeque;
        }
        finally {
            CodeInfoAccess.releaseTether((UntetheredCodeInfo)untetheredCodeInfo, (Object)object);
        }
    }

    private static ArrayDeque<c> a(CodeInfo codeInfo, CodePointer codePointer) {
        ArrayDeque<c> arrayDeque = new ArrayDeque<c>();
        Gt.initialize(codeInfo, codePointer, false);
        while (Gt.advance()) {
            FrameInfoQueryResult frameInfoQueryResult = Gt.get();
            String string = frameInfoQueryResult.getSourceClassName() + Gs + frameInfoQueryResult.getSourceMethodName();
            arrayDeque.addFirst(new b(frameInfoQueryResult.getSourceMethodId(), frameInfoQueryResult.getBci(), string));
        }
        assert (!arrayDeque.isEmpty());
        return arrayDeque;
    }

    private static a a(a a2) {
        return j.aN(a2.Gw.GA) ? null : a2;
    }

    private static boolean aN(String string) {
        return string.contains(j.class.getPackageName());
    }

    private static a b(a a2) {
        a a3 = a2;
        boolean bl2 = false;
        l l2 = (l)ImageSingletons.lookup(CallStackFrameMethodInfo.class);
        while (!bl2) {
            if (a3 == null) {
                String string = j.c(a2);
                throw new IllegalStateException("Unknown call stack:" + System.lineSeparator() + string + System.lineSeparator());
            }
            if (l2.U(a3.Gw.Gz)) {
                bl2 = true;
            }
            a3 = a3.Gx;
        }
        return a3;
    }

    private static String c(a a2) {
        StringBuilder stringBuilder = new StringBuilder();
        a a3 = a2;
        while (a3 != null) {
            stringBuilder.append("    ");
            assert (a3.Gw.GA != null);
            stringBuilder.append(a3.Gw.GA);
            stringBuilder.append(System.lineSeparator());
            a3 = a3.Gx;
        }
        return stringBuilder.toString();
    }

    private static final class a
    extends Record {
        private final c Gw;
        private final a Gx;

        private a(c c2, a a2) {
            this.Gw = c2;
            this.Gx = a2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "frameInfo;tail", "Gw", "Gx"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "frameInfo;tail", "Gw", "Gx"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "frameInfo;tail", "Gw", "Gx"}, this, object);
        }

        public c lt() {
            return this.Gw;
        }

        public a lu() {
            return this.Gx;
        }
    }

    static final class d
    extends c {
        static final int GB = -5;

        d() {
            super(-5, "<total>");
        }

        @Override
        public String a(IntFunction<Integer> intFunction) {
            return String.valueOf(intFunction.apply(this.Gz));
        }
    }

    static abstract class c {
        final int Gz;
        String GA;

        c(int n2, String string) {
            this.Gz = n2;
            this.GA = string;
        }

        abstract String a(IntFunction<Integer> var1);
    }

    static class b
    extends c {
        int Gy;

        b(int n2, int n3, String string) {
            super(n2, string);
            this.Gy = n3;
        }

        @Override
        String a(IntFunction<Integer> intFunction) {
            int n2 = intFunction.apply(this.Gz);
            return ProfileDumper.packCodePosition(n2, this.Gy);
        }
    }
}

