/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.sampler.CallStackFrameMethodInfo;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.profiling.framework.InstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import com.oracle.svm.enterprise.profiling.framework.collection.PrefixTree;
import com.oracle.svm.enterprise.profiling.j;
import com.oracle.svm.enterprise.profiling.l;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.LockFreePrefixTree;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;

public final class SamplingData
implements ProfileDumper.SampleProvider {
    private static final CodeInfoDecoder.FrameInfoCursor FRAME_INFO_CURSOR = new CodeInfoDecoder.FrameInfoCursor();

    @Override
    public PrefixTree<Long> samples() {
        if (ImageSingletons.contains(j.class)) {
            j j2 = (j)ImageSingletons.lookup(j.class);
            return new CallingContextPrefixTree(j2.lr());
        }
        return new EmptyPrefixTree();
    }

    private static final class CallingContextPrefixTree
    implements PrefixTree<Long> {
        private final LockFreePrefixTree lockFreePrefixTree;

        CallingContextPrefixTree(LockFreePrefixTree lockFreePrefixTree) {
            this.lockFreePrefixTree = lockFreePrefixTree;
        }

        @Override
        public void topDown(BiConsumer<CallingContext, Long> biConsumer) {
            this.lockFreePrefixTree.topDown((Object)CallingContext.empty(), (callingContext, l2) -> {
                List<CodePosition> list = CallingContextPrefixTree.decodeInstructionPointer(l2);
                if (list == null || callingContext == null) {
                    return null;
                }
                CallingContext callingContext2 = callingContext;
                for (CodePosition codePosition : list) {
                    callingContext2 = CallingContext.withCallee(codePosition, callingContext2);
                }
                return callingContext2;
            }, (callingContext, l2) -> {
                if (l2 == 0L || callingContext == null) {
                    return;
                }
                biConsumer.accept(CallingContextPrefixTree.filterSafepointSamplingEntries(callingContext), (Long)l2);
            });
        }

        private static CallingContext filterSafepointSamplingEntries(CallingContext callingContext) {
            l l2 = (l)ImageSingletons.lookup(CallStackFrameMethodInfo.class);
            for (CallingContext callingContext2 = callingContext; callingContext2 != CallingContext.empty(); callingContext2 = callingContext2.tail()) {
                if (!l2.U(callingContext2.head().methodID())) continue;
                return callingContext2.tail();
            }
            return callingContext;
        }

        @Override
        public List<PrefixTree.Cursor<Long>> roots() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Uninterruptible(reason="Ensure CodeInfo instance is bound with tether.", calleeMustBe=false)
        private static List<CodePosition> decodeInstructionPointer(long l2) {
            CodePointer codePointer = (CodePointer)Word.pointer((long)l2);
            UntetheredCodeInfo untetheredCodeInfo = CodeInfoTable.lookupCodeInfo((CodePointer)codePointer);
            if (untetheredCodeInfo.isNull()) {
                VMError.shouldNotReachHere((String)"Stack walk must walk only frames of known code.");
            }
            Object object = CodeInfoAccess.acquireTether((UntetheredCodeInfo)untetheredCodeInfo);
            try {
                CodeInfo codeInfo = CodeInfoAccess.convert((UntetheredCodeInfo)untetheredCodeInfo, (Object)object);
                List<CodePosition> list = CallingContextPrefixTree.decodeInstructionPointer(codeInfo, codePointer);
                return list;
            }
            finally {
                CodeInfoAccess.releaseTether((UntetheredCodeInfo)untetheredCodeInfo, (Object)object);
            }
        }

        private static List<CodePosition> decodeInstructionPointer(CodeInfo codeInfo, CodePointer codePointer) {
            LinkedList<CodePosition> linkedList = new LinkedList<CodePosition>();
            FRAME_INFO_CURSOR.initialize(codeInfo, codePointer, false);
            while (FRAME_INFO_CURSOR.advance()) {
                FrameInfoQueryResult frameInfoQueryResult = FRAME_INFO_CURSOR.get();
                if (InstrumentationData.singleton().isTypeNonInstrumentable(frameInfoQueryResult.getSourceClassName())) {
                    return null;
                }
                linkedList.add(0, new CodePosition(frameInfoQueryResult.getSourceMethodId(), frameInfoQueryResult.getBci()));
            }
            assert (!linkedList.isEmpty());
            return linkedList;
        }
    }

    private static final class EmptyPrefixTree
    implements PrefixTree<Long> {
        private EmptyPrefixTree() {
        }

        @Override
        public List<PrefixTree.Cursor<Long>> roots() {
            return Collections.emptyList();
        }

        @Override
        public void topDown(BiConsumer<CallingContext, Long> biConsumer) {
        }
    }
}

