/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.util.Arrays;
import java.util.Objects;

public class ProfilingMethod {
    public static final int DECLARING_CLASS_TYPE_ID_POSITION = 0;
    public static final int RETURN_TYPE_ID_POSITION = 1;
    public static final int PARAMETERS_STARTING_POSITION = 2;
    protected final int id;
    protected final String name;
    protected final int[] signature;

    public ProfilingMethod(int n2, String string, int[] nArray) {
        this.id = n2;
        this.name = string;
        this.signature = nArray;
    }

    public ProfilingMethod() {
        this(-1, "", new int[0]);
    }

    public ProfilingMethod(HostedMethod hostedMethod) {
        this(hostedMethod.wrapped.getId(), hostedMethod.getName(), ProfilingMethod.createSignature(hostedMethod.getDeclaringClass().getTypeID(), ((HostedType)hostedMethod.getSignature().getReturnType()).getTypeID(), ProfilingMethod.parametersFor(hostedMethod)));
    }

    public ProfilingMethod(AnalysisMethod analysisMethod) {
        this(analysisMethod.getId(), analysisMethod.getName(), ProfilingMethod.createSignature(analysisMethod.getDeclaringClass().getId(), ((AnalysisType)analysisMethod.getSignature().getReturnType()).getId(), ProfilingMethod.parametersFor(analysisMethod)));
    }

    private static int[] parametersFor(AnalysisMethod analysisMethod) {
        return analysisMethod.getSignature().toParameterList(null).stream().mapToInt(AnalysisType::getId).toArray();
    }

    private static int[] parametersFor(HostedMethod hostedMethod) {
        return hostedMethod.getSignature().toParameterList(null).stream().mapToInt(HostedType::getTypeID).toArray();
    }

    private static int[] createSignature(int n2, int n3, int ... nArray) {
        int[] nArray2 = new int[2 + nArray.length];
        nArray2[0] = n2;
        nArray2[1] = n3;
        System.arraycopy(nArray, 0, nArray2, 2, nArray.length);
        return nArray2;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public int[] signature() {
        return this.signature;
    }

    public int hashCode() {
        int n2 = this.id;
        n2 = 31 * n2 ^ this.name.hashCode();
        n2 = 31 * n2 ^ Arrays.hashCode(this.signature);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ProfilingMethod profilingMethod = (ProfilingMethod)object;
        return this.id == profilingMethod.id && Objects.equals(this.name, profilingMethod.name) && Arrays.equals(this.signature, profilingMethod.signature);
    }

    public String toString() {
        return "ProfilingMethod{id=" + this.id + ", name='" + this.name + "', signature=" + Arrays.toString(this.signature) + "}";
    }
}

