/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.sampler.CallStackFrameMethodInfo;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.annotate.a;
import com.oracle.svm.enterprise.profiling.framework.CommonInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.ExperimentalOptions;
import com.oracle.svm.enterprise.profiling.framework.Metadata;
import com.oracle.svm.enterprise.profiling.framework.PeriodicProfileDumper;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.framework.SamplingData;
import com.oracle.svm.enterprise.profiling.l;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public final class ProfilingData
implements ProfileDumper.DumpableData {
    public static final String DEFAULT_PROFILE_DUMP_FILE = "default.iprof";
    private final CommonInstrumentationData instrumentationData;
    private final SamplingData samplingData;
    private final ExperimentalOptions experimentalOptions;
    private final PeriodicProfileDumper periodicProfileDumper;
    @a
    private Metadata metadata;

    @Fold
    public static ProfilingData singleton() {
        return (ProfilingData)ImageSingletons.lookup(ProfilingData.class);
    }

    public ProfilingData(CommonInstrumentationData commonInstrumentationData, SamplingData samplingData, ExperimentalOptions experimentalOptions) {
        this.instrumentationData = commonInstrumentationData;
        this.samplingData = samplingData;
        this.experimentalOptions = experimentalOptions;
        this.periodicProfileDumper = new PeriodicProfileDumper();
    }

    public static Path getPath() {
        Path path = Paths.get((String)Options.ProfilesDumpFile.getValue(), new String[0]).toAbsolutePath();
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            throw VMError.shouldNotReachHere((String)("Profile dump path is a directory: " + String.valueOf(path.toAbsolutePath()) + ". Please be sure that profile points to a file."));
        }
        if (path.getParent() == null || !Files.exists(path.getParent(), new LinkOption[0])) {
            throw VMError.shouldNotReachHere((String)("Directory " + String.valueOf(path.toAbsolutePath()) + " does not exist. Please be sure that the profile dump path is correct."));
        }
        return path;
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public CommonInstrumentationData commonInstrumentationData() {
        return this.instrumentationData;
    }

    public PeriodicProfileDumper periodicProfileDumper() {
        return this.periodicProfileDumper;
    }

    @Override
    public SamplingData samplingData() {
        return this.samplingData;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public static RuntimeSupport.Hook getShutdownHook() {
        return bl2 -> {
            if (!bl2) {
                return;
            }
            ProfileDumper profileDumper = ProfileDumper.create(ProfilingData.singleton(), ProfilingData.toAnalysisMethodId(), (Boolean)ProfileDumper.Options.ProfilesIncludeException.getValue(), ProfilingData.singleton().experimentalOptions);
            ProfileDumper.dumpToFile(profileDumper, ProfilingData.getPath(), (Boolean)Options.ProfilingDumpVerbose.getValue());
        };
    }

    public static Function<Integer, Integer> toAnalysisMethodId() {
        Function<Integer, Integer> function = ImageSingletons.contains(CallStackFrameMethodInfo.class) ? ((l)ImageSingletons.lookup(CallStackFrameMethodInfo.class))::V : n2 -> {
            throw new IllegalStateException();
        };
        return function;
    }

    public void reset() {
        this.instrumentationData.storage().reset();
    }

    public static class Options {
        static final RuntimeOptionKey<String> ProfilesDumpFile = new RuntimeOptionKey((Object)"default.iprof", new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Integer> ProfilingDumpPeriod = new RuntimeOptionKey((Object)-1, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        public static final RuntimeOptionKey<Boolean> ProfilingDumpVerbose = new RuntimeOptionKey((Object)Boolean.FALSE, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }
}

