/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.framework.ProfilingData;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class PeriodicProfileDumper {
    private ScheduledExecutorService periodicDumpingExecutor;

    private static void dump() {
        ProfileDumper.dumpToFile(ProfileDumper.create(ProfilingData.singleton(), ProfilingData.toAnalysisMethodId(), (Boolean)ProfileDumper.Options.ProfilesIncludeException.getValue()), ProfilingData.getPath(), (Boolean)ProfilingData.Options.ProfilingDumpVerbose.getValue());
    }

    public RuntimeSupport.Hook startupHook() {
        return bl2 -> {
            if (!bl2) {
                return;
            }
            Integer n2 = (Integer)ProfilingData.Options.ProfilingDumpPeriod.getValue();
            if (n2 < 1) {
                return;
            }
            this.periodicDumpingExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("PGOPeriodicDumper");
                return thread;
            });
            this.periodicDumpingExecutor.scheduleAtFixedRate(PeriodicProfileDumper::dump, n2.intValue(), n2.intValue(), TimeUnit.SECONDS);
        };
    }

    public RuntimeSupport.Hook shutdownHook() {
        return bl2 -> {
            if (!bl2) {
                return;
            }
            if (this.periodicDumpingExecutor != null) {
                this.periodicDumpingExecutor.shutdown();
            }
        };
    }
}

