/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.enterprise.profiling.framework.CommonInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.Metadata;
import com.oracle.svm.enterprise.profiling.framework.PGOInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.PGOSamplingData;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.framework.ProfilingMethod;
import com.oracle.svm.enterprise.profiling.framework.ProfilingType;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContextForest;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import com.oracle.svm.enterprise.profiling.loaders.ArrayBackedStorage;
import com.oracle.svm.enterprise.profiling.loaders.IprofContent;
import com.oracle.svm.util.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.collections.EconomicSet;

public final class PGOData
extends Record
implements ProfileDumper.DumpableData {
    private final Metadata metadata;
    private final PGOInstrumentationData commonInstrumentationData;
    private final PGOSamplingData samplingData;
    private final ProfileData.ProfileSource source;
    private final EconomicSet<String> recordedProfileCategories;

    public PGOData(Metadata metadata, PGOInstrumentationData pGOInstrumentationData, PGOSamplingData pGOSamplingData, ProfileData.ProfileSource profileSource, EconomicSet<String> economicSet) {
        this.metadata = metadata;
        this.commonInstrumentationData = pGOInstrumentationData;
        this.samplingData = pGOSamplingData;
        this.source = profileSource;
        this.recordedProfileCategories = economicSet;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PGOData.class, "metadata;commonInstrumentationData;samplingData;source;recordedProfileCategories", "metadata", "commonInstrumentationData", "samplingData", "source", "recordedProfileCategories"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PGOData.class, "metadata;commonInstrumentationData;samplingData;source;recordedProfileCategories", "metadata", "commonInstrumentationData", "samplingData", "source", "recordedProfileCategories"}, this);
    }

    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PGOData.class, "metadata;commonInstrumentationData;samplingData;source;recordedProfileCategories", "metadata", "commonInstrumentationData", "samplingData", "source", "recordedProfileCategories"}, this, object);
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    @Override
    public PGOInstrumentationData commonInstrumentationData() {
        return this.commonInstrumentationData;
    }

    @Override
    public PGOSamplingData samplingData() {
        return this.samplingData;
    }

    public ProfileData.ProfileSource source() {
        return this.source;
    }

    public EconomicSet<String> recordedProfileCategories() {
        return this.recordedProfileCategories;
    }

    private static final class BCITooLargeException
    extends IprofMappingException {
        private static final long serialVersionUID = 1L;

        BCITooLargeException(ProfilingType profilingType, ProfilingMethod profilingMethod, int n2, int n3) {
            super(String.format("BCI of %d for %s#%s is larger than the size of the method in the Universe (%d)", n2, profilingType.name(), profilingMethod.name(), n3), profilingMethod);
        }
    }

    private static final class UnmappedIDException
    extends IprofMappingException {
        UnmappedIDException(ProfilingType profilingType, ProfilingMethod profilingMethod) {
            super(String.format("Unknown method %s#%s", profilingType.name(), profilingMethod.name()), profilingMethod);
        }
    }

    private static abstract class IprofMappingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final ProfilingMethod iprofProfilingMethod;

        IprofMappingException(String string, ProfilingMethod profilingMethod) {
            super(string);
            this.iprofProfilingMethod = profilingMethod;
        }

        ProfilingMethod getMethod() {
            return this.iprofProfilingMethod;
        }
    }

    private record MethodNameAndSignature(String name, int[] signature) {
        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MethodNameAndSignature methodNameAndSignature = (MethodNameAndSignature)object;
            return Objects.equals(this.name, methodNameAndSignature.name) && Arrays.equals(this.signature, methodNameAndSignature.signature);
        }

        @Override
        public int hashCode() {
            int n2 = Objects.hash(this.name);
            n2 = 31 * n2 + Arrays.hashCode(this.signature);
            return n2;
        }
    }

    public static final class Builder {
        private final Metadata.Builder metadataBuilder;
        private final PGOInstrumentationData instrumentationData;
        private final PGOSamplingData samplingData;
        private final List<IprofContent> iprofs;
        private long numOfUnmatchedEntries;
        private long numOfEntries;
        BiConsumer<Long, Long> unmatchedEntriesConsumer;
        boolean printDroppedContexts;
        private GlobalIDMapper globalIDMapper = new NativeImageConfigureGlobalIDMapper(this);
        private ProfileData.ProfileSource source;
        private Map<Integer, UnresolvedJavaType> unresolvedJavaTypeMap;
        private final EconomicSet<String> recordedProfileCategories;

        public Builder(List<IprofContent> list) {
            this.iprofs = list;
            this.metadataBuilder = new Metadata.Builder();
            this.instrumentationData = new PGOInstrumentationData(new ArrayBackedStorage());
            this.samplingData = new PGOSamplingData();
            this.source = ProfileData.ProfileSource.UNKNOWN;
            this.recordedProfileCategories = EconomicSet.create();
        }

        public Builder setUniverseTypesAndMethods(Collection<AnalysisType> collection, Collection<AnalysisMethod> collection2, Map<Integer, AnalysisType> map, Map<Integer, AnalysisMethod> map2) {
            this.globalIDMapper = new AnalysisGlobalIDMapper(Objects.requireNonNull(collection), Objects.requireNonNull(collection2), map, map2);
            return this;
        }

        public Builder setUnmatchedEntriesConsumer(BiConsumer<Long, Long> biConsumer) {
            this.unmatchedEntriesConsumer = biConsumer;
            return this;
        }

        public Builder setPrintDroppedContexts(boolean bl2) {
            this.printDroppedContexts = bl2;
            return this;
        }

        public Builder setSource(ProfileData.ProfileSource profileSource) {
            this.source = profileSource;
            return this;
        }

        private void processIprofContent(IprofContent iprofContent) {
            this.addTypes(iprofContent);
            this.addMethods(iprofContent);
            this.addCallCounts(iprofContent);
            this.addConditionalCounts(iprofContent);
            this.addVirtualInvokeProfiles(iprofContent);
            this.addMonitorProfiles(iprofContent);
            this.addInstanceOfProfiles(iprofContent);
            this.addSamples(iprofContent);
            this.addTimestampProfiles(iprofContent);
        }

        private void addTimestampProfiles(IprofContent iprofContent) {
            Map<CallingContext, long[]> map = iprofContent.content().get("timestampProfiles");
            if (map == null) {
                return;
            }
            for (Map.Entry<CallingContext, long[]> entry : map.entrySet()) {
                CallingContext callingContext = this.globalIDMapper.convertToGlobalCallingContext(iprofContent, entry.getKey());
                if (callingContext == null) continue;
                long[] lArray = entry.getValue();
                assert (lArray.length == 1);
                CommonInstrumentationData.TimestampPayload timestampPayload = new CommonInstrumentationData.TimestampPayload();
                int n2 = this.metadataBuilder.addIfAbsent(callingContext, timestampPayload, () -> this.instrumentationData.reserveUniqueCounterIDSlots(lArray.length));
                this.instrumentationData.storage().sideEffectFreeWriteLong(this.instrumentationData.storage().stripID(), n2, 0, lArray[0]);
            }
        }

        private void addInstanceOfProfiles(IprofContent iprofContent) {
            this.addCounters(iprofContent, "instanceOfProfiles", lArray -> {
                if (((long[])lArray).length % 2 != 0) {
                    LogUtils.warning((String)("Instanceof profiles has corrupted records: " + Arrays.toString(lArray)));
                    return null;
                }
                ++this.numOfEntries;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i2 = 0; i2 < ((long[])lArray).length; i2 += 2) {
                    Integer n2 = this.globalIDMapper.convertToGlobalTypeID(iprofContent, (int)lArray[i2]);
                    if (n2 == null) {
                        ++this.numOfUnmatchedEntries;
                        continue;
                    }
                    arrayList.add(n2);
                }
                return new CommonInstrumentationData.InstanceOfPayload(Builder.listToIntArray(arrayList));
            }, this::reserveUniqueCounterIDSlotsBasedOnTypeIDAndCountRecord, Builder::extractCounterValuesFromTypeIDAndCounterRecord);
        }

        private void addSamples(IprofContent iprofContent) {
            Map<CallingContext, long[]> map = iprofContent.content().get("samplingProfiles");
            if (map == null) {
                return;
            }
            if (!map.isEmpty()) {
                this.recordedProfileCategories.add((Object)"samplingProfiles");
            }
            Set<Map.Entry<CallingContext, long[]>> set = map.entrySet();
            for (Map.Entry<CallingContext, long[]> entry : set) {
                ++this.numOfEntries;
                CallingContext callingContext = entry.getKey();
                CallingContext callingContext2 = this.globalIDMapper.convertToGlobalCallingContext(iprofContent, callingContext);
                if (callingContext2 != null) {
                    this.samplingData.addSample(callingContext2, entry.getValue()[0]);
                    continue;
                }
                ++this.numOfUnmatchedEntries;
            }
        }

        private void addMonitorProfiles(IprofContent iprofContent) {
            Map<CallingContext, long[]> map = iprofContent.content().get("monitorProfiles");
            if (map == null) {
                return;
            }
            Set<Map.Entry<CallingContext, long[]>> set = map.entrySet();
            if (set.isEmpty()) {
                return;
            }
            this.recordedProfileCategories.add((Object)"monitorProfiles");
            Map.Entry<CallingContext, long[]> entry = set.iterator().next();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            long[] lArray = entry.getValue();
            for (int i2 = 0; i2 < lArray.length; i2 += 2) {
                ++this.numOfEntries;
                int n2 = (int)lArray[i2];
                Integer n3 = this.globalIDMapper.convertToGlobalTypeID(iprofContent, n2);
                if (n3 != null && n3 > 0) {
                    hashSet.add(n3);
                    long l2 = this.instrumentationData.readTotalMonitorCount(n3);
                    this.instrumentationData.sideEffectFreeWriteMonitorCount(this.instrumentationData.storage().stripID(), n3, l2 + lArray[i2 + 1]);
                    continue;
                }
                ++this.numOfUnmatchedEntries;
            }
            this.metadataBuilder.setKnownTypeIDs(Builder.listToIntArray(new ArrayList<Integer>(hashSet)));
        }

        private void addVirtualInvokeProfiles(IprofContent iprofContent) {
            this.addCounters(iprofContent, "virtualInvokeProfiles", lArray -> {
                if (((long[])lArray).length % 2 != 0) {
                    LogUtils.warning((String)("Virtual invoke profiles has corrupted records: " + Arrays.toString(lArray)));
                    return null;
                }
                ++this.numOfEntries;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i2 = 0; i2 < ((long[])lArray).length; i2 += 2) {
                    Integer n2 = this.globalIDMapper.convertToGlobalTypeID(iprofContent, (int)lArray[i2]);
                    if (n2 == null || n2 <= 0) {
                        ++this.numOfUnmatchedEntries;
                        continue;
                    }
                    arrayList.add(n2);
                }
                return new CommonInstrumentationData.VirtualCallPayload(Builder.listToIntArray(arrayList));
            }, this::reserveUniqueCounterIDSlotsBasedOnTypeIDAndCountRecord, Builder::extractCounterValuesFromTypeIDAndCounterRecord);
        }

        private static int[] listToIntArray(List<Integer> list) {
            int[] nArray = new int[list.size()];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                nArray[i2] = list.get(i2);
            }
            return nArray;
        }

        private void addConditionalCounts(IprofContent iprofContent) {
            this.addCounters(iprofContent, "conditionalProfiles", lArray -> {
                if (((long[])lArray).length % 3 != 0) {
                    LogUtils.warning((String)("Conditional profiles has corrupted records: " + Arrays.toString(lArray)));
                    return null;
                }
                int[] nArray = new int[((long[])lArray).length / 3];
                int[] nArray2 = new int[((long[])lArray).length / 3];
                for (int i2 = 0; i2 < ((long[])lArray).length; i2 += 3) {
                    nArray[i2 / 3] = (int)lArray[i2];
                    nArray2[i2 / 3] = (int)lArray[i2 + 1];
                }
                return new CommonInstrumentationData.SwitchPayload(nArray, nArray2);
            }, lArray -> this.instrumentationData.reserveUniqueCounterIDSlots(((long[])lArray).length / 3), lArray -> {
                long[] lArray2 = new long[((long[])lArray).length / 3];
                for (int i2 = 0; i2 < ((long[])lArray).length; i2 += 3) {
                    lArray2[i2 / 3] = lArray[i2 + 2];
                }
                return lArray2;
            });
        }

        private void addCallCounts(IprofContent iprofContent) {
            this.addCounters(iprofContent, "callCountProfiles", lArray -> new CommonInstrumentationData.MethodEntryPayload(), lArray -> this.instrumentationData.reserveUniqueCounterIDSlots(((long[])lArray).length), lArray -> lArray);
        }

        private void addCounters(IprofContent iprofContent, String string, Function<long[], CallingContextForest.Payload> function, Function<long[], Integer> function2, Function<long[], long[]> function3) {
            Map<CallingContext, long[]> map = iprofContent.content().get(string);
            if (map == null) {
                return;
            }
            if (!map.isEmpty()) {
                this.recordedProfileCategories.add((Object)string);
            }
            for (Map.Entry<CallingContext, long[]> entry : map.entrySet()) {
                long[] lArray;
                CallingContextForest.Payload payload;
                CallingContext callingContext = this.globalIDMapper.convertToGlobalCallingContext(iprofContent, entry.getKey());
                if (callingContext == null || (payload = function.apply(lArray = entry.getValue())) == null) continue;
                int n2 = this.metadataBuilder.addIfAbsent(callingContext, payload, () -> (Integer)function2.apply(lArray));
                long[] lArray2 = function3.apply(lArray);
                for (int i2 = 0; i2 < lArray2.length; ++i2) {
                    int n3 = this.instrumentationData.storage().counterWordSize().byteCount() * i2;
                    long l2 = this.instrumentationData.storage().readLong(this.instrumentationData.storage().stripID(), n2, n3);
                    this.instrumentationData.storage().sideEffectFreeWriteLong(this.instrumentationData.storage().stripID(), n2, n3, l2 + lArray2[i2]);
                }
            }
        }

        private void logCallingContext(IprofContent iprofContent, CallingContext callingContext, IprofMappingException iprofMappingException) {
            if (!this.printDroppedContexts) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            callingContext.traverseFromCallee(codePosition -> {
                int n2 = codePosition.methodID();
                ProfilingMethod profilingMethod = iprofContent.idToProfilingMethod().get(n2);
                int n3 = profilingMethod.signature()[0];
                ProfilingType profilingType = iprofContent.idToProfilingType().get(n3);
                stringBuilder.append(profilingType.name()).append("#").append(profilingMethod.name()).append(":").append(codePosition.bci());
                if (profilingMethod == iprofMappingException.getMethod()) {
                    stringBuilder.append("?");
                }
                stringBuilder.append("<");
            });
            LogUtils.warning((String)"[PGO] Dropping calling-context for (Method marked with ? caused %s) %s.".formatted(iprofMappingException.getMessage(), stringBuilder));
        }

        private void addMethods(IprofContent iprofContent) {
            for (ProfilingMethod profilingMethod : iprofContent.idToProfilingMethod().values()) {
                ProfilingMethod profilingMethod2 = this.globalIDMapper.convertToGlobalProfilingMethod(iprofContent, profilingMethod);
                if (profilingMethod2 == null) continue;
                this.metadataBuilder.add(profilingMethod2);
            }
        }

        private void addTypes(IprofContent iprofContent) {
            for (ProfilingType profilingType : iprofContent.idToProfilingType().values()) {
                Integer n2 = this.globalIDMapper.mapTypeNameToGlobalID(profilingType.name());
                if (n2 == null) continue;
                this.metadataBuilder.add(this.globalIDMapper.mapGlobalIDToProfilingType(n2));
            }
        }

        public PGOData build() {
            for (IprofContent iprofContent : this.iprofs) {
                this.processIprofContent(iprofContent);
            }
            if (this.unmatchedEntriesConsumer != null) {
                this.unmatchedEntriesConsumer.accept(this.numOfUnmatchedEntries, this.numOfEntries);
            }
            return new PGOData(this.metadataBuilder.build(), this.instrumentationData, this.samplingData, this.source, this.recordedProfileCategories);
        }

        public Builder trackUnmatchedTypes(Map<Integer, UnresolvedJavaType> map) {
            this.unresolvedJavaTypeMap = map;
            return this;
        }

        private Integer reserveUniqueCounterIDSlotsBasedOnTypeIDAndCountRecord(long[] lArray) {
            return this.instrumentationData.reserveUniqueCounterIDSlots(lArray.length / 2);
        }

        private static long[] extractCounterValuesFromTypeIDAndCounterRecord(long[] lArray) {
            long[] lArray2 = new long[lArray.length / 2];
            for (int i2 = 0; i2 < lArray.length; i2 += 2) {
                lArray2[i2 / 2] = lArray[i2 + 1];
            }
            return lArray2;
        }

        private final class NativeImageConfigureGlobalIDMapper
        extends GlobalIDMapper {
            int globalTypeIDCounter = 1;
            int globalMethodIDCCounter = 1;

            private NativeImageConfigureGlobalIDMapper(Builder builder) {
            }

            @Override
            Integer mapTypeNameToGlobalID(String string) {
                return this.typeNamesToGlobalIDs.computeIfAbsent(string, string2 -> {
                    int n2 = this.globalTypeIDCounter++;
                    ProfilingType profilingType = new ProfilingType(n2, string);
                    this.globalIDToProfilingType.put(n2, profilingType);
                    return n2;
                });
            }

            @Override
            ProfilingType mapGlobalIDToProfilingType(Integer n2) {
                return (ProfilingType)this.globalIDToProfilingType.get(n2);
            }

            @Override
            Integer mapMethodNameAndSignatureToGlobalID(MethodNameAndSignature methodNameAndSignature) {
                return this.methodNameAndSignatureToGlobalID.computeIfAbsent(methodNameAndSignature, methodNameAndSignature2 -> {
                    int n2 = this.globalMethodIDCCounter++;
                    this.globalIDToProfilingMethod.put(n2, new ProfilingMethod(n2, methodNameAndSignature.name(), methodNameAndSignature.signature()));
                    return n2;
                });
            }

            @Override
            ProfilingMethod mapGlobalIDToProfilingMethod(Integer n2) {
                return (ProfilingMethod)this.globalIDToProfilingMethod.get(n2);
            }
        }

        private abstract class GlobalIDMapper {
            protected final Map<String, Integer> typeNamesToGlobalIDs = new HashMap<String, Integer>();
            protected final Map<MethodNameAndSignature, Integer> methodNameAndSignatureToGlobalID = new HashMap<MethodNameAndSignature, Integer>();
            protected final Map<Integer, ProfilingType> globalIDToProfilingType = new HashMap<Integer, ProfilingType>();
            protected final Map<Integer, ProfilingMethod> globalIDToProfilingMethod = new HashMap<Integer, ProfilingMethod>();

            private GlobalIDMapper() {
            }

            abstract Integer mapTypeNameToGlobalID(String var1);

            abstract ProfilingType mapGlobalIDToProfilingType(Integer var1);

            abstract Integer mapMethodNameAndSignatureToGlobalID(MethodNameAndSignature var1);

            abstract ProfilingMethod mapGlobalIDToProfilingMethod(Integer var1);

            private ProfilingMethod convertToGlobalProfilingMethod(IprofContent iprofContent, ProfilingMethod profilingMethod) {
                int[] nArray = this.convertToGlobalMethodSignature(iprofContent, profilingMethod);
                if (nArray == null) {
                    return null;
                }
                Integer n2 = this.mapMethodNameAndSignatureToGlobalID(new MethodNameAndSignature(profilingMethod.name(), nArray));
                if (n2 == null) {
                    return null;
                }
                return this.mapGlobalIDToProfilingMethod(n2);
            }

            private Integer convertToGlobalTypeID(IprofContent iprofContent, int n2) {
                ProfilingType profilingType = iprofContent.idToProfilingType().get(n2);
                if (profilingType == null) {
                    LogUtils.warning((String)("Unable to convert iprof type with id " + n2 + " to global type."));
                    return null;
                }
                return this.mapTypeNameToGlobalID(profilingType.name());
            }

            private int[] convertToGlobalMethodSignature(IprofContent iprofContent, ProfilingMethod profilingMethod) {
                int[] nArray = new int[profilingMethod.signature().length];
                for (int i2 = 0; i2 < profilingMethod.signature().length; ++i2) {
                    int n2 = profilingMethod.signature()[i2];
                    Integer n3 = this.convertToGlobalTypeID(iprofContent, n2);
                    if (n3 == null || n3 <= 0) {
                        return null;
                    }
                    nArray[i2] = n3;
                }
                return nArray;
            }

            private CallingContext convertToGlobalCallingContext(IprofContent iprofContent, CallingContext callingContext) {
                ++Builder.this.numOfEntries;
                try {
                    ArrayList<CodePosition> arrayList = new ArrayList<CodePosition>();
                    callingContext.traverseFromCallee(codePosition -> arrayList.add(this.globalCodePosition(iprofContent, (CodePosition)codePosition)));
                    return CallingContext.create(arrayList);
                }
                catch (IprofMappingException iprofMappingException) {
                    ++Builder.this.numOfUnmatchedEntries;
                    Builder.this.logCallingContext(iprofContent, callingContext, iprofMappingException);
                    return null;
                }
            }

            protected CodePosition globalCodePosition(IprofContent iprofContent, CodePosition codePosition) {
                ProfilingMethod profilingMethod = iprofContent.idToProfilingMethod().get(codePosition.methodID());
                ProfilingMethod profilingMethod2 = this.convertToGlobalProfilingMethod(iprofContent, profilingMethod);
                if (profilingMethod2 == null) {
                    throw new UnmappedIDException(iprofContent.idToProfilingType().get(profilingMethod.signature()[0]), profilingMethod);
                }
                return new CodePosition(profilingMethod2.id(), codePosition.bci());
            }
        }

        private final class AnalysisGlobalIDMapper
        extends GlobalIDMapper {
            private final Map<Integer, AnalysisType> globalIDToAnalysisType;
            private final Map<Integer, AnalysisMethod> globalIDToAnalysisMethod;

            AnalysisGlobalIDMapper(Collection<AnalysisType> collection, Collection<AnalysisMethod> collection2, Map<Integer, AnalysisType> map, Map<Integer, AnalysisMethod> map2) {
                this.globalIDToAnalysisType = map;
                this.globalIDToAnalysisMethod = map2;
                this.populateGlobalIDMaps(collection, collection2);
            }

            private void populateGlobalIDMaps(Collection<AnalysisType> collection, Collection<AnalysisMethod> collection2) {
                for (AnalysisType analysisType : collection) {
                    int n2 = analysisType.getId();
                    this.typeNamesToGlobalIDs.put(analysisType.toClassName(), n2);
                    this.globalIDToProfilingType.put(n2, new ProfilingType(n2, analysisType.toClassName()));
                    this.globalIDToAnalysisType.put(n2, analysisType);
                }
                for (AnalysisMethod analysisMethod : collection2) {
                    ProfilingMethod profilingMethod = new ProfilingMethod(analysisMethod);
                    this.globalIDToProfilingMethod.put(analysisMethod.getId(), profilingMethod);
                    this.methodNameAndSignatureToGlobalID.put(new MethodNameAndSignature(profilingMethod.name(), profilingMethod.signature()), analysisMethod.getId());
                    this.globalIDToAnalysisMethod.put(analysisMethod.getId(), analysisMethod);
                }
            }

            @Override
            public Integer mapMethodNameAndSignatureToGlobalID(MethodNameAndSignature methodNameAndSignature) {
                return (Integer)this.methodNameAndSignatureToGlobalID.get(methodNameAndSignature);
            }

            @Override
            public ProfilingMethod mapGlobalIDToProfilingMethod(Integer n2) {
                return (ProfilingMethod)this.globalIDToProfilingMethod.get(n2);
            }

            @Override
            protected CodePosition globalCodePosition(IprofContent iprofContent, CodePosition codePosition) {
                CodePosition codePosition2 = super.globalCodePosition(iprofContent, codePosition);
                AnalysisMethod analysisMethod = this.globalIDToAnalysisMethod.get(codePosition2.methodID());
                int n2 = analysisMethod.getCodeSize();
                if (n2 > 0 && codePosition2.bci() >= n2) {
                    ProfilingMethod profilingMethod = iprofContent.idToProfilingMethod().get(codePosition.methodID());
                    ProfilingType profilingType = iprofContent.idToProfilingType().get(profilingMethod.signature[0]);
                    throw new BCITooLargeException(profilingType, profilingMethod, codePosition2.bci(), n2);
                }
                return codePosition2;
            }

            @Override
            public Integer mapTypeNameToGlobalID(String string) {
                return this.typeNamesToGlobalIDs.computeIfAbsent(string, string2 -> {
                    int n2 = -1 * this.typeNamesToGlobalIDs.size();
                    ProfilingType profilingType = new ProfilingType(n2, string);
                    this.globalIDToProfilingType.put(n2, profilingType);
                    Builder.this.unresolvedJavaTypeMap.put(n2, UnresolvedJavaType.create((String)(string + ";")));
                    return n2;
                });
            }

            @Override
            public ProfilingType mapGlobalIDToProfilingType(Integer n2) {
                return (ProfilingType)this.globalIDToProfilingType.get(n2);
            }
        }
    }
}

