/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jfr.JfrEvent;
import com.oracle.svm.core.jfr.SubstrateJVM;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JfrEnterpriseHooks {
    private static final int SAMPLING_PERIOD_MS = 10;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private JfrEnterpriseHooks() {
        throw new IllegalStateException("Should not instantiate!");
    }

    public static RuntimeSupport.Hook samplerStartupHook() {
        return bl2 -> {
            if (bl2) {
                SubstrateJVM substrateJVM = SubstrateJVM.get();
                substrateJVM.setMethodSamplingInterval(JfrEvent.ExecutionSample.getId(), 10L);
                substrateJVM.setStackDepth(((Integer)SubstrateOptions.ConcealedOptions.MaxJavaStackTraceDepth.getValue()).intValue());
                substrateJVM.createJFR(false);
                substrateJVM.beginRecording();
            }
        };
    }

    public static RuntimeSupport.Hook samplerShutdownHook() {
        return bl2 -> {
            if (bl2) {
                SubstrateJVM substrateJVM = SubstrateJVM.get();
                substrateJVM.endRecording();
                substrateJVM.destroyJFR();
            }
        };
    }
}

