/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.graalvm.collections.EconomicMap;

public class ProfilingJsonUtils {
    public static String getString(Object object, String string) {
        return ProfilingJsonUtils.ensureType(ProfilingJsonUtils.getValue(object, string), String.class);
    }

    public static Object getValue(Object object, String string) {
        return ProfilingJsonUtils.ensureType(object, EconomicMap.class).get((Object)string);
    }

    public static <T> List<T> getAndMapList(Object object, String string, Function<Object, T> function) {
        return ProfilingJsonUtils.getOptional(object, string, List.class).map(list -> {
            ArrayList arrayList = new ArrayList(list.size());
            for (Object e2 : list) {
                arrayList.add(function.apply(e2));
            }
            return arrayList;
        }).orElse(null);
    }

    public static int getInt(Object object, String string) {
        return ProfilingJsonUtils.getOptional(object, string, Integer.class).orElse(0);
    }

    public static <T> T getPrimitiveArray(Object object, String string, Class<T> clazz) {
        assert (clazz.isArray() && clazz.getComponentType().isPrimitive());
        return ProfilingJsonUtils.getOptional(object, string, List.class).map(list -> {
            Object object = Array.newInstance(clazz.getComponentType(), list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Array.set(object, i2, list.get(i2));
            }
            return clazz.cast(object);
        }).orElse(null);
    }

    private static <T> Optional<T> getOptional(Object object, String string, Class<T> clazz) {
        return Optional.ofNullable(ProfilingJsonUtils.ensureType(ProfilingJsonUtils.getValue(object, string), clazz));
    }

    private static <T> T ensureType(Object object, Class<T> clazz) {
        return clazz.cast(object);
    }
}

