/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.jitprofiling.vtune;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.UnmanagedMemoryUtil;
import com.oracle.svm.core.code.CompilationResultFrameTree;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.graal.stackvalue.UnsafeStackValue;
import com.oracle.svm.core.memory.NativeMemory;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.jitprofiling.vtune.Jitprofiling;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

final class VTuneDynamicCodeObserver
implements InstalledCodeObserver {
    private final DebugContext Fo;
    private final CompilationResult Fp;
    private final Pointer Fq;
    private int Fr;
    private final Path Fs;

    VTuneDynamicCodeObserver(DebugContext debugContext, CompilationResult compilationResult, Pointer pointer) {
        this.Fo = debugContext;
        this.Fp = compilationResult;
        this.Fq = pointer;
        this.Fs = VTuneDynamicCodeObserver.kV();
    }

    private static Path kV() {
        String string = (String)com.oracle.svm.enterprise.jitprofiling.vtune.d.VTuneRuntimeSourceDestDir.getValue();
        if (string != null) {
            return Path.of(string, new String[0]);
        }
        Path path = Path.of("sources", new String[0]);
        Path path2 = Path.of(ProcessProperties.getExecutableName(), new String[0]).getParent();
        if (path2 != null) {
            path = path2.resolve(path);
        }
        return path;
    }

    public InstalledCodeObserver.InstalledCodeObserverHandle install() {
        if (Jitprofiling.iJIT_IsProfilingActive() != Jitprofiling.a.iJIT_SAMPLING_ON) {
            return (InstalledCodeObserver.InstalledCodeObserverHandle)Word.nullPointer();
        }
        Object object = this.Fp.getName();
        if (object == null || ((String)object).isEmpty()) {
            object = "UnnamedCU";
        }
        object = "jit " + (String)object;
        CompilationResultFrameTree.CallNode callNode = new CompilationResultFrameTree.Builder(this.Fo, this.Fp.getTargetCodeSize(), Integer.MAX_VALUE, true, true).build(this.Fp);
        if (callNode == null) {
            return (InstalledCodeObserver.InstalledCodeObserverHandle)Word.nullPointer();
        }
        this.Fr = 0;
        new d().a((String)object, callNode);
        if (this.Fr == 0) {
            return (InstalledCodeObserver.InstalledCodeObserverHandle)Word.nullPointer();
        }
        JITMethodHandle jITMethodHandle = (JITMethodHandle)NativeMemory.malloc((int)SizeOf.get(JITMethodHandle.class), (NmtCategory)NmtCategory.Internal);
        jITMethodHandle.setAccessor((InstalledCodeObserver.InstalledCodeObserverHandleAccessor)ImageSingletons.lookup(b.class));
        jITMethodHandle.setJitMethodID(this.Fr);
        return jITMethodHandle;
    }

    private String a(StackTraceElement stackTraceElement) {
        Path path = this.Fs.resolve(VTuneDynamicCodeObserver.b(stackTraceElement));
        if (((Boolean)com.oracle.svm.enterprise.jitprofiling.vtune.d.VTuneAbsoluteFilenames.getValue()).booleanValue()) {
            try {
                return path.toAbsolutePath().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return path.toString();
    }

    private static String b(StackTraceElement stackTraceElement) {
        String string = stackTraceElement.getClassName();
        String string2 = string.substring(0, Math.max(0, string.lastIndexOf(46)));
        StringBuilder stringBuilder = new StringBuilder(string2.replace('.', File.separatorChar));
        if (stringBuilder.length() > 0) {
            stringBuilder.append(File.separatorChar);
        }
        stringBuilder.append(stackTraceElement.getFileName());
        return stringBuilder.toString();
    }

    private static String a(CompilationResultFrameTree.CallNode callNode) {
        return callNode.frame.getMethod().format("%H:%n(%P)").replace(".", ":");
    }

    private final class d
    implements CompilationResultFrameTree.Visitor {
        private CCharPointer Fz;

        private d() {
        }

        public void a(String string, CompilationResultFrameTree.CallNode callNode) {
            try (DebugContext.Scope scope = VTuneDynamicCodeObserver.this.Fo.scope((Object)"VTuneEventsEmitter", (Object)callNode);){
                VTuneDynamicCodeObserver.this.Fo.log("Running VTuneEventsEmitter for %s", (Object)string);
                try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)string);){
                    this.Fz = cCharPointerHolder.get();
                    callNode.visit((CompilationResultFrameTree.Visitor)this, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                throw VTuneDynamicCodeObserver.this.Fo.handle(throwable);
            }
        }

        public void apply(CompilationResultFrameTree.FrameNode frameNode, Object ... objectArray) {
            int n2;
            if (!(frameNode instanceof CompilationResultFrameTree.CallNode)) {
                return;
            }
            CompilationResultFrameTree.CallNode callNode = (CompilationResultFrameTree.CallNode)frameNode;
            if (objectArray.length == 0) {
                n2 = this.b(callNode);
            } else {
                int n3 = (Integer)objectArray[0];
                n2 = this.a(callNode, n3);
            }
            frameNode.visitChildren((CompilationResultFrameTree.Visitor)this, new Object[]{n2});
        }

        private int b(CompilationResultFrameTree.CallNode callNode) {
            Serializable serializable;
            VTuneDynamicCodeObserver.this.Fo.log("%nEmitting METHOD_LOAD event for %s", (Object)callNode);
            if (VTuneDynamicCodeObserver.this.Fo.isLogEnabled(4)) {
                serializable = new StringBuilder();
                CompilationResultFrameTree.dump((CompilationResultFrameTree.FrameNode)callNode, ((StringBuilder)serializable)::append, (boolean)false, (boolean)false, (int)1);
                VTuneDynamicCodeObserver.this.Fo.log("%s", (Object)serializable);
            }
            serializable = callNode.getStackTraceElement();
            try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.a(callNode));){
                int n2;
                block20: {
                    CTypeConversion.CCharPointerHolder cCharPointerHolder2 = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.this.a((StackTraceElement)serializable));
                    try {
                        int n3 = SizeOf.get(Jitprofiling.iJIT_Method_Load_V2.class);
                        Jitprofiling.iJIT_Method_Load_V2 iJIT_Method_Load_V22 = (Jitprofiling.iJIT_Method_Load_V2)UnsafeStackValue.get((int)n3);
                        UnmanagedMemoryUtil.fill((Pointer)((Pointer)iJIT_Method_Load_V22), (UnsignedWord)Word.unsigned((int)n3), (byte)0);
                        int n4 = Jitprofiling.iJIT_GetNewMethodID();
                        VMError.guarantee((n4 != 0 ? 1 : 0) != 0);
                        iJIT_Method_Load_V22.set_method_id(n4);
                        iJIT_Method_Load_V22.set_module_name(this.Fz);
                        iJIT_Method_Load_V22.set_method_name(cCharPointerHolder.get());
                        iJIT_Method_Load_V22.set_method_load_address((PointerBase)VTuneDynamicCodeObserver.this.Fq.add(callNode.getStartPos()));
                        iJIT_Method_Load_V22.set_method_size(callNode.getSpan());
                        iJIT_Method_Load_V22.set_source_file_name(cCharPointerHolder2.get());
                        try (c c2 = c.a(callNode, VTuneDynamicCodeObserver.this.Fo);){
                            iJIT_Method_Load_V22.set_line_number_table(c2.Fy.M(0));
                            iJIT_Method_Load_V22.set_line_number_size(c2.Fx);
                            Jitprofiling.iJIT_NotifyEvent(Jitprofiling.iJVM_EVENT_TYPE_METHOD_LOAD_FINISHED_V2(), iJIT_Method_Load_V22);
                        }
                        VMError.guarantee((VTuneDynamicCodeObserver.this.Fr == 0 ? 1 : 0) != 0);
                        VTuneDynamicCodeObserver.this.Fr = n4;
                        n2 = n4;
                        if (cCharPointerHolder2 == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointerHolder2 != null) {
                            try {
                                cCharPointerHolder2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    cCharPointerHolder2.close();
                }
                return n2;
            }
        }

        private int a(CompilationResultFrameTree.CallNode callNode, int n2) {
            Serializable serializable;
            VTuneDynamicCodeObserver.this.Fo.log("%nEmitting METHOD_LOAD_INLINE event for %s", (Object)callNode);
            if (VTuneDynamicCodeObserver.this.Fo.isLogEnabled(4)) {
                serializable = new StringBuilder();
                CompilationResultFrameTree.dump((CompilationResultFrameTree.FrameNode)callNode, ((StringBuilder)serializable)::append, (boolean)false, (boolean)false, (int)1);
                VTuneDynamicCodeObserver.this.Fo.log("%s", (Object)serializable);
            }
            serializable = callNode.getStackTraceElement();
            try (CTypeConversion.CCharPointerHolder cCharPointerHolder = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.a(callNode));){
                int n3;
                block20: {
                    CTypeConversion.CCharPointerHolder cCharPointerHolder2 = CTypeConversion.toCString((CharSequence)VTuneDynamicCodeObserver.this.a((StackTraceElement)serializable));
                    try {
                        int n4 = SizeOf.get(Jitprofiling.iJIT_Method_Inline_Load.class);
                        Jitprofiling.iJIT_Method_Inline_Load iJIT_Method_Inline_Load2 = (Jitprofiling.iJIT_Method_Inline_Load)UnsafeStackValue.get((int)n4);
                        UnmanagedMemoryUtil.fill((Pointer)((Pointer)iJIT_Method_Inline_Load2), (UnsignedWord)Word.unsigned((int)n4), (byte)0);
                        int n5 = Jitprofiling.iJIT_GetNewMethodID();
                        VMError.guarantee((n5 != 0 ? 1 : 0) != 0);
                        iJIT_Method_Inline_Load2.set_method_id(n5);
                        iJIT_Method_Inline_Load2.set_parent_method_id(n2);
                        iJIT_Method_Inline_Load2.set_method_name(cCharPointerHolder.get());
                        iJIT_Method_Inline_Load2.set_method_load_address((PointerBase)VTuneDynamicCodeObserver.this.Fq.add(callNode.getStartPos()));
                        iJIT_Method_Inline_Load2.set_method_size(callNode.getSpan());
                        iJIT_Method_Inline_Load2.set_source_file_name(cCharPointerHolder2.get());
                        try (c c2 = c.a(callNode, VTuneDynamicCodeObserver.this.Fo);){
                            iJIT_Method_Inline_Load2.set_line_number_table(c2.Fy.M(0));
                            iJIT_Method_Inline_Load2.set_line_number_size(c2.Fx);
                            Jitprofiling.iJIT_NotifyEvent(Jitprofiling.iJVM_EVENT_TYPE_METHOD_INLINE_LOAD_FINISHED(), iJIT_Method_Inline_Load2);
                        }
                        n3 = n5;
                        if (cCharPointerHolder2 == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (cCharPointerHolder2 != null) {
                            try {
                                cCharPointerHolder2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    cCharPointerHolder2.close();
                }
                return n3;
            }
        }
    }

    @RawStructure
    private static interface JITMethodHandle
    extends InstalledCodeObserver.InstalledCodeObserverHandle {
        @RawField
        public int getJitMethodID();

        @RawField
        public void setJitMethodID(int var1);
    }

    static class b
    implements InstalledCodeObserver.InstalledCodeObserverHandleAccessor {
        b() {
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void release(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            int n2 = SizeOf.get(Jitprofiling.iJIT_Method_Load_V2.class);
            Jitprofiling.iJIT_Method_Load_V2 iJIT_Method_Load_V22 = (Jitprofiling.iJIT_Method_Load_V2)StackValue.get((int)n2);
            UnmanagedMemoryUtil.fill((Pointer)((Pointer)iJIT_Method_Load_V22), (UnsignedWord)Word.unsigned((int)n2), (byte)0);
            iJIT_Method_Load_V22.set_method_id(((JITMethodHandle)installedCodeObserverHandle).getJitMethodID());
            Jitprofiling.iJIT_NotifyEvent(Jitprofiling.iJVM_EVENT_TYPE_METHOD_UNLOAD_START(), iJIT_Method_Load_V22);
            NativeMemory.free((PointerBase)installedCodeObserverHandle);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void releaseOnTearDown(InstalledCodeObserver.InstalledCodeObserverHandle installedCodeObserverHandle) {
            this.release(installedCodeObserverHandle);
        }
    }

    private static final class c
    implements CompilationResultFrameTree.Visitor,
    AutoCloseable {
        private final CompilationResultFrameTree.CallNode Ft;
        private final DebugContext Fu;
        private PinnedObject Fv;
        private CompilationResultFrameTree.FrameNode Fw;
        int Fx;
        Jitprofiling.LineNumberInfo Fy;

        private c(CompilationResultFrameTree.CallNode callNode, DebugContext debugContext) {
            this.Ft = callNode;
            this.Fu = debugContext;
        }

        public static c a(CompilationResultFrameTree.CallNode callNode, DebugContext debugContext) {
            c c2 = new c(callNode, debugContext);
            c2.Fx = 0;
            c2.Fy = (Jitprofiling.LineNumberInfo)Word.nullPointer();
            c2.Fw = null;
            callNode.visit((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            callNode.visitChildren((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            int n2 = SizeOf.get(Jitprofiling.LineNumberInfo.class) * c2.Fx;
            debugContext.log(" Creating %d LineNumberInfo(s) (%d bytes) for %s", (Object)c2.Fx, (Object)n2, (Object)callNode);
            c2.Fv = PinnedObject.create((Object)new byte[n2]);
            c2.Fx = 0;
            c2.Fy = (Jitprofiling.LineNumberInfo)c2.Fv.addressOfArrayElement(0);
            callNode.visit((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            callNode.visitChildren((CompilationResultFrameTree.Visitor)c2, new Object[0]);
            return c2;
        }

        public void apply(CompilationResultFrameTree.FrameNode frameNode, Object ... objectArray) {
            if (this.Fy.isNonNull()) {
                Jitprofiling.LineNumberInfo lineNumberInfo = this.Fy.M(this.Fx);
                BytecodePosition bytecodePosition = frameNode.frame;
                if (frameNode != this.Ft && frameNode instanceof CompilationResultFrameTree.CallNode) {
                    bytecodePosition = bytecodePosition.getCaller();
                }
                StackTraceElement stackTraceElement = CompilationResultFrameTree.SourcePositionSupplier.getStackTraceElement((BytecodePosition)bytecodePosition);
                this.Fu.log("  Write LineNumberInfo entry for: %s", (Object)frameNode);
                int n2 = stackTraceElement.getLineNumber();
                lineNumberInfo.setLineNumber(n2);
                int n3 = frameNode.getEndPos() - this.Ft.getStartPos();
                if (frameNode == this.Ft && this.Fw != null) {
                    n3 = Math.max(0, this.Fw.getStartPos() - this.Ft.getStartPos() - 1);
                }
                lineNumberInfo.setOffset(n3);
                this.Fu.log("  LineNumberInfo lineNumber = %d, offset = %d", n2, n3);
                VMError.guarantee((n3 >= 0 ? 1 : 0) != 0, (String)"LineNumberInfo entry with negative offset makes no sense");
            } else if (frameNode != this.Ft && this.Fw == null) {
                this.Fw = frameNode;
            }
            ++this.Fx;
        }

        @Override
        public void close() {
            this.Fv.close();
        }
    }

    static final class a
    implements InstalledCodeObserver.Factory {
        a() {
        }

        public InstalledCodeObserver create(DebugContext debugContext, SharedMethod sharedMethod, CompilationResult compilationResult, Pointer pointer, int n2) {
            if (compilationResult == null) {
                return null;
            }
            return new VTuneDynamicCodeObserver(debugContext, compilationResult, pointer);
        }
    }
}

