/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.substitute;

import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ClassUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.graal.compiler.util.json.JsonWriter;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public interface b
extends AutoCloseable {
    @Override
    public void close();

    public void a(com.oracle.svm.enterprise.hosted.substitute.a var1, Class<?> var2, Class<?> var3);

    public static b h(MetaAccessProvider metaAccessProvider) {
        String string = d.o(c.WriteSubstitutionChecksum);
        if (string != null) {
            return new b();
        }
        String string2 = d.o(c.VerifySubstitutionChecksum);
        if (string2 != null) {
            return new a(metaAccessProvider);
        }
        throw VMError.shouldNotReachHere((String)"isEnabled() should not be true");
    }

    public static boolean q() {
        return c.WriteSubstitutionChecksum.getValue() != null || c.VerifySubstitutionChecksum.getValue() != null;
    }

    public static class c {
        public static final HostedOptionKey<String> WriteSubstitutionChecksum = new HostedOptionKey(null);
        public static final HostedOptionKey<String> VerifySubstitutionChecksum = new HostedOptionKey(null);
        public static final HostedOptionKey<String> SubstitutionChecksumResult = new HostedOptionKey(null);
    }

    public static abstract class d
    implements b {
        public static final String Fi = "java.vm.version";
        private static final Set<String> Fj = Set.of("jdk.graal.compiler", "jdk.graal.compiler.management", "org.graalvm.nativeimage.builder");
        private final EconomicMap<Class<?>, byte[]> Fk = EconomicMap.create((Equivalence)Equivalence.IDENTITY);

        static String o(HostedOptionKey<String> hostedOptionKey) {
            String string = (String)hostedOptionKey.getValue();
            if (string != null && !Paths.get(string, new String[0]).toFile().isDirectory()) {
                throw UserError.abort((String)"%s is not pointing to a directory: %s", (Object[])new Object[]{hostedOptionKey.getName(), string});
            }
            return string;
        }

        @Override
        public void a(com.oracle.svm.enterprise.hosted.substitute.a a2, Class<?> clazz, Class<?> clazz2) {
            if (!ModuleLayer.boot().modules().contains(clazz.getModule())) {
                return;
            }
            if (clazz.getClassLoader() != null && clazz.getClassLoader() != ClassLoader.getPlatformClassLoader() || Fj.contains(clazz.getModule().getName())) {
                return;
            }
            if (!a2.p(clazz2)) {
                return;
            }
            byte[] byArray = (byte[])this.Fk.get(clazz);
            if (byArray == null) {
                byArray = d.u(clazz);
                this.Fk.put(clazz, (Object)byArray);
            } else if (!this.kO()) {
                return;
            }
            this.a(clazz, clazz2, byArray);
        }

        protected abstract boolean kO();

        protected abstract void a(Class<?> var1, Class<?> var2, byte[] var3);

        @Override
        public void close() {
        }

        protected static Path s(Class<?> clazz) {
            return Paths.get(clazz.getModule().getName(), clazz.getName() + ".class.sha256");
        }

        protected static Path t(Class<?> clazz) {
            return Paths.get(clazz.getModule().getName(), clazz.getName());
        }

        protected static String kU() {
            return System.getProperty(Fi);
        }

        protected static String d(byte[] byArray) {
            return HexFormat.of().formatHex(byArray);
        }

        protected static byte[] aI(String string) {
            return HexFormat.of().parseHex(string);
        }

        static byte[] u(Class<?> clazz) {
            byte[] byArray;
            block8: {
                InputStream inputStream = clazz.getResourceAsStream(d.v(clazz));
                try {
                    VMError.guarantee((inputStream != null ? 1 : 0) != 0, (String)"classfile null for %s", clazz);
                    byArray = MessageDigest.getInstance("SHA-256").digest(d.a(inputStream));
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | NoSuchAlgorithmException exception) {
                        throw new RuntimeException(exception);
                    }
                }
                inputStream.close();
            }
            return byArray;
        }

        private static byte[] a(InputStream inputStream) throws IOException {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[16384];
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            return byteArrayOutputStream.toByteArray();
        }

        private static String v(Class<?> clazz) {
            return ClassUtil.getUnqualifiedName(clazz) + ".class";
        }
    }

    public static final class b
    extends d {
        private static void c(Path path, String string) {
            try {
                Path path2 = Paths.get((String)c.WriteSubstitutionChecksum.getValue(), new String[0]).resolve(path);
                Path path3 = path2.getParent();
                assert (path3 != null) : "No parent directory: " + String.valueOf(path2);
                Files.createDirectories(path3, new FileAttribute[0]);
                Files.writeString(path2, (CharSequence)string, new OpenOption[0]);
            }
            catch (IOException iOException) {
                throw UserError.abort((Throwable)iOException, (String)iOException.getMessage(), (Object[])new Object[0]);
            }
        }

        @Override
        protected boolean kO() {
            return false;
        }

        @Override
        protected void a(Class<?> clazz, Class<?> clazz2, byte[] byArray) {
            b.c(b.s(clazz), b.d(byArray));
        }

        @Override
        public void close() {
            super.close();
            b.c(Paths.get("java.vm.version", new String[0]), d.kU());
        }
    }

    public static final class com.oracle.svm.enterprise.hosted.substitute.b$a
    extends d {
        private final MetaAccessProvider Fb;
        private final EconomicMap<Path, byte[]> Fc = EconomicMap.create();
        private final EconomicMap<Class<?>, a> Fd = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        private final ArrayList<Class<?>> Fe = new ArrayList();

        private com.oracle.svm.enterprise.hosted.substitute.b$a(MetaAccessProvider metaAccessProvider) {
            this.Fb = metaAccessProvider;
        }

        @Override
        protected boolean kO() {
            return true;
        }

        @Override
        protected void a(Class<?> clazz, Class<?> clazz2, byte[] byArray) {
            byte[] byArray2 = this.r(clazz);
            if (!Arrays.equals(byArray2, byArray)) {
                a a2 = (a)this.Fd.get(clazz);
                if (a2 == null) {
                    a2 = new a(clazz, new ArrayList(), byArray);
                    this.Fd.put(clazz, (Object)a2);
                }
                VMError.guarantee((!a2.Fg.contains(clazz2) ? 1 : 0) != 0);
                a2.Fg.add(clazz2);
            }
            this.Fe.add(clazz);
        }

        @Override
        public void close() {
            super.close();
            int n2 = this.Fc.size();
            String string = this.kP();
            String string2 = (String)c.SubstitutionChecksumResult.getValue();
            if (string2 != null) {
                this.a(n2, string, string2);
            } else if (!this.Fd.isEmpty()) {
                int n3 = this.Fd.size();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("Differences from '%s' to '%s'%n", string, com.oracle.svm.enterprise.hosted.substitute.b$a.kU()));
                stringBuilder.append(String.format("Checksum violation (%s/%s):%n", n3, n2));
                this.Fd.getValues().forEach(a2 -> stringBuilder.append(a2.Ff.getName()).append(System.lineSeparator()));
                throw UserError.abort((String)stringBuilder.toString(), (Object[])new Object[0]);
            }
        }

        private String kP() {
            byte[] byArray = (byte[])this.kQ().get((Object)Paths.get("java.vm.version", new String[0]));
            return byArray != null ? new String(byArray, StandardCharsets.UTF_8) : "<unknown>";
        }

        private void a(int n2, String string, String string2) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put("fileVersion", string);
            linkedHashMap.put("vmVersion", com.oracle.svm.enterprise.hosted.substitute.b$a.kU());
            linkedHashMap.put("numSubstitutions", n2);
            linkedHashMap.put("diff", StreamSupport.stream(this.Fd.getValues().spliterator(), false).map(this::a).toList());
            linkedHashMap.put("classes", this.Fe.stream().map(d::t).map(Path::toString).toList());
            try (JsonWriter jsonWriter = new JsonWriter(Paths.get(string2, new String[0]), new OpenOption[0]);){
                jsonWriter.print(linkedHashMap);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        private Map<String, Object> a(a a2) {
            Class<?> clazz = a2.Ff;
            return Map.of("originalClass", this.q(clazz), "annotatedClasses", a2.Fg.stream().map(this::q).iterator(), "actualCheckSum", com.oracle.svm.enterprise.hosted.substitute.b$a.d(a2.Fh));
        }

        private Map<String, Object> q(Class<?> clazz) {
            ResolvedJavaType resolvedJavaType = this.Fb.lookupJavaType(clazz);
            return Map.of("class", clazz.getName(), "module", clazz.getModule().getName(), "sourceFileName", resolvedJavaType.getSourceFileName(), "sourceLineNumber", com.oracle.svm.enterprise.hosted.substitute.b$a.j(resolvedJavaType));
        }

        private static int j(ResolvedJavaType resolvedJavaType) {
            return Stream.concat(Arrays.stream(resolvedJavaType.getDeclaredMethods()), Arrays.stream(resolvedJavaType.getDeclaredConstructors())).mapToInt(resolvedJavaMethod -> resolvedJavaMethod.asStackTraceElement(0).getLineNumber()).filter(n2 -> n2 > 0).min().orElse(-1);
        }

        private byte[] r(Class<?> clazz) {
            return (byte[])this.kQ().get((Object)com.oracle.svm.enterprise.hosted.substitute.b$a.s(clazz));
        }

        private EconomicMap<Path, byte[]> kQ() {
            if (this.Fc.isEmpty()) {
                try {
                    Path path = Paths.get((String)c.VerifySubstitutionChecksum.getValue(), new String[0]);
                    File[] fileArray = path.toFile().listFiles();
                    assert (fileArray != null) : "Not a directory: " + String.valueOf(path);
                    for (File file : fileArray) {
                        Object[] objectArray;
                        if (file.isDirectory()) {
                            objectArray = file.listFiles();
                            assert (objectArray != null) : "Not a directory: " + String.valueOf(file);
                            for (File file2 : objectArray) {
                                String string = Files.readString(file2.toPath());
                                try {
                                    byte[] byArray = com.oracle.svm.enterprise.hosted.substitute.b$a.aI(string);
                                    this.Fc.put((Object)path.relativize(file2.toPath()), (Object)byArray);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    UserError.abort((Throwable)illegalArgumentException, (String)"File content is not a checksum: %s", (Object[])new Object[]{file2});
                                }
                            }
                            continue;
                        }
                        assert (file.isFile());
                        objectArray = Files.readAllBytes(file.toPath());
                        this.Fc.put((Object)path.relativize(file.toPath()), (Object)objectArray);
                    }
                }
                catch (IOException iOException) {
                    throw UserError.abort((Throwable)iOException, (String)"Cannot open file", (Object[])new Object[0]);
                }
            }
            return this.Fc;
        }

        private static final class a
        extends Record {
            private final Class<?> Ff;
            private final ArrayList<Class<?>> Fg;
            private final byte[] Fh;

            private a(Class<?> clazz, ArrayList<Class<?>> arrayList, byte[] byArray) {
                this.Ff = clazz;
                this.Fg = arrayList;
                this.Fh = byArray;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "originalClass;annotatedClasses;actualCheckSum", "Ff", "Fg", "Fh"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "originalClass;annotatedClasses;actualCheckSum", "Ff", "Fg", "Fh"}, this);
            }

            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "originalClass;annotatedClasses;actualCheckSum", "Ff", "Fg", "Fh"}, this, object);
            }

            public Class<?> kR() {
                return this.Ff;
            }

            public ArrayList<Class<?>> kS() {
                return this.Fg;
            }

            public byte[] kT() {
                return this.Fh;
            }
        }
    }
}

