/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.phases;

import com.oracle.graal.vector.replacements.CopyOfNode;
import com.oracle.svm.core.graal.jdk.SubstrateObjectCloneWithExceptionNode;
import com.oracle.svm.core.graal.nodes.SubstrateNewHybridInstanceNode;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.enterprise.core.graal.e;
import com.oracle.svm.enterprise.core.hybrid.n;
import com.oracle.svm.enterprise.core.hybrid.o;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ComputeObjectAddressNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.calc.ObjectEqualsNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.PublishWritesNode;
import jdk.graal.compiler.nodes.extended.RawLoadNode;
import jdk.graal.compiler.nodes.java.AccessFieldNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.NewArrayNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.graal.compiler.nodes.java.StoreFieldNode;
import jdk.graal.compiler.nodes.memory.address.IndexAddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.CommitAllocationNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.nodes.virtual.VirtualObjectState;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.replacements.nodes.ArrayCompareToNode;
import jdk.graal.compiler.replacements.nodes.ArrayEqualsNode;
import jdk.graal.compiler.replacements.nodes.ArrayIndexOfNode;
import jdk.graal.compiler.replacements.nodes.ArrayRegionEqualsNode;
import jdk.graal.compiler.replacements.nodes.BasicArrayCopyNode;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;

public final class StringInliningPhase
extends BasePhase<CoreProviders> {
    private static final List<Class<?>> yl = Arrays.asList(FrameState.class, LoadFieldNode.class, LoadIndexedNode.class, ArrayLengthNode.class, FullInfopointNode.class, PhiNode.class, PiNode.class, CallTargetNode.class, IsNullNode.class, CommitAllocationNode.class, VirtualObjectState.class, StoreFieldNode.class, ReturnNode.class, BasicArrayCopyNode.class, RawLoadNode.class, ComputeObjectAddressNode.class, ObjectEqualsNode.class, ArrayEqualsNode.class, ArrayRegionEqualsNode.class, ArrayCompareToNode.class, ArrayIndexOfNode.class, IndexAddressNode.class, SubstrateObjectCloneWithExceptionNode.class);

    public boolean checkContract() {
        return false;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        assert (StringInliningPhase.k(structuredGraph));
        EconomicSet<ValueNode> economicSet = StringInliningPhase.a(structuredGraph, coreProviders);
        StringInliningPhase.a(structuredGraph, coreProviders, economicSet);
        StringInliningPhase.b(structuredGraph, coreProviders, economicSet);
        StringInliningPhase.m(structuredGraph);
        StringInliningPhase.a(structuredGraph, economicSet);
        StringInliningPhase.b(structuredGraph, coreProviders);
        assert (StringInliningPhase.p(structuredGraph));
    }

    private static boolean k(StructuredGraph structuredGraph) {
        assert (n.useStringInlining());
        for (CommitAllocationNode commitAllocationNode : structuredGraph.getNodes().filter(CommitAllocationNode.class)) {
            for (VirtualObjectNode virtualObjectNode : commitAllocationNode.getVirtualObjects()) {
                assert (!StringInliningPhase.b(virtualObjectNode.type()));
            }
        }
        return true;
    }

    private static EconomicSet<ValueNode> a(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        d d2 = new d(structuredGraph);
        EconomicSet economicSet = EconomicSet.create();
        StringInliningPhase.a((NodeIterable<LoadFieldNode>)structuredGraph.getNodes().filter(LoadFieldNode.class), d2);
        boolean bl2 = false;
        do {
            Node node;
            Graph.Mark mark = structuredGraph.getMark();
            boolean bl3 = StringInliningPhase.l(structuredGraph);
            while (!d2.isEmpty()) {
                node = d2.hJ();
                if (!node.isAlive()) continue;
                bl3 |= StringInliningPhase.a(node, d2, (EconomicSet<ValueNode>)economicSet, structuredGraph, coreProviders);
            }
            if (bl3) {
                node = structuredGraph.getNewNodes(mark);
                StringInliningPhase.a((NodeIterable<LoadFieldNode>)node.filter(LoadFieldNode.class), d2);
                continue;
            }
            bl2 = d2.isEmpty();
        } while (!bl2);
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after inlining");
        return economicSet;
    }

    private static void a(NodeIterable<LoadFieldNode> nodeIterable, d d2) {
        for (LoadFieldNode loadFieldNode : nodeIterable) {
            if (!com.oracle.svm.enterprise.hosted.hybrid.a.fp().a(loadFieldNode.field())) continue;
            d2.h((ValueNode)loadFieldNode);
        }
    }

    private static boolean l(StructuredGraph structuredGraph) {
        boolean bl2 = false;
        for (Invoke invoke : structuredGraph.getInvokes()) {
            HostedMethod hostedMethod = (HostedMethod)invoke.getTargetMethod();
            if (!com.oracle.svm.enterprise.hosted.hybrid.a.fp().C(hostedMethod)) continue;
            CallTargetNode callTargetNode = invoke.callTarget();
            assert (callTargetNode.invokeKind().isDirect());
            StructuredGraph structuredGraph2 = hostedMethod.compilationInfo.createGraph(structuredGraph.getDebug(), structuredGraph.getOptions(), (CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID, true);
            InliningUtil.inline((Invoke)invoke, (StructuredGraph)structuredGraph2, (boolean)false, (ResolvedJavaMethod)hostedMethod);
            bl2 = true;
        }
        return bl2;
    }

    private static boolean a(Node node2, d d2, EconomicSet<ValueNode> economicSet, StructuredGraph structuredGraph, CoreProviders coreProviders) {
        assert (node2.isAlive());
        boolean bl2 = false;
        if (node2 instanceof LoadFieldNode) {
            LoadFieldNode loadFieldNode = (LoadFieldNode)node2;
            assert (com.oracle.svm.enterprise.hosted.hybrid.a.fp().a(loadFieldNode.field()));
            d2.b((NodeIterable<Node>)node2.usages());
            economicSet.add((Object)loadFieldNode);
        } else if (node2 instanceof PhiNode) {
            PhiNode phiNode = (PhiNode)node2;
            d2.b((NodeIterable<Node>)node2.usages());
            economicSet.add((Object)phiNode);
        } else if (node2 instanceof PiNode) {
            PiNode piNode = (PiNode)node2;
            d2.b((NodeIterable<Node>)node2.usages());
            economicSet.add((Object)piNode);
        } else if (node2 instanceof CallTargetNode) {
            CallTargetNode callTargetNode = (CallTargetNode)node2;
            Invoke invoke = callTargetNode.invoke();
            if (invoke.getInvokeKind().isDirect() && ((Boolean)c.PreventStringValueEscaping.getValue()).booleanValue()) {
                List list = callTargetNode.arguments().filter(node -> node instanceof ValueNode && economicSet.contains((Object)((ValueNode)node))).snapshot();
                HostedMethod hostedMethod = (HostedMethod)callTargetNode.targetMethod();
                StructuredGraph structuredGraph2 = hostedMethod.compilationInfo.createGraph(node2.getDebug(), structuredGraph.getOptions(), (CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID, true);
                Graph.Mark mark = structuredGraph.getMark();
                InliningUtil.inline((Invoke)invoke, (StructuredGraph)structuredGraph2, (boolean)false, (ResolvedJavaMethod)hostedMethod);
                CanonicalizerPhase.create().applyIncremental(structuredGraph, coreProviders, mark);
                bl2 = true;
                for (ValueNode valueNode : list) {
                    d2.b((NodeIterable<Node>)valueNode.usages());
                }
            }
        } else if (node2 instanceof CopyOfNode) {
            CopyOfNode copyOfNode = (CopyOfNode)node2;
            ValueNode valueNode = copyOfNode.jE();
            Invoke invoke = copyOfNode.replaceWithInvoke();
            assert (invoke.callTarget().invokeKind() == CallTargetNode.InvokeKind.Static);
            HostedMethod hostedMethod = (HostedMethod)invoke.callTarget().targetMethod();
            StructuredGraph structuredGraph3 = hostedMethod.compilationInfo.createGraph(node2.getDebug(), structuredGraph.getOptions(), (CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID, true);
            InliningUtil.inline((Invoke)invoke, (StructuredGraph)structuredGraph3, (boolean)false, (ResolvedJavaMethod)hostedMethod);
            bl2 = true;
            d2.b((NodeIterable<Node>)valueNode.usages());
        } else {
            StringInliningPhase.l(node2);
        }
        return bl2;
    }

    private static void l(Node node) {
        for (Class<?> clazz : yl) {
            if (!clazz.isAssignableFrom(node.getClass())) continue;
            return;
        }
        GraalError.shouldNotReachHere((String)("Unexpected node type: " + String.valueOf(node)));
    }

    private static void a(StructuredGraph structuredGraph, CoreProviders coreProviders, EconomicSet<ValueNode> economicSet) {
        boolean bl2;
        ArrayList<PhiNode> arrayList = new ArrayList<PhiNode>();
        do {
            bl2 = false;
            for (Node node : economicSet) {
                PhiNode phiNode;
                if (node instanceof PhiNode) {
                    phiNode = (PhiNode)node;
                    if (StringInliningPhase.a(phiNode, economicSet)) continue;
                    arrayList.add(phiNode);
                    economicSet.remove((Object)phiNode);
                    bl2 = true;
                    continue;
                }
                if (node instanceof PiNode) {
                    phiNode = (PiNode)node;
                    if (economicSet.contains((Object)phiNode.object())) continue;
                    economicSet.remove((Object)phiNode);
                    bl2 = true;
                    continue;
                }
                if (node instanceof LoadFieldNode) continue;
                throw GraalError.shouldNotReachHere((String)("Unexpected node " + String.valueOf(node)));
            }
        } while (bl2);
        for (Node node : arrayList) {
            StringInliningPhase.a(structuredGraph, coreProviders, (PhiNode)node, economicSet);
        }
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after converting phi nodes");
    }

    private static boolean a(PhiNode phiNode, EconomicSet<ValueNode> economicSet) {
        int n2 = phiNode.valueCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueNode valueNode = phiNode.valueAt(i2);
            if (economicSet.contains((Object)valueNode)) continue;
            return false;
        }
        return true;
    }

    private static void a(StructuredGraph structuredGraph, CoreProviders coreProviders, PhiNode phiNode, EconomicSet<ValueNode> economicSet) {
        AbstractMergeNode abstractMergeNode = phiNode.merge();
        List list = phiNode.values().snapshot();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ValueNode valueNode = (ValueNode)list.get(i2);
            if (!economicSet.contains((Object)valueNode)) continue;
            StringInliningPhase.a(structuredGraph, coreProviders, (ValueNode)phiNode, (FixedNode)abstractMergeNode.phiPredecessorAt(i2), valueNode, true);
        }
    }

    private static void b(StructuredGraph structuredGraph, CoreProviders coreProviders, EconomicSet<ValueNode> economicSet) {
        for (ValueNode valueNode : economicSet) {
            StringInliningPhase.a(structuredGraph, coreProviders, economicSet, valueNode);
        }
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after converting usages");
    }

    private static void a(StructuredGraph structuredGraph, CoreProviders coreProviders, EconomicSet<ValueNode> economicSet, ValueNode valueNode) {
        int n2 = coreProviders.getMetaAccess().getArrayBaseOffset(StringInliningPhase.hH());
        int n3 = com.oracle.svm.enterprise.core.graal.b.c((ResolvedJavaType)com.oracle.svm.enterprise.hosted.hybrid.a.fp().ft());
        long l2 = n3 - n2;
        for (Node node2 : valueNode.usages().snapshot()) {
            RawLoadNode rawLoadNode;
            Object object;
            Object object2;
            if (!node2.isAlive()) continue;
            if (node2 instanceof PhiNode) {
                assert (economicSet.contains((Object)((PhiNode)node2))) : node2;
                continue;
            }
            if (node2 instanceof PiNode) {
                assert (economicSet.contains((Object)((PiNode)node2))) : node2;
                continue;
            }
            if (node2 instanceof CallTargetNode) {
                object2 = (CallTargetNode)node2;
                assert (!object2.invokeKind().isDirect() || !((Boolean)c.PreventStringValueEscaping.getValue()).booleanValue()) : "must be inlined otherwise";
                StringInliningPhase.a(structuredGraph, coreProviders, (ValueNode)object2, (FixedNode)object2.invoke(), valueNode, false);
                continue;
            }
            if (node2 instanceof IsNullNode) {
                StringInliningPhase.a((IsNullNode)node2, structuredGraph);
                continue;
            }
            if (node2 instanceof CommitAllocationNode) {
                object2 = (CommitAllocationNode)node2;
                StringInliningPhase.a(structuredGraph, coreProviders, (ValueNode)object2, (FixedNode)object2, valueNode, false);
                continue;
            }
            if (node2 instanceof VirtualObjectState) continue;
            if (node2 instanceof StoreFieldNode) {
                object2 = (StoreFieldNode)node2;
                if (com.oracle.svm.enterprise.hosted.hybrid.a.fp().a(object2.field())) continue;
                StringInliningPhase.a(structuredGraph, coreProviders, (ValueNode)object2, (FixedNode)object2, valueNode, false);
                continue;
            }
            if (node2 instanceof ReturnNode) {
                object2 = (ReturnNode)node2;
                StringInliningPhase.a(structuredGraph, coreProviders, (ValueNode)object2, (FixedNode)object2, valueNode, false);
                continue;
            }
            if (node2 instanceof BasicArrayCopyNode) {
                StringInliningPhase.a((BasicArrayCopyNode)node2, structuredGraph);
                continue;
            }
            if (node2 instanceof RawLoadNode) {
                object2 = (RawLoadNode)node2;
                assert (object2.object() == valueNode) : object2;
                object = (ValueNode)structuredGraph.addOrUnique((Node)AddNode.create((ValueNode)object2.offset(), (ValueNode)ConstantNode.forIntegerKind((JavaKind)JavaKind.Long, (long)l2, (StructuredGraph)structuredGraph), (NodeView)NodeView.DEFAULT));
                rawLoadNode = (RawLoadNode)structuredGraph.add((Node)new RawLoadNode(valueNode, object, object2.accessKind(), object2.getLocationIdentity(), object2.isLocationForced(), object2.getMemoryOrder()));
                structuredGraph.replaceFixedWithFixed((FixedWithNextNode)object2, (FixedWithNextNode)rawLoadNode);
                continue;
            }
            if (node2 instanceof ComputeObjectAddressNode) {
                object2 = (ComputeObjectAddressNode)node2;
                assert (object2.getObject() == valueNode) : object2;
                object = (ValueNode)structuredGraph.addOrUnique((Node)AddNode.create((ValueNode)object2.getOffset(), (ValueNode)ConstantNode.forIntegerKind((JavaKind)JavaKind.Long, (long)l2, (StructuredGraph)structuredGraph), (NodeView)NodeView.DEFAULT));
                object2.setOffset(object);
                continue;
            }
            if (node2 instanceof ObjectEqualsNode) continue;
            if (node2 instanceof ArrayEqualsNode) {
                object2 = (ArrayEqualsNode)node2;
                GraalError.guarantee((object2.getKind() == StringInliningPhase.hH() ? 1 : 0) != 0, (String)"ArrayEqualsNode on a String array must be of JavaKind.Byte");
                object = (com.oracle.svm.enterprise.core.graal.d)structuredGraph.add((Node)new com.oracle.svm.enterprise.core.graal.d(object2.getArray1(), (ValueNode)ConstantNode.forIntegerKind((JavaKind)JavaKind.Long, (long)(object2.getArray1() == valueNode ? (long)n3 : (long)n2), (StructuredGraph)structuredGraph), object2.getArray2(), (ValueNode)ConstantNode.forIntegerKind((JavaKind)JavaKind.Long, (long)(object2.getArray2() == valueNode ? (long)n3 : (long)n2), (StructuredGraph)structuredGraph), object2.getLength(), null, Stride.fromJavaKind((JavaKind)object2.getKind()), Stride.fromJavaKind((JavaKind)object2.getKind()), StringInliningPhase.a(object2.getArray1() == valueNode, null), StringInliningPhase.a(object2.getArray2() == valueNode, null), object2.getRuntimeCheckedCPUFeatures(), object2.getLocationIdentity()));
                structuredGraph.replaceFixedWithFixed((FixedWithNextNode)object2, (FixedWithNextNode)object);
                continue;
            }
            if (node2 instanceof com.oracle.svm.enterprise.core.graal.d) {
                object2 = (com.oracle.svm.enterprise.core.graal.d)node2;
                assert (object2.getArrayA() == valueNode || object2.getArrayB() == valueNode) : object2;
                object = (com.oracle.svm.enterprise.core.graal.d)structuredGraph.add((Node)new com.oracle.svm.enterprise.core.graal.d(object2.getArrayA(), StringInliningPhase.a(structuredGraph, object2.getArrayA(), valueNode, l2, object2.getOffsetA()), object2.getArrayB(), StringInliningPhase.a(structuredGraph, object2.getArrayB(), valueNode, l2, object2.getOffsetB()), object2.getLength(), object2.getDynamicStrides(), object2.getStrideA(), object2.getStrideB(), StringInliningPhase.a(object2.getArrayA() == valueNode, ((com.oracle.svm.enterprise.core.graal.d)((Object)object2)).ac()), StringInliningPhase.a(object2.getArrayB() == valueNode, ((com.oracle.svm.enterprise.core.graal.d)((Object)object2)).ad()), object2.getRuntimeCheckedCPUFeatures(), object2.getLocationIdentity()));
                structuredGraph.replaceFixedWithFixed((FixedWithNextNode)object2, (FixedWithNextNode)object);
                continue;
            }
            if (node2 instanceof ArrayRegionEqualsNode) {
                object2 = (ArrayRegionEqualsNode)node2;
                assert (object2.getArrayA() == valueNode || object2.getArrayB() == valueNode) : object2;
                object = (com.oracle.svm.enterprise.core.graal.d)structuredGraph.add((Node)new com.oracle.svm.enterprise.core.graal.d(object2.getArrayA(), StringInliningPhase.a(structuredGraph, object2.getArrayA(), valueNode, l2, object2.getOffsetA()), object2.getArrayB(), StringInliningPhase.a(structuredGraph, object2.getArrayB(), valueNode, l2, object2.getOffsetB()), object2.getLength(), object2.getDynamicStrides(), object2.getStrideA(), object2.getStrideB(), StringInliningPhase.a(object2.getArrayA() == valueNode, null), StringInliningPhase.a(object2.getArrayB() == valueNode, null), object2.getRuntimeCheckedCPUFeatures(), object2.getLocationIdentity()));
                structuredGraph.replaceFixedWithFixed((FixedWithNextNode)object2, (FixedWithNextNode)object);
                continue;
            }
            if (node2 instanceof com.oracle.svm.enterprise.core.graal.c) {
                object2 = (com.oracle.svm.enterprise.core.graal.c)node2;
                assert (StringInliningPhase.b(((com.oracle.svm.enterprise.core.graal.c)((Object)object2)).ab())) : object2;
                continue;
            }
            if (node2 instanceof ArrayIndexOfNode) {
                object2 = (ArrayIndexOfNode)node2;
                assert (object2.getArrayPointer() == valueNode) : object2;
                object = (com.oracle.svm.enterprise.core.graal.c)structuredGraph.add((Node)new com.oracle.svm.enterprise.core.graal.c(object2.getStride(), (ResolvedJavaType)com.oracle.svm.enterprise.hosted.hybrid.a.fp().ft(), object2.getVariant(), object2.getRuntimeCheckedCPUFeatures(), object2.getLocationIdentity(), object2.getArrayPointer(), (ValueNode)structuredGraph.addOrUnique((Node)AddNode.create((ValueNode)object2.getArrayOffset(), (ValueNode)ConstantNode.forIntegerKind((JavaKind)JavaKind.Long, (long)l2, (StructuredGraph)structuredGraph), (NodeView)NodeView.DEFAULT)), object2.getArrayLength(), object2.getFromIndex(), (ValueNode[])object2.getSearchValues().toArray((Object[])ValueNode.EMPTY_ARRAY)));
                structuredGraph.replaceFixedWithFixed((FixedWithNextNode)object2, (FixedWithNextNode)object);
                continue;
            }
            if (node2 instanceof e) {
                object2 = (e)node2;
                assert (StringInliningPhase.b(((e)((Object)object2)).ab())) : object2;
                continue;
            }
            if (node2 instanceof IndexAddressNode) {
                object2 = (IndexAddressNode)node2;
                assert (object2.getArray() == valueNode) : object2;
                object = (e)structuredGraph.unique((Node)new e(object2.getArray(), object2.getIndex(), (ResolvedJavaType)com.oracle.svm.enterprise.hosted.hybrid.a.fp().ft(), object2.getElementKind()));
                object2.replaceAndDelete((Node)object);
                continue;
            }
            if (node2 instanceof SubstrateObjectCloneWithExceptionNode) {
                object2 = (SubstrateObjectCloneWithExceptionNode)node2;
                object = (ArrayLengthNode)structuredGraph.add((Node)new ArrayLengthNode(object2.getObject()));
                rawLoadNode = (NewArrayNode)structuredGraph.add((Node)new NewArrayNode(StringInliningPhase.a(coreProviders), object, false, null));
                PublishWritesNode publishWritesNode = (PublishWritesNode)structuredGraph.add((Node)new PublishWritesNode((ValueNode)rawLoadNode));
                ValueNode valueNode2 = (ValueNode)structuredGraph.unique((Node)ConstantNode.forInt((int)0));
                o o2 = (o)structuredGraph.add((Node)new o(object2.getObject(), valueNode2, (ValueNode)rawLoadNode, valueNode2, (ValueNode)object, StringInliningPhase.hH()));
                o2.setStateAfter(object2.stateAfter());
                object2.replaceAtMatchingUsages((Node)rawLoadNode, node -> node instanceof VirtualState);
                object2.replaceAtUsages((Node)publishWritesNode);
                structuredGraph.replaceWithExceptionSplit((WithExceptionNode)object2, (WithExceptionNode)o2);
                structuredGraph.addBeforeFixed((FixedNode)o2, (FixedWithNextNode)rawLoadNode);
                structuredGraph.addBeforeFixed((FixedNode)rawLoadNode, (FixedWithNextNode)object);
                structuredGraph.addAfterFixed((FixedWithNextNode)o2.next(), (FixedNode)publishWritesNode);
                o2.replaceWithNonThrowing();
                continue;
            }
            StringInliningPhase.l(node2);
        }
    }

    private static ValueNode a(StructuredGraph structuredGraph, ValueNode valueNode, ValueNode valueNode2, long l2, ValueNode valueNode3) {
        return valueNode == valueNode2 ? (ValueNode)structuredGraph.addOrUnique((Node)AddNode.create((ValueNode)valueNode3, (ValueNode)ConstantNode.forIntegerKind((JavaKind)JavaKind.Long, (long)l2, (StructuredGraph)structuredGraph), (NodeView)NodeView.DEFAULT)) : valueNode3;
    }

    private static ResolvedJavaType a(boolean bl2, ResolvedJavaType resolvedJavaType) {
        if (bl2) {
            return com.oracle.svm.enterprise.hosted.hybrid.a.fp().ft();
        }
        return resolvedJavaType;
    }

    private static boolean b(ResolvedJavaType resolvedJavaType) {
        return com.oracle.svm.enterprise.hosted.hybrid.a.fp().b(resolvedJavaType);
    }

    private static void a(StructuredGraph structuredGraph, CoreProviders coreProviders, ValueNode valueNode, FixedNode fixedNode, ValueNode valueNode2, boolean bl2) {
        assert (!(fixedNode instanceof BeginNode));
        FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)fixedNode.predecessor();
        ValueNode valueNode3 = (ValueNode)structuredGraph.addOrUnique((Node)ArrayLengthNode.create((ValueNode)valueNode2, (ConstantReflectionProvider)coreProviders.getConstantReflection()));
        NewArrayNode newArrayNode = (NewArrayNode)structuredGraph.add((Node)new NewArrayNode(StringInliningPhase.a(coreProviders), valueNode3, false));
        ConstantNode constantNode = (ConstantNode)structuredGraph.unique((Node)ConstantNode.forInt((int)0));
        o o2 = (o)structuredGraph.add((Node)new o(valueNode2, (ValueNode)constantNode, (ValueNode)newArrayNode, (ValueNode)constantNode, valueNode3, StringInliningPhase.hH()));
        PublishWritesNode publishWritesNode = (PublishWritesNode)structuredGraph.add((Node)new PublishWritesNode((ValueNode)newArrayNode));
        o2.replaceWithNonThrowing();
        o2.setStateDuring(null);
        o2.setStateAfter(null);
        fixedWithNextNode.setNext((FixedNode)newArrayNode);
        newArrayNode.setNext((FixedNode)o2);
        AbstractBeginNode abstractBeginNode = (AbstractBeginNode)structuredGraph.add((Node)new BeginNode());
        o2.setNext(abstractBeginNode);
        abstractBeginNode.setNext((FixedNode)publishWritesNode);
        publishWritesNode.setNext(fixedNode);
        StringInliningPhase.a((FixedNode)newArrayNode, valueNode3, structuredGraph);
        if (bl2) {
            valueNode.replaceFirstInput((Node)valueNode2, (Node)publishWritesNode);
        } else {
            valueNode.replaceAllInputs((Node)valueNode2, (Node)publishWritesNode);
        }
    }

    private static void a(IsNullNode isNullNode, StructuredGraph structuredGraph) {
        for (Node node : isNullNode.usages().snapshot()) {
            if (node instanceof IfNode) {
                IfNode ifNode = (IfNode)node;
                GraphUtil.killCFG((FixedNode)ifNode.trueSuccessor());
                structuredGraph.removeSplit((ControlSplitNode)ifNode, ifNode.falseSuccessor());
                continue;
            }
            throw GraalError.shouldNotReachHere((String)(String.valueOf(isNullNode) + " is used by " + String.valueOf(node)));
        }
    }

    private static o a(BasicArrayCopyNode basicArrayCopyNode, StructuredGraph structuredGraph) {
        if (basicArrayCopyNode instanceof o) {
            return null;
        }
        o o2 = (o)structuredGraph.add((Node)new o(basicArrayCopyNode.getSource(), basicArrayCopyNode.getSourcePosition(), basicArrayCopyNode.getDestination(), basicArrayCopyNode.getDestinationPosition(), basicArrayCopyNode.getLength(), basicArrayCopyNode.getElementKind()));
        o2.setStateDuring(basicArrayCopyNode.stateDuring());
        o2.setStateAfter(basicArrayCopyNode.stateAfter());
        structuredGraph.replaceWithExceptionSplit((WithExceptionNode)basicArrayCopyNode, (WithExceptionNode)o2);
        return o2;
    }

    private static void m(StructuredGraph structuredGraph) {
        for (LoadFieldNode loadFieldNode : structuredGraph.getNodes().filter(LoadFieldNode.class)) {
            if (!com.oracle.svm.enterprise.hosted.hybrid.a.fp().a(loadFieldNode.field())) continue;
            assert (StampTool.isPointerNonNull((ValueNode)loadFieldNode.object())) : "there must be an existing null check";
            loadFieldNode.replaceAtUsages((Node)loadFieldNode.object());
            structuredGraph.removeFixed((FixedWithNextNode)loadFieldNode);
        }
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after removing LoadField nodes");
    }

    private static void a(StructuredGraph structuredGraph, EconomicSet<? extends ValueNode> economicSet) {
        StringInliningPhase.b(structuredGraph, economicSet);
        structuredGraph.getDebug().dump(3, (Object)structuredGraph, "after fixing stamps");
    }

    private static void b(StructuredGraph structuredGraph, EconomicSet<? extends ValueNode> economicSet) {
        Stamp stamp = com.oracle.svm.enterprise.hosted.hybrid.a.fp().fu();
        for (Node node : economicSet) {
            PhiNode phiNode;
            if (!node.isAlive()) continue;
            if (node instanceof PhiNode) {
                phiNode = (PhiNode)node;
                assert (StampTool.isPointerNonNull((ValueNode)phiNode));
                phiNode.setStamp(stamp);
                continue;
            }
            if (node instanceof PiNode) {
                phiNode = (PiNode)node;
                phiNode.replaceAtUsages(structuredGraph.addWithoutUnique((Node)new PiNode(phiNode.object(), stamp, (ValueNode)phiNode.getGuard())));
                phiNode.safeDelete();
                continue;
            }
            if (node instanceof LoadFieldNode) continue;
            throw GraalError.shouldNotReachHere((String)("Unexpected node type: " + String.valueOf(node)));
        }
    }

    private static void b(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        int n2;
        SubstrateNewHybridInstanceNode substrateNewHybridInstanceNode;
        Object object;
        ConstantNode constantNode = ConstantNode.forConstant((JavaConstant)JavaConstant.NULL_POINTER, (MetaAccessProvider)coreProviders.getMetaAccess(), (StructuredGraph)structuredGraph);
        ResolvedJavaType resolvedJavaType = StringInliningPhase.a(coreProviders);
        ArrayList<a> arrayList = new ArrayList<a>();
        EconomicMap<NewInstanceNode, List<StoreFieldNode>> economicMap = StringInliningPhase.o(structuredGraph);
        MapCursor mapCursor = economicMap.getEntries();
        while (mapCursor.advance()) {
            object = (NewInstanceNode)mapCursor.getKey();
            Object object2 = (List)mapCursor.getValue();
            object.replaceAtUsages((Node)constantNode, node -> node instanceof FrameState, false);
            int n3 = object2.size();
            substrateNewHybridInstanceNode = new SubstrateNewHybridInstanceNode[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                SubstrateNewHybridInstanceNode substrateNewHybridInstanceNode2;
                StoreFieldNode storeFieldNode = (StoreFieldNode)object2.get(n2);
                ValueNode valueNode = (ValueNode)structuredGraph.addOrUnique((Node)ArrayLengthNode.create((ValueNode)storeFieldNode.value(), (ConstantReflectionProvider)coreProviders.getConstantReflection()));
                substrateNewHybridInstanceNode[n2] = substrateNewHybridInstanceNode2 = (SubstrateNewHybridInstanceNode)structuredGraph.add((Node)new SubstrateNewHybridInstanceNode(object.instanceClass(), resolvedJavaType, valueNode));
                structuredGraph.addBeforeFixed((FixedNode)storeFieldNode, (FixedWithNextNode)substrateNewHybridInstanceNode2);
                StringInliningPhase.a((FixedNode)substrateNewHybridInstanceNode2, valueNode, structuredGraph);
                StringInliningPhase.a(structuredGraph, storeFieldNode, valueNode);
            }
            if (n3 == 1) {
                object.replaceAtUsages((Node)substrateNewHybridInstanceNode[0]);
                structuredGraph.removeFixed((FixedWithNextNode)object);
                continue;
            }
            arrayList.add(new a((NewInstanceNode)object, (SubstrateNewHybridInstanceNode[])substrateNewHybridInstanceNode));
        }
        if (!arrayList.isEmpty()) {
            SchedulePhase.runWithoutContextOptimizations((StructuredGraph)structuredGraph);
            object = structuredGraph.getLastSchedule();
            for (a a2 : arrayList) {
                substrateNewHybridInstanceNode = new ArrayDeque(a2.hI());
                for (n2 = 0; n2 < a2.hI(); ++n2) {
                    StringInliningPhase.a((FixedNode)a2.yn[n2], (ValueNode)a2.yn[n2], (ArrayDeque<b>)substrateNewHybridInstanceNode);
                }
                StringInliningPhase.a(structuredGraph, (ArrayDeque<b>)substrateNewHybridInstanceNode, a2.ym, a2.yn, (StructuredGraph.ScheduleResult)object);
                structuredGraph.removeFixed((FixedWithNextNode)a2.ym);
            }
        }
        for (Object object2 : StringInliningPhase.n(structuredGraph)) {
            if (object2.hasNoUsages()) {
                structuredGraph.removeFixed((FixedWithNextNode)object2);
                continue;
            }
            ValueNode valueNode = (ValueNode)structuredGraph.unique((Node)ConstantNode.forInt((int)0));
            substrateNewHybridInstanceNode = (SubstrateNewHybridInstanceNode)structuredGraph.add((Node)new SubstrateNewHybridInstanceNode(object2.instanceClass(), resolvedJavaType, valueNode));
            structuredGraph.replaceFixedWithFixed((FixedWithNextNode)object2, (FixedWithNextNode)substrateNewHybridInstanceNode);
        }
        for (Object object2 : structuredGraph.getNodes().filter(StoreFieldNode.class)) {
            if (!com.oracle.svm.enterprise.hosted.hybrid.a.fp().a(object2.field())) continue;
            GraalError.shouldNotReachHere((String)("Unexpected write to String.value: " + String.valueOf(object2) + " in " + String.valueOf(structuredGraph.method())));
        }
    }

    private static NodeIterable<NewInstanceNode> n(StructuredGraph structuredGraph) {
        return structuredGraph.getNodes().filter(NewInstanceNode.class).filter(StringInliningPhase::m);
    }

    private static boolean m(Node node) {
        if (node instanceof NewInstanceNode) {
            NewInstanceNode newInstanceNode = (NewInstanceNode)node;
            return StringInliningPhase.b(newInstanceNode.instanceClass());
        }
        return false;
    }

    private static void a(StructuredGraph structuredGraph, ArrayDeque<b> arrayDeque, NewInstanceNode newInstanceNode, SubstrateNewHybridInstanceNode[] abstractMergeNode, StructuredGraph.ScheduleResult scheduleResult) {
        HIRBlock hIRBlock;
        Object object;
        EconomicMap economicMap;
        Object object2;
        if (!newInstanceNode.hasUsages()) {
            return;
        }
        EconomicSet economicSet = EconomicSet.create();
        EconomicMap economicMap2 = EconomicMap.create();
        while (newInstanceNode.hasUsages() && !arrayDeque.isEmpty()) {
            object2 = arrayDeque.remove();
            economicMap = object2.yp;
            object = economicMap.merge();
            StringInliningPhase.a((AbstractMergeNode)object, newInstanceNode, (b)object2);
            PhiNode phiNode = StringInliningPhase.a(structuredGraph, (EconomicMap<AbstractMergeNode, PhiNode>)economicMap2, (AbstractMergeNode)object);
            phiNode.setValueAt((AbstractEndNode)economicMap, object2.yo);
            if (!StringInliningPhase.a(phiNode, newInstanceNode) || economicSet.contains(object)) continue;
            economicSet.add(object);
            StringInliningPhase.a((FixedNode)object, (ValueNode)phiNode, arrayDeque);
        }
        object2 = scheduleResult.getCFG();
        economicMap = EconomicMap.create((int)((SubstrateNewHybridInstanceNode[])abstractMergeNode).length);
        for (AbstractMergeNode abstractMergeNode2 : abstractMergeNode) {
            hIRBlock = object2.blockFor((Node)abstractMergeNode2);
            assert (!economicMap.containsKey((Object)hIRBlock));
            economicMap.put((Object)hIRBlock, (Object)abstractMergeNode2);
        }
        block2: for (Node node : newInstanceNode.usages().snapshot()) {
            HIRBlock hIRBlock2 = node instanceof ValueProxyNode ? object2.blockFor((Node)((ValueProxyNode)node).proxyPoint()) : object2.blockFor(node);
            while (true) {
                AbstractMergeNode abstractMergeNode2;
                if ((abstractMergeNode2 = (SubstrateNewHybridInstanceNode)economicMap.get((Object)hIRBlock2)) != null) {
                    node.replaceAllInputs((Node)newInstanceNode, (Node)abstractMergeNode2);
                    continue block2;
                }
                hIRBlock = hIRBlock2.getBeginNode();
                if (hIRBlock instanceof AbstractMergeNode) {
                    PhiNode phiNode = (PhiNode)economicMap2.get((Object)((AbstractMergeNode)hIRBlock));
                    assert (phiNode != null);
                    node.replaceAllInputs((Node)newInstanceNode, (Node)phiNode);
                    continue block2;
                }
                assert (hIRBlock2.getPredecessorCount() == 1);
                hIRBlock2 = hIRBlock2.getFirstPredecessor();
            }
        }
        object = economicMap2.getEntries();
        while (object.advance()) {
            PhiNode phiNode = (PhiNode)object.getValue();
            if (!phiNode.hasNoUsages() || !phiNode.isAlive()) continue;
            phiNode.safeDelete();
        }
    }

    private static void a(AbstractMergeNode abstractMergeNode, NewInstanceNode newInstanceNode, b b2) {
        for (PhiNode phiNode : abstractMergeNode.phis()) {
            if (phiNode.valueAt(b2.yp) != newInstanceNode) continue;
            phiNode.setValueAt(b2.yp, b2.yo);
        }
    }

    private static PhiNode a(StructuredGraph structuredGraph, EconomicMap<AbstractMergeNode, PhiNode> economicMap, AbstractMergeNode abstractMergeNode) {
        PhiNode phiNode = (PhiNode)economicMap.get((Object)abstractMergeNode);
        if (phiNode == null) {
            Stamp stamp = com.oracle.svm.enterprise.hosted.hybrid.a.fp().fu();
            phiNode = (PhiNode)structuredGraph.addWithoutUnique((Node)new ValuePhiNode(stamp, abstractMergeNode, (ValueNode[])new PhiNode[abstractMergeNode.phiPredecessorCount()]));
            economicMap.put((Object)abstractMergeNode, (Object)phiNode);
        }
        return phiNode;
    }

    private static boolean a(PhiNode phiNode, NewInstanceNode newInstanceNode) {
        for (int i2 = 0; i2 < phiNode.merge().forwardEndCount(); ++i2) {
            ValueNode valueNode = phiNode.valueAt(i2);
            if (valueNode != null && valueNode != newInstanceNode) continue;
            return false;
        }
        return true;
    }

    private static o a(StructuredGraph structuredGraph, StoreFieldNode storeFieldNode, ValueNode valueNode) {
        ConstantNode constantNode = (ConstantNode)structuredGraph.unique((Node)ConstantNode.forInt((int)0));
        o o2 = (o)structuredGraph.add((Node)new o(storeFieldNode.value(), (ValueNode)constantNode, storeFieldNode.object(), (ValueNode)constantNode, valueNode, StringInliningPhase.hH()));
        o2.replaceWithNonThrowing();
        o2.setStateDuring(null);
        o2.setStateAfter(storeFieldNode.stateAfter());
        FixedNode fixedNode = storeFieldNode.next();
        storeFieldNode.setNext(null);
        AbstractBeginNode abstractBeginNode = (AbstractBeginNode)structuredGraph.add((Node)new BeginNode());
        o2.setNext(abstractBeginNode);
        abstractBeginNode.setNext(fixedNode);
        storeFieldNode.replaceAndDelete((Node)o2);
        StringInliningPhase.a((FixedNode)o2, valueNode, structuredGraph);
        return o2;
    }

    private static void a(FixedNode fixedNode, ValueNode valueNode, ArrayDeque<b> arrayDeque) {
        ArrayDeque<FixedNode> arrayDeque2 = new ArrayDeque<FixedNode>(1);
        arrayDeque2.add(fixedNode);
        block0: while (!arrayDeque2.isEmpty()) {
            FixedNode fixedNode2 = (FixedNode)arrayDeque2.remove();
            while (true) {
                if (fixedNode2 instanceof AbstractEndNode) {
                    arrayDeque.add(new b(valueNode, (AbstractEndNode)fixedNode2));
                    continue block0;
                }
                if (fixedNode2 instanceof ControlSinkNode) continue block0;
                if (!(fixedNode2 instanceof FixedWithNextNode)) break;
                fixedNode2 = ((FixedWithNextNode)fixedNode2).next();
            }
            if (fixedNode2 instanceof ControlSplitNode) {
                ControlSplitNode controlSplitNode = (ControlSplitNode)fixedNode2;
                for (Node node : controlSplitNode.successors()) {
                    arrayDeque2.add((FixedNode)node);
                }
                continue;
            }
            throw GraalError.shouldNotReachHere((String)("Unexpected node: " + String.valueOf(fixedNode2)));
        }
    }

    private static EconomicMap<NewInstanceNode, List<StoreFieldNode>> o(StructuredGraph structuredGraph) {
        EconomicMap economicMap = EconomicMap.create();
        for (StoreFieldNode storeFieldNode : structuredGraph.getNodes().filter(StoreFieldNode.class)) {
            if (!com.oracle.svm.enterprise.hosted.hybrid.a.fp().a(storeFieldNode.field())) continue;
            ValueNode valueNode = storeFieldNode.object();
            if (StringInliningPhase.m((Node)valueNode)) {
                NewInstanceNode newInstanceNode = (NewInstanceNode)valueNode;
                ArrayList<StoreFieldNode> arrayList = (ArrayList<StoreFieldNode>)economicMap.get((Object)newInstanceNode);
                if (arrayList == null) {
                    arrayList = new ArrayList<StoreFieldNode>(1);
                    economicMap.put((Object)newInstanceNode, arrayList);
                }
                arrayList.add(storeFieldNode);
                continue;
            }
            throw GraalError.shouldNotReachHere((String)("Unexpected type: " + String.valueOf(valueNode.getClass())));
        }
        return economicMap;
    }

    private static void a(FixedNode fixedNode, ValueNode valueNode, StructuredGraph structuredGraph) {
        FixedWithNextNode fixedWithNextNode;
        if (valueNode instanceof FixedWithNextNode && (fixedWithNextNode = (FixedWithNextNode)valueNode).next() == null) {
            structuredGraph.addBeforeFixed(fixedNode, fixedWithNextNode);
        }
    }

    private static JavaKind hH() {
        return JavaKind.Byte;
    }

    private static ResolvedJavaType a(CoreProviders coreProviders) {
        return coreProviders.getMetaAccess().lookupJavaType(Byte.TYPE);
    }

    private static boolean p(StructuredGraph structuredGraph) {
        assert (StringInliningPhase.a(StringInliningPhase.n(structuredGraph)));
        assert (StringInliningPhase.a(structuredGraph.getNodes().filter(AccessFieldNode.class).filter(node -> com.oracle.svm.enterprise.hosted.hybrid.a.fp().a(((AccessFieldNode)node).field())), "Expected all AccessFieldNodes on String.value to have been removed"));
        return true;
    }

    private static boolean a(NodeIterable<?> nodeIterable) {
        assert (nodeIterable.isEmpty()) : nodeIterable.snapshot();
        return true;
    }

    private static boolean a(NodeIterable<?> nodeIterable, String string) {
        assert (nodeIterable.isEmpty()) : string + ": " + String.valueOf(nodeIterable.snapshot());
        return true;
    }

    private static class d {
        private final NodeBitMap yq;
        private final ArrayDeque<Node> yr;

        d(StructuredGraph structuredGraph) {
            this.yq = structuredGraph.createNodeBitMap();
            this.yr = new ArrayDeque();
        }

        public void h(ValueNode valueNode) {
            this.yq.grow();
            if (valueNode.isAlive() && !this.yq.contains((Node)valueNode)) {
                this.yq.mark((Node)valueNode);
                this.yr.add((Node)valueNode);
            }
        }

        public void b(NodeIterable<Node> nodeIterable) {
            this.yq.grow();
            for (Node node : nodeIterable) {
                if (!node.isAlive() || this.yq.contains(node)) continue;
                this.yq.mark(node);
                this.yr.add(node);
            }
        }

        public Node hJ() {
            return this.yr.remove();
        }

        public boolean isEmpty() {
            return this.yr.isEmpty();
        }
    }

    public static class c {
        public static final HostedOptionKey<Boolean> PreventStringValueEscaping = new HostedOptionKey((Object)true);
    }

    private static class a {
        final NewInstanceNode ym;
        final SubstrateNewHybridInstanceNode[] yn;

        a(NewInstanceNode newInstanceNode, SubstrateNewHybridInstanceNode[] substrateNewHybridInstanceNodeArray) {
            this.ym = newInstanceNode;
            this.yn = substrateNewHybridInstanceNodeArray;
        }

        public int hI() {
            return this.yn.length;
        }
    }

    private static class b {
        final ValueNode yo;
        final AbstractEndNode yp;

        b(ValueNode valueNode, AbstractEndNode abstractEndNode) {
            this.yo = valueNode;
            this.yp = abstractEndNode;
        }
    }
}

