/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.phases;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.meta.MethodOffset;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodOffsetConstant;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.meta.SubstrateMethodPointerStamp;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfo;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.cai.e;
import com.oracle.svm.hosted.meta.HostedElement;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.graal.compiler.bytecode.ResolvedJavaMethodBytecode;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.type.ArithmeticStamp;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IllegalStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.RawPointerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.VoidStamp;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.hotspot.nodes.type.HotSpotNarrowOopStamp;
import jdk.graal.compiler.hotspot.nodes.type.KlassPointerStamp;
import jdk.graal.compiler.hotspot.nodes.type.MethodCountersPointerStamp;
import jdk.graal.compiler.hotspot.nodes.type.MethodPointerStamp;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphDecoder;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.vector.nodes.simd.LogicValueStamp;
import jdk.graal.compiler.vector.nodes.simd.SimdStamp;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.word.LocationIdentity;

public class HotMethodDuplicationPhase<C>
extends BasePhase<C> {
    private static final AtomicInteger xV = new AtomicInteger();
    private final double xW;
    private final Function<HostedMethod, e.a> xX;

    public HotMethodDuplicationPhase(Function<HostedMethod, e.a> function, double d2) {
        this.xX = function;
        this.xW = d2;
    }

    protected void run(StructuredGraph structuredGraph, C c2) {
        assert (structuredGraph.globalProfileProvider().hotCaller()) : "Should not run on cold compilation units";
        if (!((Boolean)c.yh.getValue(structuredGraph.getOptions())).booleanValue()) {
            return;
        }
        b b2 = new b(structuredGraph);
        e.a a2 = this.xX.apply((HostedMethod)structuredGraph.method());
        HotMethodDuplicationPhase.a(structuredGraph, invoke -> {
            HostedMethod hostedMethod;
            NodeSourcePosition nodeSourcePosition = FrameState.toSourcePosition((FrameState)invoke.stateDuring());
            e.a a3 = a2.a((BytecodePosition)nodeSourcePosition, (ResolvedJavaMethod)(hostedMethod = (HostedMethod)invoke.getTargetMethod()));
            if (a3 == null) {
                HotMethodDuplicationPhase.a(b2, hostedMethod, "No context", invoke.asNode().getNodeSourcePosition().getBCI());
                return;
            }
            if (!a3.a(this.xW)) {
                HotMethodDuplicationPhase.a(b2, hostedMethod, "Cold " + a3.ev(), invoke.asNode().getNodeSourcePosition().getBCI());
                return;
            }
            HostedMethod hostedMethod2 = HotMethodDuplicationPhase.a(b2, (BytecodePosition)nodeSourcePosition, hostedMethod, a3, invoke);
            assert (invoke.callTarget() != null);
            invoke.callTarget().setTargetMethod((ResolvedJavaMethod)hostedMethod2);
        });
    }

    private static HostedMethod a(b b2, BytecodePosition bytecodePosition, HostedMethod hostedMethod, e.a a2, Invoke invoke) {
        HostedMethod hostedMethod2;
        if (((Boolean)c.yj.getValue(b2.xZ.getOptions())).booleanValue() && a2.eu() && (hostedMethod2 = a2.q(hostedMethod)) != null) {
            HotMethodDuplicationPhase.a(b2, hostedMethod2, "Reusing", invoke.asNode().getNodeSourcePosition().getBCI());
            return hostedMethod2;
        }
        hostedMethod2 = b2.a(hostedMethod, bytecodePosition);
        HotMethodDuplicationPhase.a(b2, hostedMethod2, "Duplicated", invoke.asNode().getNodeSourcePosition().getBCI());
        return hostedMethod2;
    }

    private static void a(b b2, HostedMethod hostedMethod, String string, int n2) {
        if (((Boolean)c.yi.getValue(b2.xZ.getOptions())).booleanValue()) {
            ResolvedJavaMethod resolvedJavaMethod = b2.xZ.method();
            b2.xZ.getDebug().log("[HotMethodDuplicationPhase] %-10s: %-30s called from %s at %d", (Object)string, (Object)hostedMethod.format("%h.%n"), (Object)resolvedJavaMethod.format("%h.%n"), (Object)n2);
        }
    }

    private static void a(StructuredGraph structuredGraph, Consumer<Invoke> consumer) {
        for (Node node : structuredGraph.getNodes()) {
            Invoke invoke;
            if (!(node instanceof Invoke) || !(invoke = (Invoke)node).getInvokeKind().isDirect() || invoke.getTargetMethod() == null) continue;
            consumer.accept(invoke);
        }
    }

    public static class c {
        public static final OptionKey<Boolean> yh = new OptionKey((Object)true);
        public static final OptionKey<Boolean> yi = new OptionKey((Object)false);
        public static final OptionKey<Boolean> yj = new OptionKey((Object)true);
    }

    private static final class b {
        private final StructuredGraph xZ;
        private final Map<a, HostedMethod> ya = new HashMap<a, HostedMethod>();
        private HostedMethod yb;
        private HostedMethod yc;
        private Map<Object, Object> yd;
        private static final Class<?>[] ye = new Class[]{ImageHeapInstance.class, ImageHeapObjectArray.class, SubstrateCallingConventionType.class, StackValueNode.StackSlotIdentity.class, SnippetRuntime.SubstrateForeignCallDescriptor.class, VMThreadLocalInfo.class, Boolean.class, Integer.class, String.class, CompressEncoding.class, ProfileData.BranchProbabilityData.class, ProfileData.SwitchProbabilityData.class, IntegerBelowNode.BelowOp.class, IntegerLessThanNode.LessThanOp.class, Register.class, JavaMethodProfile.class, JavaTypeProfile.class};

        private b(StructuredGraph structuredGraph) {
            this.xZ = structuredGraph;
        }

        private HostedMethod a(HostedMethod hostedMethod, BytecodePosition bytecodePosition) {
            return this.ya.computeIfAbsent(new a(bytecodePosition, hostedMethod.wrapped), a2 -> this.E(hostedMethod));
        }

        private HostedMethod E(HostedMethod hostedMethod) {
            this.yb = hostedMethod;
            this.yc = hostedMethod.getOrCreateMultiMethod((MultiMethod.MultiMethodKey)new com.oracle.svm.enterprise.hosted.phases.HotMethodDuplicationPhase$a());
            this.yd = new IdentityHashMap<Object, Object>();
            EncodedGraph encodedGraph = this.a(hostedMethod.compilationInfo.getCompilationGraph().getEncodedGraph());
            this.yc.compilationInfo.encodeGraph(this.a(encodedGraph, (ResolvedJavaMethod)this.yc));
            return this.yc;
        }

        private EncodedGraph a(EncodedGraph encodedGraph) {
            Object[] objectArray = encodedGraph.getObjects();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray2[i2] = this.q(objectArray[i2]);
            }
            return new EncodedGraph(Arrays.copyOf(encodedGraph.getEncoding(), encodedGraph.getEncoding().length), encodedGraph.getStartOffset(), objectArray2, encodedGraph.getNodeClasses(), encodedGraph.getAssumptions(), encodedGraph.getInlinedMethods(), encodedGraph.hasUnsafeAccess(), encodedGraph.trackNodeSourcePosition());
        }

        private StructuredGraph a(EncodedGraph encodedGraph, ResolvedJavaMethod resolvedJavaMethod) {
            DebugContext debugContext = this.xZ.getDebug();
            StructuredGraph structuredGraph = new StructuredGraph.Builder(this.xZ.getOptions(), debugContext).method(resolvedJavaMethod).recordInlinedMethods(encodedGraph.isRecordingInlinedMethods()).trackNodeSourcePosition(encodedGraph.trackNodeSourcePosition()).compilationId((CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID).build();
            try (DebugContext.Scope scope = debugContext.scope((Object)"HotMethodDuplicationPhase#decodeGraph", (Object)structuredGraph, (Object)resolvedJavaMethod);){
                new GraphDecoder(AnalysisParsedGraph.HOST_ARCHITECTURE, structuredGraph).decode(encodedGraph);
            }
            catch (Throwable throwable) {
                throw debugContext.handle(throwable);
            }
            assert (structuredGraph.verify());
            return structuredGraph;
        }

        private Object q(Object object) {
            if (object == null) {
                return null;
            }
            return this.yd.computeIfAbsent(object, this::r);
        }

        private ResolvedJavaMethod e(ResolvedJavaMethod resolvedJavaMethod) {
            if (Objects.equals(resolvedJavaMethod, this.yb)) {
                return this.yc;
            }
            return (ResolvedJavaMethod)this.q(resolvedJavaMethod);
        }

        private Object r(Object object) {
            assert (object != null) : "newReplacement assumes obj is not null";
            if (object instanceof Node) {
                throw VMError.shouldNotReachHere((String)"Must not replace a Graal graph nodes, only data objects referenced from a node");
            }
            if (object.getClass() == ResolvedJavaMethodBytecode.class) {
                ResolvedJavaMethodBytecode resolvedJavaMethodBytecode = (ResolvedJavaMethodBytecode)object;
                HostedMethod hostedMethod = (HostedMethod)this.q(resolvedJavaMethodBytecode.getMethod());
                return new ResolvedJavaMethodBytecode(this.e((ResolvedJavaMethod)hostedMethod), resolvedJavaMethodBytecode.getOrigin());
            }
            if (object.getClass() == SubstrateMethodPointerConstant.class) {
                SubstrateMethodPointerConstant substrateMethodPointerConstant = (SubstrateMethodPointerConstant)object;
                MethodPointer methodPointer = substrateMethodPointerConstant.pointer();
                ResolvedJavaMethod resolvedJavaMethod = methodPointer.getMethod();
                ResolvedJavaMethod resolvedJavaMethod2 = this.e(resolvedJavaMethod);
                return new SubstrateMethodPointerConstant(new MethodPointer(resolvedJavaMethod2));
            }
            if (object.getClass() == SubstrateMethodOffsetConstant.class) {
                SubstrateMethodOffsetConstant substrateMethodOffsetConstant = (SubstrateMethodOffsetConstant)object;
                ResolvedJavaMethod resolvedJavaMethod = this.e(substrateMethodOffsetConstant.offset().getMethod());
                return new SubstrateMethodOffsetConstant(new MethodOffset(resolvedJavaMethod));
            }
            if (object.getClass() == NodeSourcePosition.class) {
                NodeSourcePosition nodeSourcePosition = (NodeSourcePosition)object;
                NodeSourcePosition nodeSourcePosition2 = (NodeSourcePosition)this.q(nodeSourcePosition.getCaller());
                ResolvedJavaMethod resolvedJavaMethod = this.e(nodeSourcePosition.getMethod());
                return new NodeSourcePosition(nodeSourcePosition.getSourceLanguage(), nodeSourcePosition2, resolvedJavaMethod, nodeSourcePosition.getBCI(), nodeSourcePosition.getMarker());
            }
            if (object instanceof Stamp) {
                return this.u(object);
            }
            if (object.getClass() == StampPair.class) {
                StampPair stampPair = (StampPair)object;
                return StampPair.create((Stamp)((Stamp)this.q(stampPair.getTrustedStamp())), (Stamp)((Stamp)this.q(stampPair.getUncheckedStamp())));
            }
            if (object.getClass() == ArrayList.class) {
                ArrayList arrayList = (ArrayList)object;
                ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
                for (Object e2 : arrayList) {
                    arrayList2.add(this.q(e2));
                }
                return arrayList2;
            }
            if (object instanceof EnumSet) {
                EnumSet enumSet = (EnumSet)object;
                return EnumSet.copyOf(enumSet);
            }
            if (object.getClass() == CGlobalDataInfo.class) {
                return object;
            }
            Cloneable cloneable = this.s(object);
            if (cloneable != null) {
                return cloneable;
            }
            if (b.t(object)) {
                return object;
            }
            assert (false) : "Unknown Type detected during duplication: " + String.valueOf(object.getClass());
            return object;
        }

        private Cloneable s(Object object) {
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                return Arrays.copyOf(sArray, sArray.length);
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return Arrays.copyOf(byArray, byArray.length);
            }
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                return Arrays.copyOf(nArray, nArray.length);
            }
            if (object instanceof long[]) {
                long[] lArray = (long[])object;
                return Arrays.copyOf(lArray, lArray.length);
            }
            if (object instanceof char[]) {
                char[] cArray = (char[])object;
                return Arrays.copyOf(cArray, cArray.length);
            }
            if (object instanceof float[]) {
                float[] fArray = (float[])object;
                return Arrays.copyOf(fArray, fArray.length);
            }
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                return Arrays.copyOf(dArray, dArray.length);
            }
            if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                return Arrays.copyOf(blArray, blArray.length);
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = Arrays.copyOf(objectArray, objectArray.length);
                for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                    objectArray2[i2] = this.q(objectArray2[i2]);
                }
                return objectArray2;
            }
            return null;
        }

        private static boolean t(Object object) {
            if (object instanceof Enum) {
                return true;
            }
            if (object instanceof LocationIdentity) {
                return true;
            }
            if (object instanceof JavaConstant) {
                return true;
            }
            if (object instanceof HostedElement) {
                return true;
            }
            return Arrays.stream(ye).anyMatch(clazz -> object.getClass() == clazz);
        }

        private Object u(Object object) {
            if (object instanceof ArithmeticStamp) {
                if (object.getClass() == SimdStamp.class) {
                    SimdStamp simdStamp = (SimdStamp)object;
                    Stamp[] stampArray = new Stamp[simdStamp.getVectorLength()];
                    for (int i2 = 0; i2 < simdStamp.getVectorLength(); ++i2) {
                        stampArray[i2] = simdStamp.getComponent(i2);
                    }
                    return new SimdStamp(stampArray);
                }
                if (object.getClass() == IntegerStamp.class) {
                    IntegerStamp integerStamp = (IntegerStamp)object;
                    return IntegerStamp.create((int)integerStamp.getBits(), (long)integerStamp.lowerBound(), (long)integerStamp.upperBound());
                }
                if (object.getClass() == FloatStamp.class) {
                    FloatStamp floatStamp = (FloatStamp)object;
                    return FloatStamp.create((int)floatStamp.getBits(), (double)floatStamp.lowerBound(), (double)floatStamp.upperBound(), (boolean)floatStamp.isNonNaN());
                }
                assert (false) : "Unknown Stamp Type during method duplication - subclass of ArithmeticStamp";
            }
            if (object.getClass() == IllegalStamp.class || object.getClass() == VoidStamp.class || object.getClass() == RawPointerStamp.class || object.getClass() == SubstrateMethodPointerStamp.class || object.getClass() == MethodPointerStamp.class || object.getClass() == KlassPointerStamp.class || object.getClass() == MethodCountersPointerStamp.class || object.getClass() == SubstrateNarrowOopStamp.class || object.getClass() == ObjectStamp.class || object.getClass() == PiNode.PlaceholderStamp.class) {
                return object;
            }
            if (object.getClass() == HotSpotNarrowOopStamp.class) assert (false) : "HotSpotNarrowOopStamp found while duplicating method for Substrate use.";
            if (object.getClass() == com.oracle.graal.vector.nodes.type.a.class) {
                com.oracle.graal.vector.nodes.type.a a2 = (com.oracle.graal.vector.nodes.type.a)object;
                return new com.oracle.graal.vector.nodes.type.a((Stamp)this.q(a2.hS()));
            }
            if (object.getClass() == LogicValueStamp.class) {
                return object;
            }
            assert (false) : "Unknown Stamp Type during method duplication: " + String.valueOf(object) + " of class " + String.valueOf(object.getClass());
            return object;
        }

        private static final class a {
            final BytecodePosition yf;
            final AnalysisMethod yg;

            a(BytecodePosition bytecodePosition, AnalysisMethod analysisMethod) {
                this.yf = bytecodePosition;
                this.yg = analysisMethod;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                a a2 = (a)object;
                return Objects.equals(this.yf, a2.yf) && Objects.equals(this.yg, a2.yg);
            }

            public int hashCode() {
                return Objects.hash(this.yf, this.yg);
            }
        }
    }

    private static final class a
    implements MultiMethod.MultiMethodKey {
        final int xY = xV.getAndIncrement();

        private a() {
        }

        public String toString() {
            return "H" + this.xY;
        }
    }
}

