/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.profiles;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.profiling.framework.CommonInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.PGOData;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CallingContextForest;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.UnresolvedJavaType;

public class a
implements PGOProfilesLookup {
    private PGOData xv;
    private b xw;

    public a(PGOData pGOData, b b2) {
        this.xv = pGOData;
        this.xw = b2;
    }

    @Override
    public Optional<PGOProfilesLookup.ProfiledValue<Long>> getCallCountProfile(HostedMethod hostedMethod) {
        if (this.xv == null) {
            return Optional.empty();
        }
        CallingContextForest.BestFit bestFit = this.xv.metadata().forest().findBestFit(a.D(hostedMethod));
        if (bestFit == null) {
            return Optional.empty();
        }
        d d2 = new d();
        bestFit.cursor().forEachPayloadWithCallers(d2);
        if (d2.sq == 0L) {
            return Optional.empty();
        }
        return Optional.of(new PGOProfilesLookup.ProfiledValue<Long>(this.xv.source(), d2.sq));
    }

    @Override
    public boolean isExecuted(HostedMethod hostedMethod) {
        return this.getCallCountOrZero(hostedMethod) > 0L;
    }

    @Override
    public long getCallCountOrZero(HostedMethod hostedMethod) {
        return this.getCallCountProfile(hostedMethod).map(profiledValue -> profiledValue.source().isProfiled() ? (Long)profiledValue.value() : 0L).orElse(0L);
    }

    private static CallingContext D(HostedMethod hostedMethod) {
        return CallingContext.withCallee(new CodePosition(hostedMethod.wrapped.getId(), 0), CallingContext.empty());
    }

    @Override
    public Optional<Map<AnalysisType, Long>> getVirtualInvokeProfile(BytecodePosition bytecodePosition) {
        if (this.xv == null || bytecodePosition == null) {
            return Optional.empty();
        }
        CallingContext callingContext = a.b(bytecodePosition);
        CallingContextForest.BestFit bestFit = this.xv.metadata().forest().findBestFit(callingContext);
        if (bestFit == null) {
            return Optional.empty();
        }
        g g2 = new g();
        a.a(bestFit, g2);
        return g2.xG.isEmpty() ? Optional.empty() : Optional.of(g2.xG);
    }

    @Override
    public Optional<Map<JavaType, Long>> getInstanceofProfile(BytecodePosition bytecodePosition) {
        if (this.xv == null) {
            return Optional.empty();
        }
        CallingContext callingContext = a.b(bytecodePosition);
        CallingContextForest.BestFit bestFit = this.xv.metadata().forest().findBestFit(callingContext);
        if (bestFit == null) {
            return Optional.empty();
        }
        c c2 = new c();
        a.a(bestFit, c2);
        return c2.xB.isEmpty() ? Optional.empty() : Optional.of(c2.xB);
    }

    @Override
    public boolean profileCategoryRecorded(String string) {
        return this.xv.recordedProfileCategories().contains((Object)string);
    }

    @Override
    public Optional<PGOProfilesLookup.ProfiledValue<Long>> getFirstCallTimestampProfile(HostedMethod hostedMethod) {
        if (this.xv == null) {
            return Optional.empty();
        }
        CallingContextForest.BestFit bestFit = this.xv.metadata().forest().findBestFit(a.D(hostedMethod));
        if (bestFit == null) {
            return Optional.empty();
        }
        f f2 = new f();
        bestFit.cursor().forEachPayloadWithCallers(f2);
        if (f2.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new PGOProfilesLookup.ProfiledValue<Long>(this.xv.source(), f2.xE));
    }

    private static CallingContext b(BytecodePosition bytecodePosition) {
        ArrayList<CodePosition> arrayList = new ArrayList<CodePosition>();
        for (BytecodePosition bytecodePosition2 = bytecodePosition; bytecodePosition2 != null; bytecodePosition2 = bytecodePosition2.getCaller()) {
            AnalysisMethod analysisMethod = a.c(bytecodePosition2);
            arrayList.add(new CodePosition(analysisMethod.getId(), bytecodePosition2.getBCI()));
        }
        return CallingContext.create(arrayList);
    }

    private static AnalysisMethod c(BytecodePosition bytecodePosition) {
        ResolvedJavaMethod resolvedJavaMethod = bytecodePosition.getMethod();
        if (resolvedJavaMethod instanceof AnalysisMethod) {
            AnalysisMethod analysisMethod = (AnalysisMethod)resolvedJavaMethod;
            return analysisMethod;
        }
        if (resolvedJavaMethod instanceof HostedMethod) {
            HostedMethod hostedMethod = (HostedMethod)resolvedJavaMethod;
            return hostedMethod.getWrapped();
        }
        throw new IllegalStateException("Unknown subclass of ResolvedJavaMethod");
    }

    private static void a(CallingContextForest.BestFit bestFit, e e2) {
        bestFit.cursor().forEachPayload(e2);
        if (!e2.isEmpty()) {
            return;
        }
        if (bestFit.fullyMatchedCallingContext()) {
            bestFit.cursor().forEachPayloadWithCallers(e2);
            return;
        }
        for (CallingContextForest.Cursor cursor : bestFit.calleeContext().reversed()) {
            cursor.forEachPayload(e2);
            if (e2.isEmpty()) continue;
            return;
        }
    }

    @Override
    public Optional<PGOProfilesLookup.ProfiledValue<long[]>> getConditionalProfile(BytecodePosition bytecodePosition) {
        if (this.xv == null) {
            return Optional.empty();
        }
        CallingContextForest.BestFit bestFit = this.xv.metadata().forest().findBestFit(a.b(bytecodePosition));
        if (bestFit == null) {
            return Optional.empty();
        }
        a a2 = new a();
        a.a(bestFit, a2);
        return a2.xx == null ? Optional.empty() : Optional.of(new PGOProfilesLookup.ProfiledValue<long[]>(this.xv.source(), a2.xx));
    }

    @Override
    public Optional<Map<AnalysisType, Long>> getMonitorProfiles() {
        if (this.xv == null) {
            return Optional.empty();
        }
        HashMap hashMap = new HashMap();
        this.xv.metadata().forEachMonitorTypeID(n2 -> {
            AnalysisType analysisType = this.xw.xz.get(n2);
            long l2 = this.xv.commonInstrumentationData().readTotalMonitorCount(n2);
            hashMap.put(analysisType, l2);
        });
        return hashMap.isEmpty() ? Optional.empty() : Optional.of(hashMap);
    }

    @Override
    public Optional<Map<NodeSourcePosition, Long>> getSampleCounts() {
        if (this.xv == null) {
            return Optional.empty();
        }
        return Optional.of(this.hC());
    }

    private Map<NodeSourcePosition, Long> hC() {
        HashMap<NodeSourcePosition, Long> hashMap = new HashMap<NodeSourcePosition, Long>();
        this.xv.samplingData().samples().topDown((callingContext, l2) -> {
            if (l2 > 0L) {
                NodeSourcePosition nodeSourcePosition = this.a((CallingContext)callingContext);
                hashMap.put(nodeSourcePosition, (Long)l2);
            }
        });
        return hashMap;
    }

    private NodeSourcePosition a(CallingContext callingContext) {
        NodeSourcePosition[] nodeSourcePositionArray;
        block2: {
            nodeSourcePositionArray = new NodeSourcePosition[]{null};
            try {
                callingContext.traverseFromCallee(codePosition -> {
                    nodeSourcePositionArray[0] = new NodeSourcePosition(nodeSourcePositionArray[0], (ResolvedJavaMethod)this.xw.xA.get(codePosition.methodID()), codePosition.bci());
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Unexpected exception: such cases should be filtered out when building PGOData!");
            }
        }
        return nodeSourcePositionArray[0];
    }

    @Override
    public void clear() {
        this.xv = null;
        this.xw = null;
    }

    private static long c(long l2, long l3) {
        assert (l2 >= 0L && l3 >= 0L) : "Negative counter value";
        long l4 = Math.max(0L, l2) + Math.max(0L, l3);
        return l4 >= 0L ? l4 : Long.MAX_VALUE;
    }

    public static final class b
    extends Record {
        private final Map<Integer, AnalysisType> xz;
        private final Map<Integer, AnalysisMethod> xA;
        private final Map<Integer, UnresolvedJavaType> unresolvedJavaTypeMap;

        public b() {
            this(new HashMap<Integer, AnalysisType>(), new HashMap<Integer, AnalysisMethod>(), new HashMap<Integer, UnresolvedJavaType>());
        }

        public b(Map<Integer, AnalysisType> map, Map<Integer, AnalysisMethod> map2, Map<Integer, UnresolvedJavaType> map3) {
            this.xz = map;
            this.xA = map2;
            this.unresolvedJavaTypeMap = map3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "globalIDToAnalysisType;globalIDToAnalysisMethod;unresolvedJavaTypeMap", "xz", "xA", "unresolvedJavaTypeMap"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "globalIDToAnalysisType;globalIDToAnalysisMethod;unresolvedJavaTypeMap", "xz", "xA", "unresolvedJavaTypeMap"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "globalIDToAnalysisType;globalIDToAnalysisMethod;unresolvedJavaTypeMap", "xz", "xA", "unresolvedJavaTypeMap"}, this, object);
        }

        public Map<Integer, AnalysisType> hD() {
            return this.xz;
        }

        public Map<Integer, AnalysisMethod> hE() {
            return this.xA;
        }

        public Map<Integer, UnresolvedJavaType> hF() {
            return this.unresolvedJavaTypeMap;
        }
    }

    private final class d
    implements CallingContextForest.PayloadConsumer {
        long sq;

        private d() {
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.MethodEntryPayload) {
                CommonInstrumentationData.MethodEntryPayload methodEntryPayload = (CommonInstrumentationData.MethodEntryPayload)payload;
                this.sq += methodEntryPayload.readTotalCounterValue(a.this.xv.commonInstrumentationData().storage());
            }
        }
    }

    private final class g
    extends e {
        Map<AnalysisType, Long> xG;

        private g() {
            super(a.this);
            this.xG = new HashMap<AnalysisType, Long>();
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.VirtualCallPayload) {
                CommonInstrumentationData.VirtualCallPayload virtualCallPayload = (CommonInstrumentationData.VirtualCallPayload)payload;
                for (int i2 = 0; i2 < virtualCallPayload.length(); ++i2) {
                    int n2 = virtualCallPayload.typeID(a.this.xv.commonInstrumentationData().storage(), i2);
                    long l2 = virtualCallPayload.readTotalCounterValue(a.this.xv.commonInstrumentationData().storage(), i2);
                    AnalysisType analysisType = a.this.xw.xz.get(n2);
                    if (analysisType == null || l2 <= 0L) {
                        assert (l2 == 0L) : "Negative value in virtual call counter: " + l2;
                        continue;
                    }
                    this.xG.merge(analysisType, l2, a::c);
                }
            }
        }

        @Override
        boolean isEmpty() {
            return this.xG.isEmpty();
        }
    }

    private abstract class e
    implements CallingContextForest.PayloadConsumer {
        private e(a a2) {
        }

        abstract boolean isEmpty();
    }

    private final class c
    extends e {
        Map<JavaType, Long> xB;

        private c() {
            super(a.this);
            this.xB = new HashMap<JavaType, Long>();
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.InstanceOfPayload) {
                CommonInstrumentationData.InstanceOfPayload instanceOfPayload = (CommonInstrumentationData.InstanceOfPayload)payload;
                for (int i2 = 0; i2 < instanceOfPayload.length(); ++i2) {
                    int n2 = instanceOfPayload.typeID(a.this.xv.commonInstrumentationData().storage(), i2);
                    long l2 = instanceOfPayload.readTotalCounterValue(a.this.xv.commonInstrumentationData().storage(), i2);
                    assert (l2 >= 0L) : "Negative value in virtual call counter: " + l2;
                    AnalysisType analysisType = a.this.xw.xz.get(n2);
                    if (analysisType == null) {
                        UnresolvedJavaType unresolvedJavaType = a.this.xw.unresolvedJavaTypeMap.get(n2);
                        if (unresolvedJavaType == null) continue;
                        this.xB.merge((JavaType)unresolvedJavaType, l2, a::c);
                        continue;
                    }
                    this.xB.merge((JavaType)analysisType, l2, a::c);
                }
            }
        }

        @Override
        boolean isEmpty() {
            return this.xB.isEmpty();
        }
    }

    private final class f
    extends e {
        long xE;

        private f() {
            super(a.this);
        }

        @Override
        boolean isEmpty() {
            return this.xE == 0L;
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.TimestampPayload) {
                CommonInstrumentationData.TimestampPayload timestampPayload = (CommonInstrumentationData.TimestampPayload)payload;
                long l2 = timestampPayload.readCallTimestamp(a.this.xv.commonInstrumentationData().storage());
                if (this.isEmpty() || l2 < this.xE) {
                    this.xE = l2;
                }
            }
        }
    }

    private final class a
    extends e {
        long[] xx;

        private a() {
            super(a.this);
        }

        @Override
        public void accept(CallingContextForest.Payload payload) {
            if (payload instanceof CommonInstrumentationData.ConditionalPayload) {
                int n2;
                CommonInstrumentationData.ConditionalPayload conditionalPayload = (CommonInstrumentationData.ConditionalPayload)payload;
                if (this.xx == null) {
                    this.xx = new long[conditionalPayload.length() * 3];
                    for (n2 = 0; n2 < conditionalPayload.length(); ++n2) {
                        this.xx[3 * n2] = conditionalPayload.bciAt(n2);
                        this.xx[3 * n2 + 1] = conditionalPayload.successorAt(n2);
                    }
                }
                if (3 * conditionalPayload.length() != this.xx.length) {
                    return;
                }
                for (n2 = 0; n2 < conditionalPayload.length(); ++n2) {
                    long l2 = conditionalPayload.readTotalCounterValue(a.this.xv.commonInstrumentationData().storage(), n2);
                    if (l2 <= 0L) {
                        assert (l2 == 0L) : "Negative value in conditional counter: " + l2;
                        continue;
                    }
                    this.xx[3 * n2 + 2] = a.c(this.xx[3 * n2 + 2], l2);
                }
            }
        }

        @Override
        boolean isEmpty() {
            return this.xx == null;
        }
    }
}

