/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.profiles;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaType;
import org.graalvm.nativeimage.ImageSingletons;

public interface PGOProfilesLookup {
    public static PGOProfilesLookup singleton() {
        return ImageSingletons.contains(PGOProfilesLookup.class) ? (PGOProfilesLookup)ImageSingletons.lookup(PGOProfilesLookup.class) : null;
    }

    public Optional<ProfiledValue<Long>> getCallCountProfile(HostedMethod var1);

    public long getCallCountOrZero(HostedMethod var1);

    public boolean isExecuted(HostedMethod var1);

    public Optional<Map<AnalysisType, Long>> getVirtualInvokeProfile(BytecodePosition var1);

    public Optional<ProfiledValue<long[]>> getConditionalProfile(BytecodePosition var1);

    public Optional<Map<AnalysisType, Long>> getMonitorProfiles();

    default public Optional<Map<NodeSourcePosition, Long>> getSampleCounts() {
        return Optional.empty();
    }

    public boolean profileCategoryRecorded(String var1);

    default public void clear() {
    }

    default public Optional<Map<JavaType, Long>> getInstanceofProfile(BytecodePosition bytecodePosition) {
        return Optional.empty();
    }

    default public Optional<ProfiledValue<Long>> getFirstCallTimestampProfile(HostedMethod hostedMethod) {
        return Optional.empty();
    }

    public record ProfiledValue<T>(ProfileData.ProfileSource source, T value) {
    }
}

