/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.phases;

import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.enterprise.hosted.cai.e;
import com.oracle.svm.enterprise.hosted.pgo.b;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.phases.SingleRunSubphase;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import org.graalvm.collections.EconomicMap;

public final class PGOApplyProfilesPhase
extends SingleRunSubphase<HighTierContext> {
    private static final int INVALID_BRANCH_BCI = -5;
    public static final int CONDITIONAL_RECORD_SIZE = 3;
    private static final int CONDITIONAL_RECORD_BCI_POSITION = 0;
    public static final int CONDITIONAL_RECORD_KEY_POSITION = 1;
    public static final int CONDITIONAL_RECORD_COUNTER_POSITION = 2;
    private final PGOProfilesLookup pgoProfiles;
    private final NodeSourcePosition inliningContext;
    private final HostedUniverse hUniverse;
    private final e.a compilationRootContext;
    private final boolean forceHot;
    private final a.a profileQualityLevel;

    public static PGOApplyProfilesPhase createForExpandingHotCutoffs(NodeSourcePosition nodeSourcePosition, HostedUniverse hostedUniverse, e.a a2, PGOProfilesLookup pGOProfilesLookup) {
        return new PGOApplyProfilesPhase(nodeSourcePosition, hostedUniverse, a2, pGOProfilesLookup, true, a.a.xs);
    }

    public static PGOApplyProfilesPhase createForExpandingCutoffs(NodeSourcePosition nodeSourcePosition, HostedUniverse hostedUniverse, PGOProfilesLookup pGOProfilesLookup) {
        return new PGOApplyProfilesPhase(nodeSourcePosition, hostedUniverse, null, pGOProfilesLookup, false, a.a.xs);
    }

    public static PGOApplyProfilesPhase createForBeforeHotCompilationPhase(HostedUniverse hostedUniverse, e.a a2, PGOProfilesLookup pGOProfilesLookup) {
        return new PGOApplyProfilesPhase(null, hostedUniverse, a2, pGOProfilesLookup, false, a.a.xs);
    }

    public static PGOApplyProfilesPhase createContextInsensitive(HostedUniverse hostedUniverse, PGOProfilesLookup pGOProfilesLookup) {
        a.a a2 = a.a.xs;
        if (((Boolean)PGOFeature.a.PGOPrintProfileQuality.getValue()).booleanValue()) {
            a2 = a.a.xt;
            if (((Boolean)PGOFeature.a.PGOPrintProfileQualityDetails.getValue()).booleanValue()) {
                a2 = a.a.xu;
            }
        }
        return new PGOApplyProfilesPhase(null, hostedUniverse, null, pGOProfilesLookup, false, a2);
    }

    private PGOApplyProfilesPhase(NodeSourcePosition nodeSourcePosition, HostedUniverse hostedUniverse, e.a a2, PGOProfilesLookup pGOProfilesLookup, boolean bl2, a.a a3) {
        this.pgoProfiles = pGOProfilesLookup;
        this.inliningContext = nodeSourcePosition;
        this.hUniverse = hostedUniverse;
        this.compilationRootContext = a2;
        this.forceHot = bl2;
        this.profileQualityLevel = a3;
    }

    public static int[] bytecodeIndicesForConditionals(long[] lArray) {
        int[] nArray = new int[lArray.length / 3];
        for (int i2 = 0; i2 < lArray.length; i2 += 3) {
            nArray[i2 / 3] = (int)lArray[i2];
        }
        return nArray;
    }

    public static boolean validConditionalBci(long l2) {
        return l2 != -5L;
    }

    public static int[] conditionalMappings(long[] lArray) {
        int[] nArray = new int[lArray.length / 3];
        for (int i2 = 1; i2 < lArray.length; i2 += 3) {
            nArray[i2 / 3] = (int)lArray[i2];
        }
        return nArray;
    }

    public static int conditionalRecordCount(int n2) {
        return n2 / 3;
    }

    public static Optional<double[]> distributeConditionalProbabilities(long[] lArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < lArray.length; i2 += 3) {
            if (lArray[i2 + 1] <= (long)n2) continue;
            n2 = (int)lArray[i2 + 1];
        }
        long[] lArray2 = new long[n2 + 1];
        int[] nArray = new int[n2 + 1];
        for (int i3 = 0; i3 < lArray.length; i3 += 3) {
            int n3 = (int)lArray[i3 + 1];
            nArray[n3] = nArray[n3] + 1;
            int n4 = (int)lArray[i3 + 1];
            lArray2[n4] = lArray2[n4] + lArray[i3 + 2];
        }
        long l2 = Arrays.stream(lArray2).sum();
        if (l2 == 0L) {
            return Optional.empty();
        }
        int n5 = PGOApplyProfilesPhase.conditionalRecordCount(lArray.length);
        double[] dArray = new double[n5];
        for (int i4 = 0; i4 < n5; ++i4) {
            int n6 = (int)lArray[i4 * 3 + 1];
            dArray[i4] = 1.0 * (double)lArray2[n6] / (double)((long)nArray[n6] * l2);
        }
        return Optional.of(PGOApplyProfilesPhase.clampProbabilities(dArray));
    }

    static double[] clampProbabilities(double[] dArray) {
        PGOApplyProfilesPhase.assertProbabilities(dArray);
        int n2 = (int)Arrays.stream(dArray).filter(d2 -> d2 == 0.0).count();
        if (n2 == 0) {
            return dArray;
        }
        double d3 = (double)n2 * 1.0000000000287557E-6;
        double d5 = 1.0 / (1.0 - (double)(dArray.length - n2) * 1.0000000000287557E-6);
        double[] dArray2 = Arrays.stream(dArray).map(d4 -> PGOApplyProfilesPhase.clampProbability(d4, d3, d5)).toArray();
        PGOApplyProfilesPhase.assertProbabilities(dArray2);
        return dArray2;
    }

    private static double clampProbability(double d2, double d3, double d4) {
        return d2 == 0.0 ? 1.0000000000287557E-6 : d2 - d3 * (d2 - 1.0000000000287557E-6) * d4;
    }

    private static void assertProbabilities(double[] dArray) {
        double d2 = Arrays.stream(dArray).sum();
        assert (d2 > 0.999 && d2 < 1.001) : "Total probability sum is :" + d2;
    }

    protected void run(StructuredGraph structuredGraph, HighTierContext highTierContext) {
        this.incrementMethodCounter();
        this.updateProfilesForInvokes(structuredGraph);
        this.updateProfilesForConditionals(structuredGraph);
        this.updateProfilesForInstanceofs(structuredGraph);
    }

    private void incrementMethodCounter() {
        if (this.profileQualityLevel.a(a.a.xt)) {
            a.xq.incrementAndGet();
        }
    }

    private void updateProfilesForConditionals(StructuredGraph structuredGraph) {
        if (!this.pgoProfiles.profileCategoryRecorded("conditionalProfiles")) {
            return;
        }
        PGOApplyProfilesPhase.forEachRelevantControlSplitNode(structuredGraph, this::updateConditionalProbabilitiesBasedOnSamples);
        PGOApplyProfilesPhase.forEachRelevantControlSplitNode(structuredGraph, this::updateConditionalProbabilities);
    }

    private void updateProfilesForInvokes(StructuredGraph structuredGraph) {
        if (!this.pgoProfiles.profileCategoryRecorded("virtualInvokeProfiles")) {
            return;
        }
        Consumer<MethodCallTargetNode> consumer = this.forceHot || structuredGraph.globalProfileProvider().hotCaller() ? this::updateInvokeProfileForHotCaller : this::updateInvokeProfileForColdCompilationUnit;
        PGOApplyProfilesPhase.forEachIndirectInvoke(structuredGraph, consumer);
    }

    private void updateProfilesForInstanceofs(StructuredGraph structuredGraph) {
        if (!this.pgoProfiles.profileCategoryRecorded("instanceOfProfiles")) {
            return;
        }
        for (InstanceOfNode instanceOfNode : structuredGraph.getNodes().filter(InstanceOfNode.class)) {
            NodeSourcePosition nodeSourcePosition = PGOApplyProfilesPhase.createPointContext(instanceOfNode.getNodeSourcePosition(), this.inliningContext);
            Optional<Map<JavaType, Long>> optional = this.pgoProfiles.getInstanceofProfile((BytecodePosition)nodeSourcePosition);
            if (optional.isPresent()) {
                Optional<Map<AnalysisType, Long>> optional2 = Optional.of(optional.get().entrySet().stream().filter(entry -> entry.getKey() instanceof AnalysisType).collect(Collectors.toMap(entry -> (AnalysisType)entry.getKey(), Map.Entry::getValue)));
                if (!optional2.get().isEmpty()) {
                    JavaTypeProfile javaTypeProfile = b.a(instanceOfNode.profile(), optional2, (Universe)this.hUniverse, true);
                    instanceOfNode.setProfile(javaTypeProfile, instanceOfNode.getAnchor());
                    this.countSuccess();
                    continue;
                }
                this.countFailure(nodeSourcePosition);
                continue;
            }
            this.countFailure(nodeSourcePosition);
        }
    }

    private void updateInvokeProfileForColdCompilationUnit(MethodCallTargetNode methodCallTargetNode) {
        this.updateInvokesWithNewProfiles(methodCallTargetNode);
    }

    private static void forEachIndirectInvoke(StructuredGraph structuredGraph, Consumer<MethodCallTargetNode> consumer) {
        List list = structuredGraph.getNodes(MethodCallTargetNode.TYPE).snapshot();
        for (MethodCallTargetNode methodCallTargetNode : list) {
            if (!methodCallTargetNode.invokeKind().isIndirect()) continue;
            consumer.accept(methodCallTargetNode);
        }
    }

    private void updateInvokeProfileForHotCaller(MethodCallTargetNode methodCallTargetNode) {
        this.updateInvokeProfileForColdCompilationUnit(methodCallTargetNode);
        if (this.compilationRootContext == null) {
            return;
        }
        JavaMethodProfile javaMethodProfile = PGOApplyProfilesPhase.validateProfile((CallTargetNode)methodCallTargetNode, this.compilationRootContext.a(this.hUniverse, (BytecodePosition)methodCallTargetNode.getNodeSourcePosition()));
        if (javaMethodProfile != null) {
            ((SubstrateMethodCallTargetNode)methodCallTargetNode).setJavaMethodProfile(javaMethodProfile);
        }
    }

    public static JavaMethodProfile validateProfile(CallTargetNode callTargetNode, JavaMethodProfile javaMethodProfile) {
        if (javaMethodProfile == null || callTargetNode == null || callTargetNode.targetMethod() == null) {
            return callTargetNode instanceof IndirectCallTargetNode ? javaMethodProfile : null;
        }
        ArrayList<JavaMethodProfile.ProfiledMethod> arrayList = new ArrayList<JavaMethodProfile.ProfiledMethod>();
        double d2 = javaMethodProfile.getNotRecordedProbability();
        boolean bl2 = true;
        HostedMethod hostedMethod = (HostedMethod)callTargetNode.targetMethod();
        HashSet<HostedMethod> hashSet = new HashSet<HostedMethod>(Arrays.asList(hostedMethod.getImplementations()));
        hashSet.add(hostedMethod);
        for (JavaMethodProfile.ProfiledMethod profiledMethod : javaMethodProfile.getMethods()) {
            if (hashSet.contains(profiledMethod.getMethod())) {
                arrayList.add(profiledMethod);
                continue;
            }
            bl2 = false;
            d2 += profiledMethod.getProbability();
        }
        return bl2 ? javaMethodProfile : new JavaMethodProfile(d2, arrayList.toArray(new JavaMethodProfile.ProfiledMethod[0]));
    }

    private void updateInvokesWithNewProfiles(MethodCallTargetNode methodCallTargetNode) {
        NodeSourcePosition nodeSourcePosition = PGOApplyProfilesPhase.createPointContext(methodCallTargetNode.getNodeSourcePosition(), this.inliningContext);
        Optional<Map<AnalysisType, Long>> optional = this.pgoProfiles.getVirtualInvokeProfile((BytecodePosition)nodeSourcePosition);
        if (optional.isPresent()) {
            SubstrateMethodCallTargetNode substrateMethodCallTargetNode = (SubstrateMethodCallTargetNode)methodCallTargetNode;
            JavaTypeProfile javaTypeProfile = b.a(substrateMethodCallTargetNode.getTypeProfile(), optional, (Universe)this.hUniverse, true);
            JavaMethodProfile javaMethodProfile = b.a(substrateMethodCallTargetNode.getMethodProfile(), javaTypeProfile);
            substrateMethodCallTargetNode.setProfiles(javaTypeProfile, javaMethodProfile);
            this.countSuccess();
        } else {
            this.countFailure(nodeSourcePosition);
        }
    }

    private void countSuccess() {
        if (this.profileQualityLevel.a(a.a.xt)) {
            a.xm.incrementAndGet();
        }
    }

    private void countFailure(NodeSourcePosition nodeSourcePosition) {
        if (this.profileQualityLevel.a(a.a.xt)) {
            a.xn.incrementAndGet();
            if (this.profileQualityLevel.a(a.a.xu)) {
                a.xr.add(nodeSourcePosition);
            }
        }
    }

    private static void forEachRelevantControlSplitNode(StructuredGraph structuredGraph, Consumer<ControlSplitNode> consumer) {
        EconomicMap<NodeSourcePosition, List<ControlSplitNode>> economicMap = com.oracle.svm.enterprise.hosted.profiling.utilities.a.q(structuredGraph);
        for (List list : economicMap.getValues()) {
            for (ControlSplitNode controlSplitNode : list) {
                consumer.accept(controlSplitNode);
            }
        }
    }

    private void updateConditionalProbabilitiesBasedOnSamples(ControlSplitNode controlSplitNode) {
    }

    private void updateConditionalProbabilities(ControlSplitNode controlSplitNode) {
        NodeSourcePosition nodeSourcePosition = PGOApplyProfilesPhase.createPointContext(controlSplitNode.getNodeSourcePosition(), this.inliningContext);
        Optional<PGOProfilesLookup.ProfiledValue<long[]>> optional = this.pgoProfiles.getConditionalProfile((BytecodePosition)nodeSourcePosition);
        optional.ifPresentOrElse(profiledValue -> {
            PGOApplyProfilesPhase.setSuccessorsProbabilities(profiledValue.source(), (long[])profiledValue.value(), controlSplitNode);
            this.countSuccess();
        }, () -> this.countFailure(nodeSourcePosition));
    }

    private static void setSuccessorsProbabilities(ProfileData.ProfileSource profileSource, long[] lArray, ControlSplitNode controlSplitNode) {
        List list = controlSplitNode.successors().snapshot();
        List<Node> list2 = list.stream().filter(Node::isAlive).collect(Collectors.toList());
        Optional<Map<Integer, Double>> optional = PGOApplyProfilesPhase.aggregatedProbabilities(lArray);
        if (optional.isEmpty()) {
            return;
        }
        List<Node> list3 = PGOApplyProfilesPhase.successorsMatchingProfiles(list2, optional.get());
        list3.forEach(node -> controlSplitNode.setProbability((AbstractBeginNode)node, ProfileData.BranchProbabilityData.create((double)((Double)((Map)optional.get()).get(node.getNodeSourcePosition().getBCI())), (ProfileData.ProfileSource)profileSource)));
    }

    public static Optional<Map<Integer, Double>> aggregatedProbabilities(long[] lArray) {
        int[] nArray = PGOApplyProfilesPhase.bytecodeIndicesForConditionals(lArray);
        int[] nArray2 = PGOApplyProfilesPhase.conditionalMappings(lArray);
        Optional<double[]> optional = PGOApplyProfilesPhase.distributeConditionalProbabilities(lArray);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        HashMap<Integer, Double> hashMap = new HashMap<Integer, Double>();
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            if (hashMap.containsKey(nArray2[i2])) {
                hashMap.put(nArray2[i2], (Double)hashMap.get(nArray2[i2]) + optional.get()[i2]);
                continue;
            }
            hashMap.put(nArray2[i2], optional.get()[i2]);
        }
        HashMap<Integer, Double> hashMap2 = new HashMap<Integer, Double>();
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            if (!PGOApplyProfilesPhase.validConditionalBci(nArray[i3])) continue;
            hashMap2.put(nArray[i3], (Double)hashMap.get(nArray2[i3]));
        }
        return Optional.of(hashMap2);
    }

    public static List<Node> successorsMatchingProfiles(List<Node> list, Map<Integer, Double> map) {
        return list.stream().filter(node -> map.containsKey(node.getNodeSourcePosition().getBCI())).collect(Collectors.toList());
    }

    public static NodeSourcePosition createPointContext(NodeSourcePosition nodeSourcePosition, NodeSourcePosition nodeSourcePosition2) {
        NodeSourcePosition nodeSourcePosition3;
        NodeSourcePosition nodeSourcePosition4 = new NodeSourcePosition(null, nodeSourcePosition.getMethod(), nodeSourcePosition.getBCI());
        for (nodeSourcePosition3 = nodeSourcePosition.getCaller(); nodeSourcePosition3 != null; nodeSourcePosition3 = nodeSourcePosition3.getCaller()) {
            nodeSourcePosition4.addCaller(nodeSourcePosition3);
        }
        for (nodeSourcePosition3 = nodeSourcePosition2; nodeSourcePosition3 != null; nodeSourcePosition3 = nodeSourcePosition3.getCaller()) {
            nodeSourcePosition4.addCaller(nodeSourcePosition3);
        }
        return nodeSourcePosition4;
    }

    public static final class com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase$a {
        private static final AtomicLong xm = new AtomicLong();
        private static final AtomicLong xn = new AtomicLong();
        private static final AtomicLong xo = new AtomicLong();
        private static final AtomicLong xp = new AtomicLong();
        private static final AtomicLong xq = new AtomicLong();
        private static final List<NodeSourcePosition> xr = Collections.synchronizedList(new ArrayList());

        private com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase$a() {
        }

        public static long hr() {
            return xm.get();
        }

        public static long hs() {
            return xn.get();
        }

        public static long ht() {
            return xq.get();
        }

        public static List<NodeSourcePosition> hx() {
            return Collections.unmodifiableList(xr);
        }

        public static double hy() {
            long l2;
            long l3 = com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase$a.hr();
            long l4 = l3 + (l2 = com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase$a.hs());
            return l4 == 0L ? 0.0 : 100.0 * (double)l3 / (double)l4;
        }

        public static double hz() {
            long l2 = xo.get();
            long l3 = xp.get();
            return l2 == 0L ? 0.0 : 100.0 * (double)l3 / (double)l2;
        }

        public static void b(long l2, long l3) {
            xo.addAndGet(l3);
            xp.addAndGet(l2);
        }

        static final class a
        extends Enum<a> {
            public static final /* enum */ a xs = new a();
            public static final /* enum */ a xt = new a();
            public static final /* enum */ a xu = new a();
            private static final /* synthetic */ a[] $VALUES;

            public static a[] values() {
                return (a[])$VALUES.clone();
            }

            public static a ai(String string) {
                return Enum.valueOf(a.class, string);
            }

            boolean a(a a2) {
                return this.ordinal() >= a2.ordinal();
            }

            private static /* synthetic */ a[] hA() {
                return new a[]{xs, xt, xu};
            }

            static {
                $VALUES = a.hA();
            }
        }
    }
}

