/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.features;

import com.oracle.graal.phases.preciseinline.priorityinline.PriorityInliningPhase;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.enterprise.core.aq;
import com.oracle.svm.enterprise.hosted.ml.features.provider.ProfileInferenceFeature;
import com.oracle.svm.enterprise.hosted.pgo.b;
import com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.hosted.pgo.profiles.a;
import com.oracle.svm.enterprise.hosted.profilingframework.d;
import com.oracle.svm.enterprise.profiling.framework.Metadata;
import com.oracle.svm.enterprise.profiling.framework.PGOData;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.framework.ProfilingData;
import com.oracle.svm.enterprise.profiling.loaders.IprofContent;
import com.oracle.svm.hosted.FeatureImpl;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.JavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class PGOFeature
implements InternalFeature {
    private static final String PGO_OPTIMIZED_QUALIFIER = "PGO optimized";
    private static final Map<String, String> excludeToIprofKeyMap = new HashMap<String, String>();

    private static void validatePGOExcludeProfiles(HostedOptionKey<String> hostedOptionKey) {
        if (hostedOptionKey.getValue() == null) {
            return;
        }
        UserError.guarantee((boolean)PGOFeature.isPGOEnabled(), (String)"'%s' require either '%s' or '%s'.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(a.PGOExcludeProfiles, (String)"MASK"), SubstrateOptionsParser.commandArgument(a.PGOEnabled, (String)"PROFILES"), SubstrateOptionsParser.commandArgument(a.AdoptedPGOEnabled, (String)"ADOPTED_PROFILES")});
    }

    public static boolean isPGOEnabled() {
        return PGOFeature.isPGOEnabled(HostedOptionValues.singleton().getMap());
    }

    public static boolean isPGOEnabled(UnmodifiableEconomicMap<OptionKey<?>, Object> unmodifiableEconomicMap) {
        return unmodifiableEconomicMap.containsKey(a.PGOEnabled) || unmodifiableEconomicMap.containsKey(a.AdoptedPGOEnabled);
    }

    public static boolean isUserCollectedPGOEnabled() {
        return a.PGOEnabled.hasBeenSet();
    }

    private static void validatePGOOption(HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> hostedOptionKey) {
        if (!hostedOptionKey.hasBeenSet()) {
            return;
        }
        PGOFeature.validateMutuallyExclusivePGOOptions();
        UserError.guarantee((!SubstrateOptions.Optimize.hasBeenSet() || SubstrateOptions.isMaximumOptimizationLevel() ? 1 : 0) != 0, (String)"Optimization level cannot be changed via '%s' when '%s' is used. Native Image enables all optimizations for PGO builds.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.Optimize, (String)((String)SubstrateOptions.Optimize.getValue())), SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)((AccumulatingLocatableMultiOptionValue.Paths)hostedOptionKey.getValue()).toString())});
        UserError.guarantee((boolean)((Boolean)aq.AOTPriorityInline.getValue()), (String)"Cannot disable priority inlining via '%s' when '%s' is used. Native Image enables all optimizations for PGO builds.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(aq.AOTPriorityInline, (String)"-"), SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)((AccumulatingLocatableMultiOptionValue.Paths)hostedOptionKey.getValue()).toString())});
        UserError.guarantee((boolean)((Boolean)com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining.getValue()), (String)"Cannot disable context-aware inlining via '%s' when '%s' is used.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining, (String)"-"), SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)((AccumulatingLocatableMultiOptionValue.Paths)hostedOptionKey.getValue()).toString())});
        UserError.guarantee(((Boolean)ProfileInferenceFeature.b.MLProfileInference.getValue() == false || ProfileInferenceFeature.shouldLogMLProfileInference() ? 1 : 0) != 0, (String)"Cannot enable ML profile inference via '%s' when '%s' is used, unless ML debug mode is active. Native Image only allows ML inference to run alongside dynamic profiling when in ML debug mode. To enable ML debug mode, add the following flag to your command: '%s'.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(ProfileInferenceFeature.b.MLProfileInference, (String)"+"), SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)((AccumulatingLocatableMultiOptionValue.Paths)hostedOptionKey.getValue()).toString()), SubstrateOptionsParser.commandArgument(ProfileInferenceFeature.b.LogMLInference, (String)"FILE")});
        UserError.guarantee(((Boolean)ProfileInferenceFeature.b.MLCallCountProfileInference.getValue() == false ? 1 : 0) != 0, (String)"Cannot enable ML call count profile inference via '%s' when '%s' is used.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(ProfileInferenceFeature.b.MLCallCountProfileInference, (String)"+"), SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)((AccumulatingLocatableMultiOptionValue.Paths)hostedOptionKey.getValue()).toString())});
        OptionValues optionValues = HostedOptionValues.singleton();
        UserError.guarantee((boolean)((Boolean)GraalOptions.TrackNodeSourcePosition.getValue(optionValues)), (String)"Cannot disable tracking of node source positions via '%s' when '%s' is used.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)GraalOptions.TrackNodeSourcePosition, (String)"-"), SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)((AccumulatingLocatableMultiOptionValue.Paths)hostedOptionKey.getValue()).toString())});
        UserError.guarantee(((Boolean)PriorityInliningPhase.b.wS.getValue(optionValues) == false ? 1 : 0) != 0, (String)"Cannot enable graph cache via '%s' when '%s' is used.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)PriorityInliningPhase.b.wS, (String)"+"), SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)((AccumulatingLocatableMultiOptionValue.Paths)hostedOptionKey.getValue()).toString())});
    }

    public static void validateMutuallyExclusivePGOOptions() {
        UserError.guarantee((!PGOFeature.isPGOEnabled() || (Boolean)d.b.ProfilingEnabled.getValue() == false ? 1 : 0) != 0, (String)"'%s' and '%s' cannot be used with '%s' at the same time.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(a.PGOEnabled, (String)((AccumulatingLocatableMultiOptionValue.Paths)a.PGOEnabled.getValue()).toString()), SubstrateOptionsParser.commandArgument(a.AdoptedPGOEnabled, (String)((AccumulatingLocatableMultiOptionValue.Paths)a.AdoptedPGOEnabled.getValue()).toString()), SubstrateOptionsParser.commandArgument(d.b.ProfilingEnabled, (String)"+")});
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return PGOFeature.isPGOEnabled();
    }

    public static List<Path> getProfilePaths() {
        if (!a.PGOEnabled.hasBeenSet()) {
            return null;
        }
        List<Path> list = ((AccumulatingLocatableMultiOptionValue.Paths)a.PGOEnabled.getValue()).values();
        if (list.isEmpty()) {
            list = Collections.singletonList(Path.of("default.iprof", new String[0]));
        }
        return list;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        if (PGOFeature.isPGOEnabled()) {
            SystemPropertiesSupport.singleton().setLibGraalRuntimeProperty(PGO_OPTIMIZED_QUALIFIER, "");
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        AnalysisUniverse analysisUniverse = ((FeatureImpl.AfterAnalysisAccessImpl)afterAnalysisAccess).getUniverse();
        List<AnalysisType> list = analysisUniverse.getTypes().stream().filter(b::d).toList();
        Collection<AnalysisType> collection = PGOFeature.mergeTypesWithSameName(list);
        PGOFeature.loadProfiles(analysisUniverse, collection);
    }

    public void afterCompilation(Feature.AfterCompilationAccess afterCompilationAccess) {
        ((PGOProfilesLookup)ImageSingletons.lookup(PGOProfilesLookup.class)).clear();
    }

    private static void loadProfiles(AnalysisUniverse analysisUniverse, Collection<AnalysisType> collection) {
        ProfileData.ProfileSource profileSource = ProfileData.ProfileSource.PROFILED;
        List<Path> list = PGOFeature.getProfilePaths();
        if (list == null) {
            list = new ArrayList<Path>();
        }
        if (list.isEmpty() && a.AdoptedPGOEnabled.hasBeenSet()) {
            profileSource = ProfileData.ProfileSource.ADOPTED;
            list.addAll(((AccumulatingLocatableMultiOptionValue.Paths)a.AdoptedPGOEnabled.getValue()).values());
        }
        if (list.isEmpty()) {
            return;
        }
        ArrayList<IprofContent> arrayList = new ArrayList<IprofContent>();
        for (Path object2 : list) {
            arrayList.add(IprofContent.parseFromIprof(object2, string -> UserError.abort((String)string, (Object[])new Object[0]), (Boolean)a.PGOIgnoreVersionCheck.getValue(), PGOFeature.parsePGOExcludeProfiles((String)a.PGOExcludeProfiles.getValue())));
        }
        a.b b2 = new a.b();
        PGOData.Builder builder = new PGOData.Builder(arrayList);
        PGOData pGOData = builder.setUniverseTypesAndMethods(collection, analysisUniverse.getMethods(), b2.hD(), b2.hE()).setSource(profileSource).setUnmatchedEntriesConsumer((l2, l3) -> PGOApplyProfilesPhase.a.b(l3 - l2, l3)).trackUnmatchedTypes(b2.hF()).setPrintDroppedContexts((Boolean)a.PGOPrintProfileQualityDetails.getValue()).build();
        com.oracle.svm.enterprise.hosted.pgo.profiles.a a2 = new com.oracle.svm.enterprise.hosted.pgo.profiles.a(pGOData, b2);
        ImageSingletons.add(PGOProfilesLookup.class, (Object)a2);
        PGOFeature.dumpToTempFile(pGOData);
    }

    private static List<String> parsePGOExcludeProfiles(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(",")) {
            String string3 = excludeToIprofKeyMap.get(string2);
            if (string3 == null) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private static void dumpToTempFile(ProfileDumper.DumpableData dumpableData) {
        if (!a.PGODumpLoadedIprofPath.hasBeenSet()) {
            return;
        }
        String string = (String)a.PGODumpLoadedIprofPath.getValue();
        ImageSingletons.add(Metadata.class, (Object)dumpableData.metadata());
        ProfileDumper profileDumper = ProfileDumper.create(dumpableData, Function.identity(), (Boolean)ProfileDumper.Options.ProfilesIncludeException.getValue(), d.b.iW());
        ProfileDumper.dumpToFile(profileDumper, Path.of(string, new String[0]), (Boolean)ProfilingData.Options.ProfilingDumpVerbose.getValue());
    }

    private static Collection<AnalysisType> mergeTypesWithSameName(List<AnalysisType> list) {
        Map map = list.stream().collect(Collectors.toMap(JavaType::toClassName, Function.identity(), PGOFeature::merge));
        return map.values();
    }

    private static AnalysisType merge(AnalysisType analysisType, AnalysisType analysisType2) {
        if (!analysisType.getJavaClass().getModule().isNamed()) {
            return analysisType;
        }
        GraalError.guarantee((!analysisType2.getJavaClass().getModule().isNamed() ? 1 : 0) != 0, (String)"type %s loaded by %s and %s is in an unnamed module", (Object)analysisType.toJavaName(), (Object)PGOFeature.getClassLoaderName(analysisType), (Object)PGOFeature.getClassLoaderName(analysisType2));
        return analysisType2;
    }

    private static String getClassLoaderName(AnalysisType analysisType) {
        Class clazz = analysisType.getJavaClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader == null ? null : classLoader.getName();
    }

    static {
        excludeToIprofKeyMap.put("CALL_COUNT", "callCountProfiles");
        excludeToIprofKeyMap.put("VIRTUAL_INVOKE", "virtualInvokeProfiles");
        excludeToIprofKeyMap.put("CONDITIONAL", "conditionalProfiles");
        excludeToIprofKeyMap.put("MONITOR", "monitorProfiles");
        excludeToIprofKeyMap.put("SAMPLER", "samplingProfiles");
    }

    public static class a {
        @APIOption(name={"pgo"}, defaultValue={"default.iprof"})
        @BundleMember(role=BundleMember.Role.Input)
        static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> PGOEnabled = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter(), PGOFeature::validatePGOOption){

            public void update(EconomicMap<OptionKey<?>, Object> economicMap, Object object) {
                super.update(economicMap, object);
                SubstrateOptions.Optimize.update(economicMap, (Object)String.valueOf(SubstrateOptions.OptimizationLevel.O3.getOptionSwitch()));
                aq.AOTPriorityInline.update(economicMap, (Object)true);
                GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                PriorityInliningPhase.b.wS.update(economicMap, (Object)false);
                com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining.update(economicMap, (Object)true);
                ProfileInferenceFeature.b.MLProfileInference.update(economicMap, (Object)false);
                ProfileInferenceFeature.b.MLCallCountProfileInference.update(economicMap, (Object)false);
            }
        };
        @BundleMember(role=BundleMember.Role.Input)
        static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> AdoptedPGOEnabled = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter()){

            public AccumulatingLocatableMultiOptionValue.Paths f(UnmodifiableEconomicMap<OptionKey<?>, Object> unmodifiableEconomicMap) {
                if (unmodifiableEconomicMap.containsKey((Object)this)) {
                    return (AccumulatingLocatableMultiOptionValue.Paths)unmodifiableEconomicMap.get((Object)this);
                }
                Path path = Paths.get(System.getProperty("java.home"), new String[0]);
                Path path2 = path.resolve(Paths.get("lib", "svm", "adopted_profiles", "jdk_profile.iprof"));
                if (path2.toFile().exists()) {
                    return AccumulatingLocatableMultiOptionValue.Paths.buildWithDefaults((Path[])new Path[]{path2});
                }
                return AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter();
            }

            public AccumulatingLocatableMultiOptionValue.Paths e(OptionValues optionValues) {
                return this.f(optionValues.getMap());
            }

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, AccumulatingLocatableMultiOptionValue.Paths paths, AccumulatingLocatableMultiOptionValue.Paths paths2) {
                com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining.update(economicMap, (Object)false);
                aq.AOTPriorityInline.update(economicMap, (Object)true);
                GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (AccumulatingLocatableMultiOptionValue.Paths)object, (AccumulatingLocatableMultiOptionValue.Paths)object2);
            }

            public /* synthetic */ Object getValueOrDefault(UnmodifiableEconomicMap unmodifiableEconomicMap) {
                return this.f(unmodifiableEconomicMap);
            }

            public /* synthetic */ Object getValue(OptionValues optionValues) {
                return this.e(optionValues);
            }
        };
        public static final HostedOptionKey<Boolean> PGOPrintProfileQualityDetails = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> PGOPrintProfileQuality = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> PGOIgnoreVersionCheck = new HostedOptionKey((Object)false);
        protected static final HostedOptionKey<String> PGOExcludeProfiles = new HostedOptionKey(null, PGOFeature::validatePGOExcludeProfiles);
        protected static final HostedOptionKey<Boolean> PGOTraceProfileComparison = new HostedOptionKey((Object)false, hostedOptionKey -> {
            if (hostedOptionKey.hasBeenSet() && !PGOFeature.isPGOEnabled()) {
                throw UserError.abort((String)"Can't use PGOTraceProfileComparison without PGO", (Object[])new Object[0]);
            }
        });
        public static final HostedOptionKey<String> PGODumpLoadedIprofPath = new HostedOptionKey((Object)"", hostedOptionKey -> {
            if (hostedOptionKey.hasBeenSet() && !PGOFeature.isPGOEnabled()) {
                throw UserError.abort((String)"Can not use PGODumpLoadedIprofPath without PGO", (Object[])new Object[0]);
            }
        });
    }
}

