/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.obfuscation;

import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.encoder.SymbolEncoder;
import com.oracle.svm.core.encoder.SymbolEncoderFeature;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.ExitStatus;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.obfuscation.f;
import com.oracle.svm.enterprise.hosted.obfuscation.g;
import com.oracle.svm.enterprise.hosted.obfuscation.h;
import com.oracle.svm.enterprise.hosted.obfuscation.m;
import com.oracle.svm.enterprise.hosted.obfuscation.o;
import com.oracle.svm.enterprise.hosted.obfuscation.p;
import com.oracle.svm.enterprise.hosted.sbom.r;
import com.oracle.svm.enterprise.hosted.sbom.y;
import com.oracle.svm.hosted.ApplicationModules;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ModuleLayerFeature;
import com.oracle.svm.util.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class i
extends SymbolEncoderFeature {
    private static final String wv = "Advanced obfuscation builds have two phases: phase one collects data and phase two uses that data to build the obfuscated image.";
    private static final String ww = "Successfully collected obfuscation data. Starting obfuscation phase.";
    private static final String wx = String.format("Embedded SBOM ('%s=%s') and obfuscation ('%s') are enabled. It is recommended to export the SBOM ('%s=%s') in environments where the SBOM content is confidential.", new Object[]{"--enable-sbom", y.Ez, "-H:AdvancedObfuscation=\"\"", "--enable-sbom", y.EA});
    private static final String wy = String.format("Debug build ('-g') and obfuscation ('%s') are enabled. Obfuscation will make debugging harder.", "-H:AdvancedObfuscation=\"\"");
    private static final String wz = "obfuscation-mapping.json";

    public List<Class<? extends Feature>> getRequiredFeatures() {
        if (o.gU()) {
            return List.of();
        }
        if (i.gI()) {
            return List.of(ModuleLayerFeature.class);
        }
        return List.of();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        if (o.gU()) {
            super.registerIdentityStringEncoder();
            return;
        }
        o.a(afterRegistrationAccess);
        if (i.gI()) {
            super.registerIdentityStringEncoder();
            LogUtils.info((String)wv);
            i.gK();
            h.gC();
        } else {
            f f2 = h.gB();
            com.oracle.svm.enterprise.hosted.obfuscation.a a2 = new com.oracle.svm.enterprise.hosted.obfuscation.a(f2);
            p p2 = new p(f2, a2);
            ImageSingletons.add(SymbolEncoder.class, (Object)p2);
            i.a(p2);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        if (o.gU()) {
            return;
        }
        AnalysisUniverse analysisUniverse = ((FeatureImpl.AfterAnalysisAccessImpl)afterAnalysisAccess).getUniverse();
        if (i.gI()) {
            i.d(analysisUniverse);
            throw new InterruptImageBuilding(ExitStatus.REBUILD_AFTER_ANALYSIS, ww);
        }
        if (i.gJ()) {
            p p2 = i.gM();
            p2.e(analysisUniverse);
        }
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess afterImageWriteAccess) {
        if (o.gU()) {
            return;
        }
        if (i.gJ()) {
            i.gL();
        }
    }

    private static boolean gI() {
        assert (o.gT()) : "Can only be called when obfuscation is enabled";
        return !i.gJ();
    }

    static boolean gJ() {
        assert (o.gT()) : "Can only be called when obfuscation is enabled";
        return System.getProperty("com.oracle.svm.rebuild", "false").equals("true");
    }

    private static void d(AnalysisUniverse analysisUniverse) {
        Set set = ApplicationModules.singleton().getNames();
        f f2 = g.a(analysisUniverse, set);
        h.a(f2);
    }

    private static void a(p p2) {
        ImageSingletons.add(m.class, p2::gY);
    }

    private static void gK() {
        if (r.kf()) {
            LogUtils.warning((String)wx);
        }
        if ((Integer)SubstrateOptions.GenerateDebugInfo.getValue() != 0) {
            LogUtils.warning((String)wy);
        }
    }

    private static void gL() {
        if (!o.gV()) {
            return;
        }
        String string = (String)SubstrateOptions.Name.getValue() + ".obfuscation-mapping.json";
        Path path = SubstrateOptions.getImagePath((OptionValues)HostedOptionValues.singleton()).resolve(string);
        try {
            Files.writeString(path, (CharSequence)i.gM().gX(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            throw VMError.shouldNotReachHere((String)("Could not save the obfuscation mapping file to disk. Please check your output directory. I/O exception: " + String.valueOf(iOException)));
        }
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.BUILD_INFO, path);
    }

    private static p gM() {
        assert (i.gJ()) : "The 'Obfuscator' is only available in the second phase";
        SymbolEncoder symbolEncoder = SymbolEncoder.singleton();
        assert (symbolEncoder instanceof p) : "The 'Obfuscator' must be used in the second phase";
        return (p)symbolEncoder;
    }

    public static final class a {
        public static final String wA = "-H:AdvancedObfuscation=\"\"";
        public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> AdvancedObfuscation = new HostedOptionKey((Object)AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter(), o::a);
    }
}

