/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.phases;

import com.oracle.graal.compiler.enterprise.ml.features.c;
import com.oracle.graal.compiler.enterprise.ml.features.provider.a;
import com.oracle.graal.compiler.enterprise.ml.phases.ExtractGraphMLFeaturesBasePhase;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.nodes.SubstrateMethodCallTargetNode;
import com.oracle.svm.enterprise.hosted.ml.features.VirtualInvokeFeatures;
import com.oracle.svm.enterprise.hosted.ml.features.provider.b;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.FilteredNodeIterable;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.AbstractProfiledItem;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class ExtractInvokeFeaturesPhase
extends ExtractGraphMLFeaturesBasePhase<Node, c> {
    private final DebugContext vw;

    public ExtractInvokeFeaturesPhase(a<Node, c> a2, DebugContext debugContext) {
        super(a2);
        this.vw = debugContext;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        FilteredNodeIterable filteredNodeIterable = structuredGraph.getNodes(MethodCallTargetNode.TYPE).filter(node -> ((MethodCallTargetNode)node).invokeKind().isIndirect());
        for (MethodCallTargetNode methodCallTargetNode : filteredNodeIterable) {
            this.a(methodCallTargetNode, structuredGraph);
        }
    }

    private void a(MethodCallTargetNode methodCallTargetNode, StructuredGraph structuredGraph) {
        HostedMethod hostedMethod;
        List<AnalysisMethod> list;
        GraalError.guarantee((boolean)(methodCallTargetNode instanceof SubstrateMethodCallTargetNode), (String)"Fatal Error: expecting substrate implementation.");
        JavaTypeProfile javaTypeProfile = ((SubstrateMethodCallTargetNode)methodCallTargetNode).getStaticTypeProfile();
        if (javaTypeProfile != null && !(list = ExtractInvokeFeaturesPhase.a(javaTypeProfile, hostedMethod = (HostedMethod)methodCallTargetNode.targetMethod())).contains(null)) {
            CallTargetNode.InvokeKind invokeKind = methodCallTargetNode.invokeKind();
            GraalError.guarantee((boolean)invokeKind.isIndirect(), (String)"Fatal Error: must extract virtual call features.");
            EconomicMap economicMap = ExtractGraphMLFeaturesBasePhase.a((Iterable)structuredGraph.getNodes());
            List<EconomicMap<Class<?>, Integer>> list2 = ExtractInvokeFeaturesPhase.a(list, this.vw);
            List<Double> list3 = ExtractInvokeFeaturesPhase.a(javaTypeProfile);
            GraalError.guarantee((list3.stream().distinct().count() == 1L ? 1 : 0) != 0, (String)"Fatal Error: invalid statically analysed probabilities");
            VirtualInvokeFeatures virtualInvokeFeatures = new VirtualInvokeFeatures((CallTargetNode)methodCallTargetNode, hostedMethod.getWrapped(), invokeKind, economicMap, list, list2, list3);
            this.cs.a(b.i(structuredGraph), (Object)methodCallTargetNode, (c)virtualInvokeFeatures);
        }
    }

    public static List<Double> a(JavaTypeProfile javaTypeProfile) {
        return Arrays.stream(javaTypeProfile.getTypes()).map(AbstractProfiledItem::getProbability).collect(Collectors.toList());
    }

    public static List<AnalysisMethod> a(JavaTypeProfile javaTypeProfile, HostedMethod hostedMethod) {
        List list = Arrays.stream(javaTypeProfile.getTypes()).map(profiledType -> profiledType.getType().resolveConcreteMethod((ResolvedJavaMethod)hostedMethod, null)).collect(Collectors.toList());
        ArrayList<AnalysisMethod> arrayList = new ArrayList<AnalysisMethod>();
        for (ResolvedJavaMethod resolvedJavaMethod : list) {
            AnalysisMethod analysisMethod = null;
            if (resolvedJavaMethod != null) {
                assert (resolvedJavaMethod instanceof HostedMethod);
                analysisMethod = ((HostedMethod)resolvedJavaMethod).getWrapped();
            }
            arrayList.add(analysisMethod);
        }
        return arrayList;
    }

    private static List<EconomicMap<Class<?>, Integer>> a(List<AnalysisMethod> list, DebugContext debugContext) {
        ArrayList arrayList = new ArrayList();
        for (AnalysisMethod analysisMethod : list) {
            EconomicMap economicMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            StructuredGraph structuredGraph = null;
            try {
                structuredGraph = analysisMethod.decodeAnalyzedGraph(debugContext, null);
            }
            catch (Throwable throwable) {
                debugContext.close();
            }
            if (structuredGraph != null) {
                economicMap = ExtractGraphMLFeaturesBasePhase.a((Iterable)structuredGraph.getNodes());
            }
            arrayList.add(economicMap);
        }
        return arrayList;
    }
}

