/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.logging;

import com.oracle.svm.enterprise.hosted.ml.features.provider.ProfileInferenceFeature;
import com.oracle.svm.util.LogUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;

public class a {
    private static Map<Pair<ResolvedJavaMethod, IfNode>, a> uN;

    public static void fM() {
        uN = Collections.synchronizedMap(new HashMap());
    }

    public static void fN() {
        uN.clear();
    }

    public static void a(StructuredGraph structuredGraph, IfNode ifNode, double d2, double d3, long l2) {
        ResolvedJavaMethod resolvedJavaMethod = structuredGraph.method();
        Pair pair = Pair.create((Object)resolvedJavaMethod, (Object)ifNode);
        assert (!uN.containsKey(pair));
        StructuredGraph.ScheduleResult scheduleResult = structuredGraph.getLastSchedule();
        HIRBlock hIRBlock = (HIRBlock)scheduleResult.getNodeToBlockMap().get((Node)ifNode);
        uN.put((Pair<ResolvedJavaMethod, IfNode>)pair, new a(d2, d3, l2, ifNode.getNodeSourcePosition(), hIRBlock));
    }

    public static void a(ResolvedJavaMethod resolvedJavaMethod, IfNode ifNode, double d2) {
        Pair pair = Pair.create((Object)resolvedJavaMethod, (Object)ifNode);
        if (uN.containsKey(pair)) {
            uN.get(pair).b(d2);
        }
    }

    public static void e(Path path) {
        try (FileWriter fileWriter = new FileWriter(path.toString());){
            Object object;
            fileWriter.write("Declaring Class,Method Name,Node,NodeSourcePosition,Block,Block Frequency,Profiled Probability,Predicted Probability,Guarded Probability,Global Execution Frequency,Execution Count,Absolute Error,Weighted Absolute Error" + System.lineSeparator());
            long l2 = 0L;
            for (a arrayList2 : uN.values()) {
                l2 += arrayList2.fO();
            }
            for (a a2 : uN.values()) {
                a2.i(l2);
            }
            List<Map.Entry> list = uN.entrySet().stream().sorted(Comparator.comparing(entry -> ((a)entry.getValue()).fP(), Comparator.reverseOrder())).toList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = (Map.Entry)iterator.next();
                object = (Pair)entry2.getKey();
                a a3 = (a)entry2.getValue();
                fileWriter.write(a3.a((ResolvedJavaMethod)object.getLeft(), (IfNode)object.getRight()) + System.lineSeparator());
            }
            LogUtils.info((String)("Comparison of the ML predicted and dynamically collected profiles dumped to a CSV file: " + String.valueOf(path.toAbsolutePath())));
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (int i2 = 0; i2 < Math.min(list.size(), 10); ++i2) {
                object = ((ResolvedJavaMethod)((Pair)((Map.Entry)list.get(i2)).getKey()).getLeft()).getName();
                if (arrayList.contains(object)) continue;
                arrayList.add((Pair)object);
            }
            LogUtils.info((String)String.format("To inspect the methods with the largest prediction error, please use the following method filter: --method-filter=%s.", String.join((CharSequence)",", arrayList)));
        }
        catch (IOException iOException) {
            ProfileInferenceFeature.handleMLProfileInferenceThrowable(iOException.getCause(), "Error writing to CSV file: " + iOException.getMessage(), false);
        }
    }

    private static final class a {
        private final double uO;
        private final double uP;
        private double uQ;
        private final long uR;
        private double uS;
        private double uT;
        private double uU;
        private final NodeSourcePosition uV;
        private final HIRBlock uW;

        a(double d2, double d3, long l2, NodeSourcePosition nodeSourcePosition, HIRBlock hIRBlock) {
            this.uO = d2;
            this.uP = d3;
            this.uQ = Double.NaN;
            this.uR = l2;
            this.uV = nodeSourcePosition;
            this.uW = hIRBlock;
        }

        private void b(double d2) {
            this.uQ = d2;
        }

        private void i(long l2) {
            this.uS = (double)this.uR / (double)l2;
            this.uT = Math.abs(this.uP - this.uO);
            this.uU = this.uT * this.uS;
        }

        private long fO() {
            return this.uR;
        }

        private double fP() {
            return this.uU;
        }

        private String a(ResolvedJavaMethod resolvedJavaMethod, IfNode ifNode) {
            String string = Double.isNaN(this.uQ) ? "" : String.format("%.4f", this.uQ);
            return String.format("\"%s\",\"%s\",%s,%s,%s,%.4f,%.4f,%.4f,%s,%.12f,%d,%.12f,%.12f", resolvedJavaMethod.getDeclaringClass().toJavaName(true), resolvedJavaMethod.getName(), ifNode, this.uV.getBCI(), this.uW, this.uW.getRelativeFrequency(), this.uO, this.uP, string, this.uS, this.uR, this.uT, this.uU);
        }
    }
}

