/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.features.provider;

import com.oracle.svm.enterprise.hosted.ml.features.provider.ProfileInferenceFeature;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class d
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(ProfileInferenceFeature.b.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String string) {
        switch (this.getContainer().unprefixed(string)) {
            case "ClampMLInferredProfiles": {
                return OptionDescriptor.create((String)"ClampMLInferredProfiles", (OptionType)OptionType.Expert, Boolean.class, (String)"Clamp the ML-inferred profiles.", (Object)this.getContainer(), ProfileInferenceFeature.b.ClampMLInferredProfiles, (String)"ClampMLInferredProfiles", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GuardMaxCondExitProbability": {
                return OptionDescriptor.create((String)"GuardMaxCondExitProbability", (OptionType)OptionType.Expert, Double.class, (String)"Maximum execution probability of a branch that contains the ControlSinkNode.", (Object)this.getContainer(), ProfileInferenceFeature.b.GuardMaxCondExitProbability, (String)"GuardMaxCondExitProbability", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GuardMinCondEstimatedAssembly": {
                return OptionDescriptor.create((String)"GuardMinCondEstimatedAssembly", (OptionType)OptionType.Expert, Double.class, (String)"Minimum estimated assembly size of a branch that triggers the exit guard.", (Object)this.getContainer(), ProfileInferenceFeature.b.GuardMinCondEstimatedAssembly, (String)"GuardMinCondEstimatedAssembly", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GuardMinLoopProbability": {
                return OptionDescriptor.create((String)"GuardMinLoopProbability", (OptionType)OptionType.Expert, Double.class, (String)"Minimum loop body execution probability.", (Object)this.getContainer(), ProfileInferenceFeature.b.GuardMinLoopProbability, (String)"GuardMinLoopProbability", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LogMLInference": {
                return OptionDescriptor.create((String)"LogMLInference", (OptionType)OptionType.Debug, String.class, (String)"Log profiles predicted by the ML model, profiles tuned with the profile inference guards, and profiles collected via instrumentation profiling.\nThe value should point to an ML inference log file.\n\nThe `LogMLInference` flag introduces the ML Debug Tool mode that enables debugging of the ML profile inference in\nthe Graal compiler.\n\n# Usage\n\n1) Position to the `graal-enterprise/substratevm-enterprise/` directory.\n\n2) Code program you want to inspect, for example, `SortExample.java`:\n\n    import java.util.Arrays;\n    import java.util.Random;\n\n    public class SortExample {\n\n        public static void main(String args[]) {\n            int n = 30_000_000;\n            int[] data = generateRandomArray(n, 0L);\n            long startTime = System.nanoTime();\n            heapSort(data, 0, data.length);\n            long stopTime = System.nanoTime();\n            long delta = (stopTime - startTime) / 1_000_000;\n            System.out.println(\"Array of \" + n + \" elements sorted in: \" + delta + \" miliseconds.\");\n        }\n\n        private static void heapSort(int[] a, int low, int high) {\n            for (int k = (low + high) >>> 1; k > low; ) {\n                pushDown(a, --k, a[k], low, high);\n            }\n            while (--high > low) {\n                int max = a[low];\n                pushDown(a, low, a[high], low, high);\n                a[high] = max;\n            }\n        }\n\n        private static void pushDown(int[] a, int p, int value, int low, int high) {\n            for (int k ;; a[p] = a[p = k]) {\n                k = (p << 1) - low + 2; // Index of the right child\n                if (k > high) {\n                    break;\n                }\n                if (k == high || a[k] < a[k - 1]) {\n                    --k;\n                }\n                if (a[k] <= value) {\n                    break;\n                }\n            }\n            a[p] = value;\n        }\n\n        public static int[] generateRandomArray(int n, long seed) {\n            Random random = new Random(seed);\n            int[] arr = new int[n];\n            for (int i = 0; i < n; i++) {\n                arr[i] = random.nextInt();\n            }\n            return arr;\n        }\n    }\n\n3) Run the `mx ml debug` command:\n\n   mx ml debug --input-file SortExample.java\n\nThe tool compiles the input program, runs the ML inference to predict branch profiles and apply the profile inference\nheuristics to tune the predicted profiles. Also, the tool performs the instrumented-image build and profile-collection\nrun to collect branch profiles. The tool generates a .csv report in which you can find details about the particular\nprediction. For each `If` node the tool reports its declaring class, name of the method in which the node is located,\nnode, node source position, block, block frequency, profiled execution probability of the true branch of the node,\npredicted execution probability of the true branch of the node, execution probability tuned by the profile inference\nheuristics (guards), global execution frequency of the node, execution count of the node, absolute error and the\nweighted absolute error (absolute error multiplied by the global execution frequency of a node) of the ML prediction.\nNodes are sorted in decreasing order according to the weighted absolute error.\n\n4) If you want to plot the graphs of the specific methods, please use the argument `--method-filter`.\n   For example, to plot the graphs of the `heapSort` and `pushDown` methods from the previous example, run:\n\n   mx ml debug --input-file SortExample.java --method-filter=heapSort,pushDown\n\nThis way, besides profile logging, the tool runs the Ideal Graph Visualizer (IGV) in the background and draw the graphs\nof the methods matching the regex filter.\n\n# Benchmarks\n\nTo debug the ML predictions in the native image benchmarks we introduce the `profile-inference-debug-ee` JVM config\nthat enables benchmarks to run in the debug mode. For example, to log profiles in the `scala-kmeans` benchmark, run:\n\n    mx --java-home $JAVA_HOME --env ni-ee benchmark --ignore-suite-commit-info nativeimage-benchmarks\n    renaissance-native-image:scala-kmeans -- --jvm=native-image --jvm-config=profile-inference-debug-ee\n\n# Logging the ML predictions without the `mx` tool\n\nTo log the ML predictions when using the native-image command please provide the collected profiles, enable the ML\nfeature extraction and ML profile inference in the command line, and provide the log file for the profile comparison.\nFor example, to debug the `HeapSort` example, please run:\n\n    native-image --pgo=default.iprof HeapSort -H:+MLGraphFeaturesExtraction -H:+MLProfileInference\n    -H:LogMLInference=ml-inference-log.sortexample.csv\n\nTo debug the specific functions (e.g., `findClosest`) in the IGV, run:\n\n    mx --java-home $JAVA_HOME --env ni-ee benchmark --ignore-suite-commit-info nativeimage-benchmarks renaissance-native-image:scala-kmeans --\n    --jvm=native-image --jvm-config=profile-inference-debug-ee -Dnative-image.benchmark.extra-image-build-argument=-H:Dump=:2\n    -Dnative-image.benchmark.extra-image-build-argument=-H:PrintGraph=Network -Dnative-image.benchmark.extra-image-build-argument=-H:MethodFilter=findClosest", (Object)this.getContainer(), ProfileInferenceFeature.b.LogMLInference, (String)"LogMLInference", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MLCallCountProfileInference": {
                return OptionDescriptor.create((String)"MLCallCountProfileInference", (OptionType)OptionType.User, Boolean.class, (String)"Employ a static profiler to infer call count profiles of methods in the call graph.", (Object)this.getContainer(), ProfileInferenceFeature.b.MLCallCountProfileInference, (String)"MLCallCountProfileInference", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MLExtractCallGraphFeatures": {
                return OptionDescriptor.create((String)"MLExtractCallGraphFeatures", (OptionType)OptionType.User, Boolean.class, (String)"Extract features that characterize call graph and IR graphs of methods.", (Object)this.getContainer(), ProfileInferenceFeature.b.MLExtractCallGraphFeatures, (String)"MLExtractCallGraphFeatures", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MLGraphFeaturesExtraction": {
                return OptionDescriptor.create((String)"MLGraphFeaturesExtraction", (OptionType)OptionType.Expert, Boolean.class, (String)"Extract graph ML features to support the profile inference in the GraalVM Native Image.", (Object)this.getContainer(), ProfileInferenceFeature.b.MLGraphFeaturesExtraction, (String)"MLGraphFeaturesExtraction", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MLProfileInference": {
                return OptionDescriptor.create((String)"MLProfileInference", (OptionType)OptionType.User, Boolean.class, (String)"Employ static profiler to infer profiles in the GraalVM Native Image.", (Object)this.getContainer(), ProfileInferenceFeature.b.MLProfileInference, (String)"MLProfileInference", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MLProfileInferenceGuards": {
                return OptionDescriptor.create((String)"MLProfileInferenceGuards", (OptionType)OptionType.Expert, Boolean.class, (String)"Employ guards to tune the ML-inferred profiles.", (Object)this.getContainer(), ProfileInferenceFeature.b.MLProfileInferenceGuards, (String)"MLProfileInferenceGuards", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MLProfileInferenceUseGNNModel": {
                return OptionDescriptor.create((String)"MLProfileInferenceUseGNNModel", (OptionType)OptionType.User, Boolean.class, (String)"Employ GNN ML model to infer profiles in the GraalVM Native Image.", (Object)this.getContainer(), ProfileInferenceFeature.b.MLProfileInferenceUseGNNModel, (String)"MLProfileInferenceUseGNNModel", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyMLModelInference": {
                return OptionDescriptor.create((String)"VerifyMLModelInference", (OptionType)OptionType.Expert, Boolean.class, (String)"Verify the deployed ML model's inference using a set of predefined samples.", (Object)this.getContainer(), ProfileInferenceFeature.b.VerifyMLModelInference, (String)"VerifyMLModelInference", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 12;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return d.this.get("ClampMLInferredProfiles");
                    }
                    case 1: {
                        return d.this.get("GuardMaxCondExitProbability");
                    }
                    case 2: {
                        return d.this.get("GuardMinCondEstimatedAssembly");
                    }
                    case 3: {
                        return d.this.get("GuardMinLoopProbability");
                    }
                    case 4: {
                        return d.this.get("LogMLInference");
                    }
                    case 5: {
                        return d.this.get("MLCallCountProfileInference");
                    }
                    case 6: {
                        return d.this.get("MLExtractCallGraphFeatures");
                    }
                    case 7: {
                        return d.this.get("MLGraphFeaturesExtraction");
                    }
                    case 8: {
                        return d.this.get("MLProfileInference");
                    }
                    case 9: {
                        return d.this.get("MLProfileInferenceGuards");
                    }
                    case 10: {
                        return d.this.get("MLProfileInferenceUseGNNModel");
                    }
                    case 11: {
                        return d.this.get("VerifyMLModelInference");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

