/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.features.provider;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.BuildDirectoryProvider;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.ml.features.AnalysisMethodFeatures;
import com.oracle.svm.enterprise.hosted.ml.features.provider.c;
import com.oracle.svm.enterprise.hosted.ml.inferencer.Inferencer;
import com.oracle.svm.enterprise.hosted.ml.models.d;
import com.oracle.svm.enterprise.hosted.ml.models.e;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.module.Configuration;
import java.lang.module.FindException;
import java.lang.module.ModuleFinder;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.util.json.JsonParserException;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class ProfileInferenceFeature
implements InternalFeature {
    private Field logManagerField;
    private Field propsField;
    private Properties analysisLogProps;
    private static final boolean isLoggingModulePresent;

    private static void validateMLInference(HostedOptionKey<Boolean> hostedOptionKey) {
        if (hostedOptionKey.hasBeenSet() && ((Boolean)hostedOptionKey.getValue()).booleanValue()) {
            UserError.guarantee((boolean)ProfileInferenceFeature.isONNXSupportedPlatform(), (String)"The '%s' flag requires a platform that supports ONNX inference.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)"+")});
        }
    }

    private static void validateMLFeatureExtraction(HostedOptionKey<Boolean> hostedOptionKey) {
        if (!((Boolean)hostedOptionKey.getValue()).booleanValue()) {
            return;
        }
        UserError.guarantee((!com.oracle.svm.enterprise.hosted.profilingframework.d.is() && (ProfileInferenceFeature.shouldRunMLProfileInference() || PGOFeature.isPGOEnabled()) ? 1 : 0) != 0, (String)"The '%s' flag requires profiling to be disabled and ML inference or PGO to be enabled.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)"+")});
    }

    private static void validateMLCallCountProfileInference(HostedOptionKey<Boolean> hostedOptionKey) {
        if (((Boolean)hostedOptionKey.getValue()).booleanValue()) {
            UserError.guarantee((boolean)((Boolean)com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining.getValue()), (String)"The '%s' flag requires '%s' to be enabled.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)"+"), SubstrateOptionsParser.commandArgument(com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining, (String)"+")});
            UserError.guarantee((!PGOFeature.isPGOEnabled() ? 1 : 0) != 0, (String)"The '%s' flag requires PGO to be disabled. If dynamic profiles are available, predicting profiles is sufficient.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)"+")});
        }
    }

    public static boolean isONNXSupportedPlatform() {
        return Stream.of(Platform.LINUX_AMD64.class, Platform.LINUX_AARCH64.class, Platform.WINDOWS_AMD64.class).anyMatch(Platform::includedIn) || Stream.of(Platform.DARWIN_AMD64.class, Platform.DARWIN_AARCH64.class).anyMatch(Platform::includedIn) && ProfileInferenceFeature.checkOsVersion("macOS", 10, 15);
    }

    private static boolean checkOsVersion(String string, int n2, int n3) {
        String string2 = System.getProperty("os.name");
        String string3 = System.getProperty("os.version");
        String[] stringArray = string3.split("\\.");
        int n4 = Integer.parseInt(stringArray[0]);
        int n5 = Integer.parseInt(stringArray[1]);
        return string2.replaceAll("\\s", "").toLowerCase(Locale.ROOT).contains(string.toLowerCase(Locale.ROOT)) && (n4 > n2 || n4 == n2 && n5 >= n3);
    }

    private static boolean isMLProfileInferenceEnabled() {
        if (b.MLProfileInference.hasBeenSet()) {
            return (Boolean)b.MLProfileInference.getValue();
        }
        return SubstrateOptions.optimizationLevel().isOneOf(new SubstrateOptions.OptimizationLevel[]{SubstrateOptions.OptimizationLevel.O2, SubstrateOptions.OptimizationLevel.O3});
    }

    private static boolean isCallCountInferenceEnabled() {
        return (Boolean)b.MLCallCountProfileInference.getValue();
    }

    public static boolean shouldRunMLGraphFeaturesExtraction() {
        return ((Boolean)b.MLGraphFeaturesExtraction.getValue() != false || ProfileInferenceFeature.isMLProfileInferenceEnabled()) && ProfileInferenceFeature.isONNXSupportedPlatform();
    }

    public static boolean shouldRunMLCallGraphFeatureExtraction() {
        return ((Boolean)b.MLExtractCallGraphFeatures.getValue() != false || ProfileInferenceFeature.isCallCountInferenceEnabled()) && ProfileInferenceFeature.isONNXSupportedPlatform();
    }

    public static boolean shouldLabelMLCallGraphFeatures() {
        return (Boolean)b.MLExtractCallGraphFeatures.getValue() != false && ProfileInferenceFeature.isONNXSupportedPlatform();
    }

    public static void maybeLabelMethodAsHot(HostedMethod hostedMethod) {
        if (ProfileInferenceFeature.shouldLabelMLCallGraphFeatures()) {
            c c2 = c.fK();
            if (c2 == null) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(new NullPointerException("Missing call count label provider."), "Cannot label the method: " + com.oracle.svm.enterprise.hosted.ml.features.provider.b.d((ResolvedJavaMethod)hostedMethod), true);
                return;
            }
            c2.e(hostedMethod.getWrapped());
        }
    }

    public static void maybeLabelMethodAsRegular(HostedMethod hostedMethod) {
        if (ProfileInferenceFeature.shouldLabelMLCallGraphFeatures()) {
            c c2 = c.fK();
            if (c2 == null) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(new NullPointerException("Missing call count label provider."), "Cannot label the method: " + com.oracle.svm.enterprise.hosted.ml.features.provider.b.d((ResolvedJavaMethod)hostedMethod), true);
                return;
            }
            c2.d(hostedMethod.getWrapped());
        }
    }

    public static void maybeLabelMethodAsCold(HostedMethod hostedMethod) {
        if (ProfileInferenceFeature.shouldLabelMLCallGraphFeatures()) {
            c c2 = c.fK();
            if (c2 == null) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(new NullPointerException("Missing call count label provider."), "Cannot label the method: " + com.oracle.svm.enterprise.hosted.ml.features.provider.b.d((ResolvedJavaMethod)hostedMethod), true);
                return;
            }
            c2.c(hostedMethod.getWrapped());
        }
    }

    public static boolean shouldUseGNNMLModel() {
        if (b.MLProfileInferenceUseGNNModel.hasBeenSet()) {
            return (Boolean)b.MLProfileInferenceUseGNNModel.getValue();
        }
        return SubstrateOptions.optimizationLevel().equals((Object)SubstrateOptions.OptimizationLevel.O3);
    }

    public static String getGNNModelKind() {
        return SubstrateOptions.optimizationLevel().equals((Object)SubstrateOptions.OptimizationLevel.O3) ? "gnn-O3" : "gnn-O2";
    }

    public static String getXGBoostModelKind() {
        return "xgboost";
    }

    public static boolean shouldLabelMLGraphFeatures() {
        return (Boolean)b.MLGraphFeaturesExtraction.getValue() != false && ProfileInferenceFeature.isONNXSupportedPlatform();
    }

    public static boolean shouldRunMLProfileInference() {
        return ProfileInferenceFeature.isMLProfileInferenceEnabled() && ProfileInferenceFeature.isONNXSupportedPlatform();
    }

    public static boolean shouldRunCallCountProfileInference() {
        return ProfileInferenceFeature.isCallCountInferenceEnabled() && ProfileInferenceFeature.isONNXSupportedPlatform();
    }

    public static boolean shouldLogMLProfileInference() {
        return ProfileInferenceFeature.shouldRunMLProfileInference() && b.LogMLInference.getValue() != null;
    }

    public static boolean loadedMLProfileInferenceModel() {
        return ImageSingletons.contains(com.oracle.svm.enterprise.hosted.ml.models.a.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        if (ProfileInferenceFeature.shouldRunMLProfileInference() && !isLoggingModulePresent) {
            throw UserError.abort((String)("Machine-learning-based profile inference is enabled but the required java.logging module is unavailable. ML profile inference can be disabled with " + SubstrateOptionsParser.commandArgument(b.MLProfileInference, (String)"-") + " or by using " + SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.Optimize, (String)"1")), (Object[])new Object[0]);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        Class clazz;
        if (ProfileInferenceFeature.shouldRunMLProfileInference()) {
            try {
                clazz = ReflectionUtil.lookupClass((boolean)false, (String)"java.util.logging.LogManager");
                this.logManagerField = ReflectionUtil.lookupField((Class)clazz, (String)"manager");
                this.propsField = ReflectionUtil.lookupField((Class)clazz, (String)"props");
                this.analysisLogProps = (Properties)this.propsField.get(this.logManagerField.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw VMError.shouldNotReachHere((String)"Cannot access the java log manager.");
            }
        }
        if (ProfileInferenceFeature.shouldRunMLGraphFeaturesExtraction() || ProfileInferenceFeature.shouldRunMLCallGraphFeatureExtraction()) {
            ImageSingletons.add(com.oracle.svm.enterprise.hosted.ml.features.provider.a.class, (Object)new com.oracle.svm.enterprise.hosted.ml.features.provider.a(ProfileInferenceFeature.shouldRunMLGraphFeaturesExtraction(), ProfileInferenceFeature.shouldRunMLCallGraphFeatureExtraction()));
        }
        clazz = (FeatureImpl.AfterAnalysisAccessImpl)afterAnalysisAccess;
        if (ProfileInferenceFeature.shouldRunMLCallGraphFeatureExtraction()) {
            try {
                BigBang bigBang = clazz.getBigBang();
                if (!(bigBang instanceof PointsToAnalysis)) {
                    throw new IllegalStateException("Dumping call graph features only makes sense when the points-to analysis is enabled.");
                }
                PointsToAnalysis pointsToAnalysis = (PointsToAnalysis)bigBang;
                com.oracle.svm.enterprise.hosted.ml.phases.c.a(pointsToAnalysis.getUniverse());
            }
            catch (IllegalStateException | NullPointerException runtimeException) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(runtimeException, "Call Count Feature Extraction Exception", true);
            }
        }
        if (ProfileInferenceFeature.shouldRunCallCountProfileInference()) {
            try {
                ProfileInferenceFeature.inferCallCountProfiles(clazz.getUniverse().getBigbang().getDebug());
            }
            catch (Exception exception) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(exception, "Invalid Call Count Profile Inference", true);
            }
        }
    }

    private static void inferCallCountProfiles(DebugContext debugContext) throws Inferencer.InferenceException, IOException {
        Inferencer inferencer = ProfileInferenceFeature.createONNXInferencerInstance();
        d d2 = d.c(ProfileInferenceFeature.resolveCalLCountModelPath(), inferencer);
        com.oracle.svm.enterprise.hosted.ml.features.provider.a a2 = (com.oracle.svm.enterprise.hosted.ml.features.provider.a)ImageSingletons.lookup(com.oracle.svm.enterprise.hosted.ml.features.provider.a.class);
        com.oracle.graal.compiler.enterprise.ml.features.provider.d<AnalysisMethod, AnalysisMethodFeatures> d3 = a2.fG();
        Map<AnalysisMethod, Long> map = d2.a(d3, debugContext);
        com.oracle.svm.enterprise.hosted.pgo.profiles.b b2 = new com.oracle.svm.enterprise.hosted.pgo.profiles.b(map);
        ImageSingletons.add(PGOProfilesLookup.class, (Object)b2);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        if (ProfileInferenceFeature.shouldLabelMLCallGraphFeatures()) {
            ImageSingletons.add(c.class, (Object)new c());
        }
        if (ProfileInferenceFeature.shouldRunMLProfileInference()) {
            try {
                Inferencer inferencer = ProfileInferenceFeature.createONNXInferencerInstance();
                com.oracle.svm.enterprise.hosted.ml.models.a a2 = ProfileInferenceFeature.shouldUseGNNMLModel() ? com.oracle.svm.enterprise.hosted.ml.models.b.b(ProfileInferenceFeature.resolveModelPath(ProfileInferenceFeature.getGNNModelKind()), inferencer) : e.d(ProfileInferenceFeature.resolveModelPath(ProfileInferenceFeature.getXGBoostModelKind()), inferencer);
                ImageSingletons.add(com.oracle.svm.enterprise.hosted.ml.models.a.class, (Object)((Object)a2));
            }
            catch (FileNotFoundException fileNotFoundException) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(fileNotFoundException, "Invalid Configuration File", true);
            }
            catch (IOException iOException) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(iOException, "Invalid Inference Configuration File IO", true);
            }
            catch (JsonParserException jsonParserException) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(jsonParserException, "Invalid JSON Configuration", true);
            }
            catch (Inferencer.InferenceException inferenceException) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(inferenceException, "Invalid Inference", true);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(unsatisfiedLinkError, "Missing Inference Library", true);
            }
            catch (Exception exception) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(exception, "General Inference Exception", true);
            }
            try {
                this.propsField.set(this.logManagerField.get(null), this.analysisLogProps);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw VMError.shouldNotReachHere((String)"Cannot access the java log manager.");
            }
        }
        if (ProfileInferenceFeature.shouldLogMLProfileInference()) {
            com.oracle.svm.enterprise.hosted.ml.logging.a.fM();
        }
    }

    public void afterCompilation(Feature.AfterCompilationAccess afterCompilationAccess) {
        try {
            if (ProfileInferenceFeature.loadedMLProfileInferenceModel()) {
                ((com.oracle.svm.enterprise.hosted.ml.models.a)((Object)ImageSingletons.lookup(com.oracle.svm.enterprise.hosted.ml.models.a.class))).p();
            }
            if (ProfileInferenceFeature.shouldRunMLCallGraphFeatureExtraction()) {
                ((com.oracle.svm.enterprise.hosted.ml.features.provider.a)ImageSingletons.lookup(com.oracle.svm.enterprise.hosted.ml.features.provider.a.class)).fI();
            }
            if (ProfileInferenceFeature.shouldLabelMLCallGraphFeatures()) {
                ((c)ImageSingletons.lookup(c.class)).clear();
            }
        }
        catch (Exception exception) {
            ProfileInferenceFeature.handleMLProfileInferenceThrowable(exception, "Cannot clean ML profile inference resources.", true);
        }
        if (ProfileInferenceFeature.shouldLogMLProfileInference()) {
            com.oracle.svm.enterprise.hosted.ml.logging.a.e(Paths.get((String)b.LogMLInference.getValue(), new String[0]).toAbsolutePath());
            com.oracle.svm.enterprise.hosted.ml.logging.a.fN();
        }
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess afterHeapLayoutAccess) {
        try {
            if (ProfileInferenceFeature.shouldRunMLGraphFeaturesExtraction()) {
                ((com.oracle.svm.enterprise.hosted.ml.features.provider.a)ImageSingletons.lookup(com.oracle.svm.enterprise.hosted.ml.features.provider.a.class)).fJ();
            }
        }
        catch (Exception exception) {
            ProfileInferenceFeature.handleMLProfileInferenceThrowable(exception, "Cannot clean ML profile inference resources.", true);
        }
    }

    public static Inferencer createONNXInferencerInstance() throws Inferencer.InferenceException {
        try {
            return (Inferencer)a.uL.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | NullPointerException | InvocationTargetException exception) {
            throw new Inferencer.InferenceException("Cannot instantiate inference engine for profile inference.", exception);
        }
    }

    public static void handleMLProfileInferenceThrowable(Throwable throwable, String string, boolean bl2) {
        String string2 = "ML Profile Inference - " + string + ": " + String.valueOf(throwable);
        if (Assertions.assertionsEnabled()) {
            throw VMError.shouldNotReachHere((String)string2);
        }
        if (bl2) {
            LogUtils.warning((String)string2);
        }
    }

    public static Path resolveModelPath(String string) {
        return BuildDirectoryProvider.singleton().getHome().resolve("lib").resolve("svm").resolve("profile_inference").resolve("model").resolve(string);
    }

    public static Path resolveCalLCountModelPath() {
        return BuildDirectoryProvider.singleton().getHome().resolve("lib").resolve("svm").resolve("profile_inference").resolve("call_count").resolve("model");
    }

    static {
        Optional<Module> optional = ModuleLayer.boot().findModule("java.logging");
        if (optional.isPresent()) {
            ProfileInferenceFeature.class.getModule().addReads(optional.get());
        }
        isLoggingModulePresent = optional.isPresent();
    }

    public static class b {
        public static final HostedOptionKey<Boolean> MLProfileInference = new HostedOptionKey((Object)true, ProfileInferenceFeature::validateMLInference);
        public static final HostedOptionKey<Boolean> MLProfileInferenceUseGNNModel = new HostedOptionKey((Object)false, ProfileInferenceFeature::validateMLInference);
        public static final HostedOptionKey<Boolean> MLGraphFeaturesExtraction = new HostedOptionKey<Boolean>(Boolean.valueOf(false), ProfileInferenceFeature::validateMLFeatureExtraction){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                super.onValueUpdate(economicMap, (Object)bl2, (Object)bl3);
                if (bl3.booleanValue()) {
                    GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                    MLProfileInference.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        public static final HostedOptionKey<Boolean> MLCallCountProfileInference = new HostedOptionKey<Boolean>(Boolean.valueOf(false), ProfileInferenceFeature::validateMLCallCountProfileInference){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                super.onValueUpdate(economicMap, (Object)bl2, (Object)bl3);
                if (bl3.booleanValue()) {
                    com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining.update(economicMap, (Object)true);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        public static final HostedOptionKey<Boolean> MLExtractCallGraphFeatures = new HostedOptionKey<Boolean>(Boolean.valueOf(false), ProfileInferenceFeature::validateMLFeatureExtraction){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                super.onValueUpdate(economicMap, (Object)bl2, (Object)bl3);
                if (bl3.booleanValue()) {
                    GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                    MLProfileInference.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        public static final HostedOptionKey<Boolean> ClampMLInferredProfiles = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Boolean> MLProfileInferenceGuards = new HostedOptionKey((Object)true);
        public static final HostedOptionKey<Double> GuardMinLoopProbability = new HostedOptionKey((Object)0.2);
        public static final HostedOptionKey<Double> GuardMaxCondExitProbability = new HostedOptionKey((Object)0.8);
        public static final HostedOptionKey<Double> GuardMinCondEstimatedAssembly = new HostedOptionKey((Object)50.0);
        public static final HostedOptionKey<Boolean> VerifyMLModelInference = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                super.onValueUpdate(economicMap, (Object)bl2, (Object)bl3);
                if (bl3.booleanValue()) {
                    MLCallCountProfileInference.update(economicMap, (Object)true);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        public static final HostedOptionKey<String> LogMLInference = new HostedOptionKey<String>(null){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, String string, String string2) {
                super.onValueUpdate(economicMap, (Object)string, (Object)string2);
                if (string2 != null) {
                    LogUtils.warning((String)"Building the image in ML logging mode involves collecting ML-inferred and dynamically gathered profiles, allowing the ML model to overwrite dynamically collected profiles. This is the debug flag only and it should not be used in production.");
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (String)object, (String)object2);
            }
        };
    }

    static class a {
        static Class<?> uL = a.fL();

        a() {
        }

        private static Class<?> fL() {
            Path path = BuildDirectoryProvider.singleton().getHome().resolve("lib").resolve("svm").resolve("profile_inference").resolve("onnx");
            Path path2 = path.resolve("native");
            System.setProperty("onnxruntime.native.path", String.valueOf(path2));
            String string = "com.oracle.svm.svm_enterprise_onnx_runtime";
            Path path3 = path.resolve("jar").resolve("svm-enterprise-onnx-runtime.jar");
            try {
                ClassLoader classLoader;
                if (ModuleSupport.modulePathBuild) {
                    ModuleFinder moduleFinder = ModuleFinder.of(path3);
                    Configuration configuration = ModuleLayer.boot().configuration().resolve(moduleFinder, ModuleFinder.of(new Path[0]), Collections.singleton(string));
                    ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(configuration, List.of(ModuleLayer.boot()), Inferencer.class.getClassLoader());
                    ModuleLayer moduleLayer = controller.layer();
                    Module module = moduleLayer.findModule(string).orElseThrow();
                    Method method = ReflectionUtil.lookupMethod(ModuleLayer.Controller.class, (String)"enableNativeAccess", (Class[])new Class[]{Module.class});
                    method.invoke((Object)controller, module);
                    classLoader = module.getClassLoader();
                    ModuleSupport.accessModule((ModuleSupport.Access)ModuleSupport.Access.EXPORT, (Module)module, (Module)ProfileInferenceFeature.class.getModule(), (String)"com.oracle.svm.enterprise.hosted.ml.inferencer");
                } else {
                    classLoader = new URLClassLoader(new URL[]{path3.toUri().toURL()});
                }
                return ReflectionUtil.lookupClass((boolean)false, (String)"com.oracle.svm.enterprise.hosted.onnx.ONNXInferencer", (ClassLoader)classLoader);
            }
            catch (ReflectiveOperationException | FindException | MalformedURLException | NoSuchElementException exception) {
                ProfileInferenceFeature.handleMLProfileInferenceThrowable(exception, "Cannot load module" + string + " from: " + String.valueOf(path3), false);
                return null;
            }
        }
    }
}

