/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.features;

import com.oracle.graal.compiler.enterprise.ml.features.b;
import com.oracle.graal.compiler.enterprise.ml.features.serialization.a;
import com.oracle.svm.enterprise.hosted.ml.features.c;
import com.oracle.svm.enterprise.hosted.ml.features.e;
import com.oracle.svm.enterprise.hosted.ml.features.f;
import com.oracle.svm.enterprise.hosted.ml.features.h;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.AnnotationAccess;

public class PathFeatures
extends com.oracle.graal.compiler.enterprise.ml.features.c {
    private final List<HIRBlock> path;
    @b(m=1)
    private final c header;
    @b(m=2)
    private final h maxCSDepth;
    @b(m=3)
    private final h loopDepth;
    @b(m=4)
    private final h maxLoopDepth;
    @b(m=5)
    private final h blocks;
    @b(m=6)
    private final h estimatedAssemblySize;
    @b(m=7)
    private final h estimatedCPUCycles;
    @b(m=8)
    private final h estimatedCPUCheap;
    @b(m=9)
    private final h estimatedCPUExpensive;
    @b(m=10)
    private final f invokes;
    @b(m=11)
    private final e branchHistogram;
    private static final List<Field> orderedFeatures = PathFeatures.a(PathFeatures.class);
    private static final List<Field> orderedEncoderFeatures = PathFeatures.b(PathFeatures.class, List.of(c.class, e.class));

    public static List<Field> getEncoderFeatureFields(Class<? extends com.oracle.graal.compiler.enterprise.ml.features.c> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> AnnotationAccess.isAnnotationPresent((AnnotatedElement)field, b.class)).filter(field -> c.class.isAssignableFrom(field.getType()) || e.class.isAssignableFrom(field.getType())).collect(Collectors.toList());
    }

    public PathFeatures(List<HIRBlock> list, Class<? extends Node> clazz, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, List<ResolvedJavaMethod> list2, EconomicMap<Class<?>, Integer> economicMap) {
        this.path = list;
        this.header = new c(clazz);
        this.maxCSDepth = new h(n2);
        this.loopDepth = new h(n3);
        this.maxLoopDepth = new h(n4);
        this.blocks = new h(n5);
        this.estimatedAssemblySize = new h(n6);
        this.estimatedCPUCycles = new h(n7);
        this.estimatedCPUCheap = new h(n8);
        this.estimatedCPUExpensive = new h(n9);
        this.invokes = new f(list2);
        this.branchHistogram = new e(economicMap);
    }

    public boolean n() {
        return false;
    }

    public List<Float> a(EconomicMap<String, List<String>> economicMap) {
        return super.a(orderedFeatures, economicMap);
    }

    public void a(a a2) {
        this.a(PathFeatures.class, a2);
    }

    protected List<Field> o() {
        return PathFeatures.a(PathFeatures.class, List.of("orderedFeatures", "orderedEncoderFeatures"));
    }

    public Class<? extends Node> getHeader() {
        return (Class)this.header.l();
    }

    public int getMaxCSDepth() {
        return (Integer)this.maxCSDepth.l();
    }

    public int getLoopDepth() {
        return (Integer)this.loopDepth.l();
    }

    public int getMaxLoopDepth() {
        return (Integer)this.maxLoopDepth.l();
    }

    public int getBlocks() {
        return (Integer)this.blocks.l();
    }

    public int getEstimatedAssemblySize() {
        return (Integer)this.estimatedAssemblySize.l();
    }

    public int getEstimatedCPUCycles() {
        return (Integer)this.estimatedCPUCycles.l();
    }

    public int getEstimatedCPUCheap() {
        return (Integer)this.estimatedCPUCheap.l();
    }

    public int getEstimatedCPUExpensive() {
        return (Integer)this.estimatedCPUExpensive.l();
    }

    public List<ResolvedJavaMethod> getInvokes() {
        return (List)this.invokes.l();
    }

    public EconomicMap<Class<?>, Integer> getBranchHistogram() {
        return (EconomicMap)this.branchHistogram.l();
    }
}

