/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.features;

import com.oracle.graal.compiler.enterprise.ml.features.serialization.a;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.ml.features.PathFeatures;
import com.oracle.svm.enterprise.hosted.ml.features.b;
import com.oracle.svm.enterprise.hosted.ml.features.c;
import com.oracle.svm.enterprise.hosted.ml.features.e;
import com.oracle.svm.enterprise.hosted.ml.features.h;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class ControlSplitFeatures
extends com.oracle.graal.compiler.enterprise.ml.features.c
implements b {
    private final ResolvedJavaMethod originMethod;
    private final ControlSplitNode node;
    private final ControlSplitNode parent;
    private final HIRBlock block;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=1)
    private final c csType;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=2)
    private final c csConditionType;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=3)
    private final h csDepth;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=4)
    private final h loopDepth;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=5)
    private final h dominatorDepth;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=6)
    private h blockEstimatedAssemblySize;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=7)
    private h blockEstimatedCPUCycles;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=8)
    private h blockEstimatedCPUCheap;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=9)
    private h blockEstimatedCPUExpensive;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=10)
    private final e blockDataFlowHistogram;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=11)
    private final h predecessorsCount;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=12)
    private final e predecessorsDataFlowHistogram;
    private final EconomicMap<AbstractBeginNode, PathFeatures> branches;
    private final List<Integer> branchesOrder;
    private EconomicMap<Integer, Double> label;
    private EconomicMap<Integer, Long> labelCount;
    private static final List<Field> orderedFeatures = ControlSplitFeatures.a(ControlSplitFeatures.class);
    private static final List<Field> orderedEncoderFeatures = ControlSplitFeatures.b(ControlSplitFeatures.class, List.of(c.class, e.class));
    private static final String featureName = ControlSplitFeatures.class.getSimpleName();
    private static final String subfeatureName = "branches";
    private static final String subfeatureOrder = "branchesOrder";

    public ControlSplitFeatures(ResolvedJavaMethod resolvedJavaMethod, ControlSplitNode controlSplitNode, ControlSplitNode controlSplitNode2, Class<? extends ControlSplitNode> clazz, Class<? extends LogicNode> clazz2, int n2, int n3, int n4, HIRBlock hIRBlock, int n5, int n6, int n7, int n8, EconomicMap<Class<?>, Integer> economicMap, int n9, EconomicMap<Class<?>, Integer> economicMap2) {
        this.originMethod = resolvedJavaMethod;
        this.node = controlSplitNode;
        this.parent = controlSplitNode2;
        this.csType = new c(clazz);
        this.csConditionType = new c(clazz2);
        this.csDepth = new h(n2);
        this.loopDepth = new h(n3);
        this.dominatorDepth = new h(n4);
        this.block = hIRBlock;
        this.blockEstimatedAssemblySize = new h(n5);
        this.blockEstimatedCPUCycles = new h(n6);
        this.blockEstimatedCPUCheap = new h(n7);
        this.blockEstimatedCPUExpensive = new h(n8);
        this.blockDataFlowHistogram = new e(economicMap);
        this.predecessorsCount = new h(n9);
        this.predecessorsDataFlowHistogram = new e(economicMap2);
        this.branches = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.branchesOrder = new ArrayList<Integer>();
        this.label = null;
        this.labelCount = null;
        if (this.node.getNodeSourcePosition() != null) {
            ControlSplitNode controlSplitNode3 = this.node;
            if (controlSplitNode3 instanceof IfNode) {
                IfNode ifNode = (IfNode)controlSplitNode3;
                this.branchesOrder.add(ControlSplitFeatures.getNodeSourcePosition((Node)ifNode.trueSuccessor()));
                this.branchesOrder.add(ControlSplitFeatures.getNodeSourcePosition((Node)ifNode.falseSuccessor()));
            } else {
                for (Node node : this.node.successors()) {
                    this.branchesOrder.add(ControlSplitFeatures.getNodeSourcePosition(node));
                }
            }
        }
    }

    public void addBranch(AbstractBeginNode abstractBeginNode, List<HIRBlock> list, Class<? extends Node> clazz, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, List<ResolvedJavaMethod> list2, EconomicMap<Class<?>, Integer> economicMap) {
        PathFeatures pathFeatures = new PathFeatures(list, clazz, n2, n3, n4, n5, n6, n7, n8, n9, list2, economicMap);
        this.branches.put((Object)abstractBeginNode, (Object)pathFeatures);
    }

    public boolean n() {
        return this.label != null && this.labelCount != null && this.label.size() > 0 && this.labelCount.size() > 0;
    }

    public List<Float> a(EconomicMap<String, List<String>> economicMap) {
        List list = super.a(orderedFeatures, economicMap);
        if (this.node instanceof IfNode) {
            AbstractBeginNode abstractBeginNode = ((IfNode)this.node).trueSuccessor();
            assert (this.branches.containsKey((Object)abstractBeginNode));
            list.addAll(((PathFeatures)((Object)this.branches.get((Object)abstractBeginNode))).a(economicMap));
            AbstractBeginNode abstractBeginNode2 = ((IfNode)this.node).falseSuccessor();
            assert (this.branches.containsKey((Object)abstractBeginNode2));
            list.addAll(((PathFeatures)((Object)this.branches.get((Object)abstractBeginNode2))).a(economicMap));
        } else {
            GraalError.shouldNotReachHere((String)("Providing features for the currently unsupported control split: " + this.node.getNodeClass().toString()));
        }
        return list;
    }

    public void a(a a2) {
        this.a(ControlSplitFeatures.class, a2);
    }

    protected List<Field> o() {
        return ControlSplitFeatures.a(ControlSplitFeatures.class, List.of(subfeatureName, subfeatureOrder, "label", "labelCount", "orderedFeatures", "orderedEncoderFeatures", "featureName", "subfeatureName", "subfeatureOrder"));
    }

    @Override
    public void setLabel(EconomicMap<Integer, Double> economicMap, EconomicMap<Integer, Long> economicMap2) {
        this.label = economicMap;
        this.labelCount = economicMap2;
    }

    public int getCsDepth() {
        return (Integer)this.csDepth.l();
    }

    public ControlSplitNode getParent() {
        return this.parent;
    }

    public ControlSplitNode getNode() {
        return this.node;
    }

    public HIRBlock getBlock() {
        return this.block;
    }

    public Class<? extends Node> getCsType() {
        return (Class)this.csType.l();
    }

    public Class<? extends Node> getCsConditionType() {
        return (Class)this.csConditionType.l();
    }

    public int getLoopDepth() {
        return (Integer)this.loopDepth.l();
    }

    public int getDominatorDepth() {
        return (Integer)this.dominatorDepth.l();
    }

    public int getPredecessorsCount() {
        return (Integer)this.predecessorsCount.l();
    }

    public PathFeatures getBranch(AbstractBeginNode abstractBeginNode) {
        if (!this.branches.containsKey((Object)abstractBeginNode)) {
            VMError.shouldNotReachHere((String)("Can not fetch branch features: invalid branch begin node specified " + String.valueOf(abstractBeginNode)));
        }
        return (PathFeatures)((Object)this.branches.get((Object)abstractBeginNode));
    }

    public int getBlockEstimatedAssemblySize() {
        return (Integer)this.blockEstimatedAssemblySize.l();
    }

    public int getBlockEstimatedCPUCycles() {
        return (Integer)this.blockEstimatedCPUCycles.l();
    }

    public int getBlockEstimatedCPUCheap() {
        return (Integer)this.blockEstimatedCPUCheap.l();
    }

    public int getBlockEstimatedCPUExpensive() {
        return (Integer)this.blockEstimatedCPUExpensive.l();
    }

    public EconomicMap<Class<?>, Integer> getBlockDataFlowHistogram() {
        return (EconomicMap)this.blockDataFlowHistogram.l();
    }

    public EconomicMap<Class<?>, Integer> getPredecessorsDataFlowHistogram() {
        return (EconomicMap)this.predecessorsDataFlowHistogram.l();
    }

    private static int getNodeSourcePosition(Node node) {
        NodeSourcePosition nodeSourcePosition = node.getNodeSourcePosition();
        return nodeSourcePosition != null ? nodeSourcePosition.getBCI() : -1;
    }

    @Override
    public long getLabelCount() {
        long l2 = 0L;
        Iterator iterator = this.labelCount.getValues().iterator();
        while (iterator.hasNext()) {
            long l3 = (Long)iterator.next();
            l2 += l3;
        }
        return l2;
    }
}

