/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.features;

import com.oracle.graal.compiler.enterprise.ml.features.c;
import com.oracle.svm.enterprise.hosted.ml.features.b;
import com.oracle.svm.enterprise.hosted.ml.features.e;
import com.oracle.svm.enterprise.hosted.ml.features.h;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class BlockFeatures
extends c
implements b {
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=1)
    private final e nodeTypes;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=2)
    private final h csDepth;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=3)
    private final h loopDepth;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=4)
    private final h dominatorDepth;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=5)
    private h assemblySize;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=6)
    private h cpuCycles;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=7)
    private h cpuCheap;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=8)
    private h cpuExpensive;
    @com.oracle.graal.compiler.enterprise.ml.features.b(m=9)
    private e blockDataFlowHistogram;
    private static final List<Field> orderedFeatures = BlockFeatures.a(BlockFeatures.class);
    private static final List<Field> orderedEncoderFeatures = BlockFeatures.b(BlockFeatures.class, List.of(e.class));
    private final HIRBlock block;
    private final int blockId;
    private final Node endNode;
    private final String blockName;
    private final ArrayList<Integer> outwardIds;
    private final List<Integer> branchesOrder;
    private final Integer blockBCI;
    private Integer isControlSplit;
    private EconomicMap<Integer, Double> label;
    private EconomicMap<Integer, Long> labelCount;

    public BlockFeatures(HIRBlock hIRBlock, String string, int n2, EconomicMap<Class<?>, Integer> economicMap, int n3, int n4, int n5, int n6, int n7, int n8, int n9, EconomicMap<Class<?>, Integer> economicMap2) {
        this.block = hIRBlock;
        this.blockName = string;
        this.blockId = n2;
        this.endNode = hIRBlock.getEndNode();
        this.nodeTypes = new e(economicMap);
        this.loopDepth = new h(n4);
        this.csDepth = new h(n3);
        this.dominatorDepth = new h(n5);
        this.assemblySize = new h(n6);
        this.cpuCycles = new h(n7);
        this.cpuCheap = new h(n8);
        this.cpuExpensive = new h(n9);
        this.blockDataFlowHistogram = new e(economicMap2);
        this.outwardIds = new ArrayList();
        for (int i2 = 0; i2 < hIRBlock.getSuccessorCount(); ++i2) {
            HIRBlock hIRBlock2 = (HIRBlock)hIRBlock.getSuccessorAt(i2);
            this.outwardIds.add(hIRBlock2.getId());
        }
        this.blockBCI = BlockFeatures.getNodeSourcePosition((Node)hIRBlock.getBeginNode());
        this.label = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.labelCount = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.isControlSplit = 0;
        this.branchesOrder = new ArrayList<Integer>();
        if (this.endNode instanceof IfNode) {
            this.branchesOrder.add(BlockFeatures.getNodeSourcePosition((Node)((IfNode)this.endNode).trueSuccessor()));
            this.branchesOrder.add(BlockFeatures.getNodeSourcePosition((Node)((IfNode)this.endNode).falseSuccessor()));
        } else {
            for (HIRBlock hIRBlock2 : this.endNode.successors()) {
                this.branchesOrder.add(BlockFeatures.getNodeSourcePosition((Node)hIRBlock2));
            }
        }
    }

    public boolean n() {
        return this.label.size() > 1;
    }

    public List<Float> a(EconomicMap<String, List<String>> economicMap) {
        return super.a(orderedFeatures, economicMap);
    }

    public a getBlockFeaturesMetadata() {
        return new a(this.block, this.blockId, this.blockBCI, this.isControlSplit, this.outwardIds, this.endNode);
    }

    public void a(com.oracle.graal.compiler.enterprise.ml.features.serialization.a a2) {
        this.a(BlockFeatures.class, a2);
    }

    protected List<Field> o() {
        return BlockFeatures.a(BlockFeatures.class, List.of("blockId", "blockName", "blockBCI", "outwardIds", "label", "labelCount", "isControlSplit", "branchesOrder", "orderedFeatures", "orderedEncoderFeatures"));
    }

    @Override
    public void setLabel(EconomicMap<Integer, Double> economicMap, EconomicMap<Integer, Long> economicMap2) {
        this.label = economicMap;
        this.labelCount = economicMap2;
        this.isControlSplit = 1;
    }

    public HIRBlock getBlock() {
        return this.block;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public List<Integer> getBranchesOrder() {
        return this.branchesOrder;
    }

    private static int getNodeSourcePosition(Node node) {
        NodeSourcePosition nodeSourcePosition = node.getNodeSourcePosition();
        return nodeSourcePosition != null ? nodeSourcePosition.getBCI() : -1;
    }

    public e getNodeTypes() {
        return this.nodeTypes;
    }

    public h getCsDepth() {
        return this.csDepth;
    }

    public h getLoopDepth() {
        return this.loopDepth;
    }

    public h getDominatorDepth() {
        return this.dominatorDepth;
    }

    public h getAssemblySize() {
        return this.assemblySize;
    }

    public h getCpuCycles() {
        return this.cpuCycles;
    }

    public h getCpuCheap() {
        return this.cpuCheap;
    }

    public h getCpuExpensive() {
        return this.cpuExpensive;
    }

    public e getBlockDataFlowHistogram() {
        return this.blockDataFlowHistogram;
    }

    @Override
    public long getLabelCount() {
        long l2 = 0L;
        Iterator iterator = this.labelCount.getValues().iterator();
        while (iterator.hasNext()) {
            long l3 = (Long)iterator.next();
            l2 += l3;
        }
        return l2;
    }

    public static final class a
    extends Record {
        private final HIRBlock tT;
        private final Integer tU;
        private final Integer tV;
        private final Integer tW;
        private final ArrayList<Integer> tX;
        private final Node tY;

        public a(HIRBlock hIRBlock, Integer n2, Integer n3, Integer n4, ArrayList<Integer> arrayList, Node node) {
            this.tT = hIRBlock;
            this.tU = n2;
            this.tV = n3;
            this.tW = n4;
            this.tX = arrayList;
            this.tY = node;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "block;blockId;blockBCI;isControlSplit;outwardIds;endNode", "tT", "tU", "tV", "tW", "tX", "tY"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "block;blockId;blockBCI;isControlSplit;outwardIds;endNode", "tT", "tU", "tV", "tW", "tX", "tY"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "block;blockId;blockBCI;isControlSplit;outwardIds;endNode", "tT", "tU", "tV", "tW", "tX", "tY"}, this, object);
        }

        public HIRBlock fx() {
            return this.tT;
        }

        public Integer fy() {
            return this.tU;
        }

        public Integer fz() {
            return this.tV;
        }

        public Integer fA() {
            return this.tW;
        }

        public ArrayList<Integer> fB() {
            return this.tX;
        }

        public Node fC() {
            return this.tY;
        }
    }
}

