/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.features;

import com.oracle.graal.compiler.enterprise.ml.features.b;
import com.oracle.graal.compiler.enterprise.ml.features.c;
import com.oracle.graal.compiler.enterprise.ml.phases.ExtractGraphMLFeaturesBasePhase;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.ActualParameterTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.LoadFieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.NullCheckTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.StoreFieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.svm.enterprise.hosted.ml.features.a;
import com.oracle.svm.enterprise.hosted.ml.features.e;
import com.oracle.svm.enterprise.hosted.ml.features.g;
import com.oracle.svm.enterprise.hosted.ml.features.h;
import com.oracle.svm.enterprise.hosted.ml.features.i;
import com.oracle.svm.enterprise.hosted.ml.features.k;
import com.oracle.svm.enterprise.hosted.ml.features.l;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class AnalysisMethodFeatures
extends c
implements a {
    private final AnalysisMethod method;
    @b(m=1)
    private final h isPublic;
    @b(m=2)
    private final h isProtected;
    @b(m=3)
    private final h isPrivate;
    @b(m=4)
    private final h isStatic;
    @b(m=5)
    private final h isFinal;
    @b(m=6)
    private final h isSynchronized;
    @b(m=7)
    private final h isNative;
    @b(m=8)
    private final h isEntryPoint;
    @b(m=9)
    private final h isMainEntryPoint;
    @b(m=10)
    private final g signature;
    @b(m=11)
    private final k typeFlowParams;
    @b(m=12)
    private h incompleteTypeState;
    @b(m=13)
    private final e typeFlowGraphNodes;
    @b(m=14)
    private final e irGraphNodes;
    @b(m=15)
    private final h estimatedAssemblySize;
    @b(m=16)
    private final h estimatedCPUCycles;
    @b(m=17)
    private final h estimatedCPUCheap;
    @b(m=18)
    private final h estimatedCPUExpensive;
    private final List<i> invokes;
    private final Map<AnalysisField, Integer> fieldsStore;
    private final Map<AnalysisField, Integer> fieldsLoad;
    private a.a label;
    private long callCount;
    private static final List<Field> orderedFeatures = AnalysisMethodFeatures.a(AnalysisMethodFeatures.class);
    private final List<Field> orderedEncoderFeatures = AnalysisMethodFeatures.b(AnalysisMethodFeatures.class, List.of(g.class, k.class, e.class));

    private static void updateFieldsMap(Map<AnalysisField, Integer> map, AnalysisField analysisField) {
        if (map.containsKey(analysisField)) {
            map.put(analysisField, map.get(analysisField) + 1);
        } else {
            map.put(analysisField, 1);
        }
    }

    public AnalysisMethodFeatures(AnalysisMethod analysisMethod, List<i> list, boolean bl2, boolean bl3, BigBang bigBang) {
        MethodFlowsGraph methodFlowsGraph;
        this.method = analysisMethod;
        int n2 = analysisMethod.getModifiers();
        this.isPublic = new h(Modifier.isPublic(n2) ? 1 : 0);
        this.isProtected = new h(Modifier.isProtected(n2) ? 1 : 0);
        this.isPrivate = new h(Modifier.isPrivate(n2) ? 1 : 0);
        this.isStatic = new h(Modifier.isStatic(n2) ? 1 : 0);
        this.isFinal = new h(Modifier.isFinal(n2) ? 1 : 0);
        this.isSynchronized = new h(Modifier.isSynchronized(n2) ? 1 : 0);
        this.isNative = new h(Modifier.isNative(n2) ? 1 : 0);
        this.isEntryPoint = new h(bl2 ? 1 : 0);
        this.isMainEntryPoint = new h(bl3 ? 1 : 0);
        this.signature = new g(analysisMethod);
        HashMap hashMap = new HashMap();
        int n3 = 0;
        EconomicMap economicMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.fieldsStore = new HashMap<AnalysisField, Integer>();
        this.fieldsLoad = new HashMap<AnalysisField, Integer>();
        MethodTypeFlow methodTypeFlow = ((PointsToAnalysisMethod)analysisMethod).getTypeFlow();
        if (methodTypeFlow.flowsGraphCreated()) {
            methodFlowsGraph = methodTypeFlow.getMethodFlowsGraph();
            for (TypeFlow typeFlow : methodFlowsGraph.flows()) {
                NullCheckTypeFlow nullCheckTypeFlow;
                LoadFieldTypeFlow loadFieldTypeFlow;
                Class<?> clazz;
                if (typeFlow instanceof FormalParamTypeFlow || typeFlow instanceof ActualParameterTypeFlow) {
                    hashMap.put(typeFlow, new l(typeFlow, bigBang));
                }
                if (typeFlow.isSaturated() && !typeFlow.isPrimitiveFlow()) {
                    ++n3;
                }
                if (economicMap.containsKey(clazz = typeFlow.getClass())) {
                    economicMap.put(clazz, (Object)((Integer)economicMap.get(clazz) + 1));
                } else {
                    economicMap.put(clazz, (Object)1);
                }
                if (typeFlow instanceof LoadFieldTypeFlow) {
                    loadFieldTypeFlow = (LoadFieldTypeFlow)typeFlow;
                    AnalysisMethodFeatures.updateFieldsMap(this.fieldsLoad, loadFieldTypeFlow.field());
                }
                if (typeFlow instanceof StoreFieldTypeFlow) {
                    loadFieldTypeFlow = (StoreFieldTypeFlow)typeFlow;
                    AnalysisMethodFeatures.updateFieldsMap(this.fieldsStore, loadFieldTypeFlow.field());
                }
                if (!(typeFlow instanceof OffsetStoreTypeFlow.StoreIndexedTypeFlow)) continue;
                loadFieldTypeFlow = (OffsetStoreTypeFlow.StoreIndexedTypeFlow)typeFlow;
                TypeFlow<?> typeFlow2 = loadFieldTypeFlow.receiver();
                if (typeFlow2 instanceof NullCheckTypeFlow) {
                    nullCheckTypeFlow = (NullCheckTypeFlow)typeFlow2;
                    typeFlow2 = AnalysisMethodFeatures.findLoadFieldReceiver(nullCheckTypeFlow, methodFlowsGraph.flows());
                }
                if (!(typeFlow2 instanceof LoadFieldTypeFlow)) continue;
                nullCheckTypeFlow = (LoadFieldTypeFlow)typeFlow2;
                AnalysisMethodFeatures.updateFieldsMap(this.fieldsStore, nullCheckTypeFlow.field());
            }
        }
        this.typeFlowParams = new k(hashMap);
        this.incompleteTypeState = new h(n3);
        this.typeFlowGraphNodes = new e(economicMap);
        methodFlowsGraph = analysisMethod.decodeAnalyzedGraph(bigBang.getDebug(), null);
        if (methodFlowsGraph != null) {
            this.irGraphNodes = new e(ExtractGraphMLFeaturesBasePhase.a((Iterable)methodFlowsGraph.getNodes()));
            ExtractGraphMLFeaturesBasePhase.a a2 = ExtractGraphMLFeaturesBasePhase.c((Iterable)methodFlowsGraph.getNodes());
            this.estimatedAssemblySize = new h(a2.y());
            this.estimatedCPUCycles = new h(a2.z());
            this.estimatedCPUCheap = new h(a2.A());
            this.estimatedCPUExpensive = new h(a2.B());
        } else {
            this.irGraphNodes = new e(EconomicMap.create());
            this.estimatedAssemblySize = new h(0);
            this.estimatedCPUCycles = new h(0);
            this.estimatedCPUCheap = new h(0);
            this.estimatedCPUExpensive = new h(0);
        }
        this.invokes = list;
        this.label = null;
        this.callCount = -1L;
    }

    private static TypeFlow<?> findLoadFieldReceiver(NullCheckTypeFlow nullCheckTypeFlow, Iterable<TypeFlow<?>> iterable) {
        for (TypeFlow<?> typeFlow : iterable) {
            LoadFieldTypeFlow loadFieldTypeFlow;
            if (!(typeFlow instanceof LoadFieldTypeFlow) || !(loadFieldTypeFlow = (LoadFieldTypeFlow)typeFlow).getUses().contains(nullCheckTypeFlow)) continue;
            return loadFieldTypeFlow;
        }
        return null;
    }

    @Override
    public void setLabel(a.a a2, long l2) {
        if (this.label != null && this.label.a(a2)) {
            return;
        }
        this.label = a2;
        this.callCount = l2;
    }

    public boolean n() {
        return this.label != null;
    }

    public List<Float> a(EconomicMap<String, List<String>> economicMap) {
        return super.a(orderedFeatures, economicMap);
    }

    public void a(com.oracle.graal.compiler.enterprise.ml.features.serialization.a a2) {
        this.a(AnalysisMethodFeatures.class, a2);
    }

    protected List<Field> o() {
        return AnalysisMethodFeatures.a(AnalysisMethodFeatures.class, List.of("label", "callCount", "invokes", "fieldsLoad", "fieldsStore", "orderedFeatures", "orderedEncoderFeatures"));
    }
}

