/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.enterprise.hosted.buildreport.a;
import com.oracle.svm.enterprise.hosted.buildreport.d;
import com.oracle.svm.enterprise.hosted.ml.features.provider.ProfileInferenceFeature;
import com.oracle.svm.enterprise.hosted.obfuscation.m;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.enterprise.hosted.profiling.features.jfr.b;
import com.oracle.svm.enterprise.hosted.profilingframework.d;
import com.oracle.svm.enterprise.hosted.sbom.v;
import com.oracle.svm.hosted.ByteFormattingUtil;
import com.oracle.svm.hosted.Log4ShellFeature;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.ProgressReporterFeature;
import com.oracle.svm.hosted.ProgressReporterJsonHelper;
import java.io.ObjectInputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@AutomaticallyRegisteredFeature
public class l
extends ProgressReporterFeature {
    private static boolean po;
    private static final String pp = " - ";

    public static boolean dl() {
        return po;
    }

    public static void d(boolean bl2) {
        po = bl2;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        super.afterAnalysis(afterAnalysisAccess);
        l.d(afterAnalysisAccess.isReachable(ObjectInputStream.class));
    }

    protected void appendGraalSuffix(ProgressReporter.DirectPrinter directPrinter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (b.ir()) {
            arrayList.add("sampling");
        }
        if (((Boolean)d.b.ProfilingEnabled.getValue()).booleanValue()) {
            arrayList.add("instrument");
        }
        if (PGOFeature.isPGOEnabled()) {
            arrayList.add("user-provided");
        }
        if (ProfileInferenceFeature.shouldRunMLProfileInference()) {
            arrayList.add("ML-inferred");
        }
        if (!arrayList.isEmpty()) {
            this.reporter.recordJsonMetric((ProgressReporterJsonHelper.JsonMetric)ProgressReporterJsonHelper.GeneralInfo.GRAAL_COMPILER_PGO, arrayList);
        }
        String string = arrayList.isEmpty() ? "off" : String.join((CharSequence)"+", arrayList);
        ((ProgressReporter.DirectPrinter)directPrinter.a(", ").doclink("PGO", "#recommendation-pgo")).a(": ").a(string);
    }

    private ProgressReporter.DirectPrinter dm() {
        return this.reporter.l();
    }

    public void afterBreakdowns() {
        this.dn();
        this.do();
    }

    private void dn() {
        ProgressReporter.CenteredTextPrinter centeredTextPrinter = (ProgressReporter.CenteredTextPrinter)this.reporter.centered().dim();
        if (a.dw()) {
            Path path = d.dD().getFirst();
            ((ProgressReporter.CenteredTextPrinter)((ProgressReporter.CenteredTextPrinter)centeredTextPrinter.a("For more details, open '")).link(path, true)).a("'.");
        } else {
            centeredTextPrinter.a("Use '--emit build-report' to create a report with more details.");
        }
        centeredTextPrinter.reset();
        centeredTextPrinter.flushln();
    }

    private void do() {
        Object object;
        this.dm().printLineSeparator();
        ((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)this.dm().yellowBold()).a("Security report:").reset()).println();
        ((ProgressReporter.DirectPrinter)this.dm().a(" - Binary").a(po ? " includes " : " does not include ").doclink("Java deserialization", "#glossary-deserialization")).a(".").println();
        this.dp();
        this.dq();
        if (SubstrateControlFlowIntegrity.enabled()) {
            object = SubstrateControlFlowIntegrity.singleton().getCFIMode();
            if (object == SubstrateControlFlowIntegrity.CFIOptions.HW) {
                ((ProgressReporter.DirectPrinter)this.dm().a(pp).doclink("Backwards-edge control-flow integrity (CFI)", "#glossary-backwards-edge-cfi")).a(" enforced within the binary using pointer authentication codes (PAC).").println();
            } else if (SubstrateControlFlowIntegrity.useSoftwareCFI()) {
                ((ProgressReporter.DirectPrinter)this.dm().a(pp).doclink("Control-flow integrity (CFI) enforced in software", "#glossary-sw-cfi")).a(" with target checks for indirect branches and function returns.").println();
            }
        }
        if (ImageSingletons.contains(Log4ShellFeature.class) && (object = ((Log4ShellFeature)ImageSingletons.lookup(Log4ShellFeature.class)).getUserWarning()) != null) {
            ((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)this.dm().red()).a(" - %s", new Object[]{object})).reset()).println();
        }
    }

    private void dp() {
        if (ImageSingletons.contains(v.class)) {
            int n2;
            v v2 = (v)ImageSingletons.lookup(v.class);
            ProgressReporter.DirectPrinter directPrinter = ((ProgressReporter.DirectPrinter)((ProgressReporter.DirectPrinter)this.dm().a(pp).a("%s ", new Object[]{v2.kj()})).doclink("SBOM", "#glossary-sbom")).a(" with " + v2.ki() + " component(s)");
            if (v2.kg()) {
                directPrinter.a(" and class-level info");
            }
            directPrinter.a(" is");
            boolean bl2 = v2.kk() != null;
            boolean bl3 = v2.kl() != null;
            boolean bl4 = v2.km();
            int n3 = n2 = (bl2 ? 1 : 0) + (bl3 ? 1 : 0) + (bl4 ? 1 : 0);
            if (bl2) {
                --n3;
                directPrinter.a(" embedded in binary (%s)", new Object[]{ByteFormattingUtil.bytesToHuman((long)v2.kk().intValue())});
            }
            if (bl3) {
                directPrinter.a("%s saved to class path (%s)", new Object[]{l.c(n2, --n3), v2.kl()});
            }
            if (bl4) {
                directPrinter.a("%s exported as JSON (see build artifacts)", new Object[]{l.c(n2, --n3)});
            }
            directPrinter.a(".");
            List<String> list = v2.kn();
            if (!list.isEmpty()) {
                directPrinter.a(" %s type(s) could not be associated to a component.", new Object[]{list.size()});
            }
            directPrinter.println();
        } else {
            ((ProgressReporter.DirectPrinter)this.dm().a(pp).doclink("Software Bill of Materials (SBOM) feature", "#glossary-sbom")).a(" was disabled.").println();
        }
    }

    private void dq() {
        ProgressReporter.DirectPrinter directPrinter = this.dm();
        directPrinter.a(pp).doclink("Advanced obfuscation", "#glossary-obfuscation");
        if (ImageSingletons.contains(m.class)) {
            directPrinter.a(" was applied to your application and libraries.");
        } else {
            directPrinter.a(" not enabled; enable with '%s' (experimental support).", new Object[]{"-H:AdvancedObfuscation=\"\""});
        }
        directPrinter.println();
    }

    private static String c(int n2, int n3) {
        if (n2 == 1) {
            return "";
        }
        String string = n2 > 2 ? ", and" : " and";
        return n3 == 0 ? string : ",";
    }

    public void createAdditionalArtifactsOnSuccess(BuildArtifacts buildArtifacts) {
        if (a.dw()) {
            ((a)ImageSingletons.lookup(a.class)).dy().a(buildArtifacts);
        }
    }

    protected List<ProgressReporterFeature.UserRecommendation> getRecommendations() {
        ArrayList<ProgressReporterFeature.UserRecommendation> arrayList = new ArrayList<ProgressReporterFeature.UserRecommendation>();
        arrayList.add(new ProgressReporterFeature.UserRecommendation("G1GC", "Use the G1 GC ('--gc=G1') for improved latency and throughput.", l::dr));
        arrayList.add(new ProgressReporterFeature.UserRecommendation("PGO", "Use Profile-Guided Optimizations ('--pgo') for improved throughput.", () -> !PGOFeature.isPGOEnabled() && !com.oracle.svm.enterprise.hosted.profilingframework.d.is()));
        arrayList.addAll(super.getRecommendations());
        arrayList.add(new ProgressReporterFeature.UserRecommendation("QBM", "Use the quick build mode ('-Ob') to speed up builds during development.", () -> !SubstrateOptions.useEconomyCompilerConfig()));
        return arrayList;
    }

    private static boolean dr() {
        return !SubstrateOptions.SupportedGCs.hasBeenSet() && Platform.includedIn(Platform.LINUX_AMD64.class);
    }
}

