/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.code.layout;

import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.enterprise.hosted.code.layout.e;
import com.oracle.svm.enterprise.hosted.code.layout.k;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.hosted.profilingframework.d;
import com.oracle.svm.hosted.code.CodeSectionLayouter;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdk.graal.compiler.code.CompilationResult;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageSingletons;

public class i
implements CodeSectionLayouter {
    public List<HostedMethod> layout(Map<HostedMethod, CompilationResult> map) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<HostedMethod, CompilationResult> hashMap = new HashMap<HostedMethod, CompilationResult>();
        PGOProfilesLookup pGOProfilesLookup = (PGOProfilesLookup)ImageSingletons.lookup(PGOProfilesLookup.class);
        for (Map.Entry<HostedMethod, CompilationResult> entry : map.entrySet()) {
            HostedMethod hostedMethod = entry.getKey();
            Optional<PGOProfilesLookup.ProfiledValue<Long>> optional = pGOProfilesLookup.getFirstCallTimestampProfile(hostedMethod);
            if (optional.isPresent()) {
                arrayList.add(Pair.create((Object)hostedMethod, (Object)optional.get().value()));
                continue;
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        UserError.guarantee((!arrayList.isEmpty() ? 1 : 0) != 0, (String)"No timestamp values found in the supplied profiles. Please ensure to gather the timestamp profiles using `--pgo-instrument %s` before using %s", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(d.b.ProfileMethodTimestamps, (String)"+"), SubstrateOptionsParser.commandArgument(e.b.CodeSectionLayoutOptimization, (String)e.a.tb.name())});
        arrayList.sort(i.eY());
        ArrayList arrayList2 = new ArrayList();
        for (Pair pair : arrayList) {
            arrayList2.add((HostedMethod)pair.getLeft());
        }
        arrayList2.addAll(new k().layout(hashMap));
        assert (arrayList2.stream().allMatch(map::containsKey)) : "Some compilations are missing from the final layout.";
        return arrayList2;
    }

    private static Comparator<Pair<HostedMethod, Long>> eY() {
        return Comparator.comparing(Pair::getRight);
    }
}

