/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.code.layout;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.code.layout.d;
import com.oracle.svm.enterprise.hosted.code.layout.i;
import com.oracle.svm.enterprise.hosted.code.layout.j;
import com.oracle.svm.enterprise.hosted.code.layout.k;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.hosted.profilingframework.d;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.CodeLayoutOptimizationFeature;
import com.oracle.svm.hosted.code.CodeSectionLayouter;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.util.json.JsonPrettyWriter;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class e
extends CodeLayoutOptimizationFeature {
    public static boolean eU() {
        return ((a)((Object)b.CodeSectionLayoutOptimization.getValue())).equals((Object)a.ta);
    }

    public static boolean eV() {
        return !((a)((Object)b.CodeSectionLayoutOptimization.getValue())).equals((Object)a.sW) && !((a)((Object)b.CodeSectionLayoutOptimization.getValue())).equals((Object)a.ta) && PGOFeature.isPGOEnabled();
    }

    public static boolean eW() {
        return !SubstrateOptions.useEconomyCompilerConfig() && (e.eV() || e.eU());
    }

    protected CodeSectionLayouter createCodeSectionLayoutOptimizer() {
        if (e.eW()) {
            return switch (((a)((Object)b.CodeSectionLayoutOptimization.getValue())).ordinal()) {
                case 4 -> new k();
                case 1 -> new j();
                case 2 -> new d();
                case 3 -> new com.oracle.svm.enterprise.hosted.code.layout.b();
                case 5 -> new i();
                default -> throw VMError.shouldNotReachHere((String)"Code layout optimization enabled, but a code layout optimizer is not set.");
            };
        }
        return super.createCodeSectionLayoutOptimizer();
    }

    public void duringSetup(Feature.DuringSetupAccess duringSetupAccess) {
        ImageSingletons.add(com.oracle.svm.enterprise.hosted.code.layout.a.class, (Object)new com.oracle.svm.enterprise.hosted.code.layout.a());
    }

    public void afterCompilation(Feature.AfterCompilationAccess afterCompilationAccess) {
        FeatureImpl.AfterCompilationAccessImpl afterCompilationAccessImpl = (FeatureImpl.AfterCompilationAccessImpl)afterCompilationAccess;
        if (((Boolean)b.PrintCodeLayout.getValue()).booleanValue()) {
            e.a(afterCompilationAccessImpl.getCodeCache());
        }
    }

    public void beforeHeapLayout(Feature.BeforeHeapLayoutAccess beforeHeapLayoutAccess) {
        ((com.oracle.svm.enterprise.hosted.code.layout.a)ImageSingletons.lookup(com.oracle.svm.enterprise.hosted.code.layout.a.class)).clear();
    }

    private static void a(NativeImageCodeCache nativeImageCodeCache) {
        List list = nativeImageCodeCache.getOrderedCompilations();
        PGOProfilesLookup pGOProfilesLookup = PGOProfilesLookup.singleton();
        String string = ((a)((Object)b.CodeSectionLayoutOptimization.getValue())).name();
        ReportUtils.report((String)"Code section contents", (String)SubstrateOptions.reportsPath(), (String)String.format("code-layout-%s", string), (String)"json", printWriter -> {
            try (JsonPrettyWriter jsonPrettyWriter = new JsonPrettyWriter((Writer)printWriter);){
                jsonPrettyWriter.appendArrayStart();
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Pair pair = (Pair)list.get(i2);
                    HostedMethod hostedMethod = (HostedMethod)pair.getLeft();
                    CompilationResult compilationResult = (CompilationResult)pair.getRight();
                    jsonPrettyWriter.appendObjectStart().appendKeyValue("index", (Object)i2).appendSeparator().appendKeyValue("methodName", (Object)hostedMethod.format("%H.%n(%p)")).appendSeparator().appendKeyValue("methodCodeSectionOffset", (Object)hostedMethod.getCodeAddressOffset()).appendSeparator().appendKeyValue("methodCodeSize", (Object)compilationResult.getTargetCodeSize());
                    if (pGOProfilesLookup != null) {
                        Optional<PGOProfilesLookup.ProfiledValue<Long>> optional;
                        Optional<PGOProfilesLookup.ProfiledValue<Long>> optional2 = pGOProfilesLookup.getCallCountProfile(hostedMethod);
                        if (optional2.isPresent()) {
                            jsonPrettyWriter.appendSeparator();
                            jsonPrettyWriter.appendKeyValue("methodCallCount", (Object)optional2.get().value());
                        }
                        if ((optional = pGOProfilesLookup.getFirstCallTimestampProfile(hostedMethod)).isPresent()) {
                            jsonPrettyWriter.appendSeparator();
                            jsonPrettyWriter.appendKeyValue("methodFirstCallTimestamp", (Object)optional.get().value());
                        }
                    }
                    jsonPrettyWriter.appendObjectEnd();
                    if (i2 >= list.size() - 1) continue;
                    jsonPrettyWriter.appendSeparator();
                }
                jsonPrettyWriter.appendArrayEnd();
            }
            catch (IOException iOException) {
                throw GraalError.shouldNotReachHere((Throwable)iOException);
            }
        });
    }

    public static class b {
        public static final HostedOptionKey<a> CodeSectionLayoutOptimization = new HostedOptionKey<a>(null, b::i){

            public a d(UnmodifiableEconomicMap<OptionKey<?>, Object> unmodifiableEconomicMap) {
                if (SubstrateOptions.LayerUse.hasBeenSet()) {
                    return a.sW;
                }
                if (unmodifiableEconomicMap.containsKey((Object)this)) {
                    return (a)((Object)super.getValueOrDefault(unmodifiableEconomicMap));
                }
                if (PGOFeature.isPGOEnabled(unmodifiableEconomicMap)) {
                    return a.sY;
                }
                return a.ta;
            }

            public a d(OptionValues optionValues) {
                return this.d(optionValues.getMap());
            }

            public /* synthetic */ Object getValueOrDefault(UnmodifiableEconomicMap unmodifiableEconomicMap) {
                return this.d(unmodifiableEconomicMap);
            }

            public /* synthetic */ Object getValue(OptionValues optionValues) {
                return this.d(optionValues);
            }
        };
        public static final HostedOptionKey<Boolean> PrintCodeLayout = new HostedOptionKey((Object)false);

        private static void i(HostedOptionKey<a> hostedOptionKey) {
            if (((a)((Object)hostedOptionKey.getValue())).equals((Object)a.tb)) {
                UserError.guarantee((boolean)PGOFeature.isPGOEnabled(), (String)"%s code section layout optimization requires PGO information.Please run native-image with `--pgo-instrument %s` first to gather method call order timestamps and then with `--pgo %s`.", (Object[])new Object[]{a.tb.name(), SubstrateOptionsParser.commandArgument(d.b.ProfileMethodTimestamps, (String)"+"), SubstrateOptionsParser.commandArgument(CodeSectionLayoutOptimization, (String)a.tb.name())});
            }
        }
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a sW = new a();
        public static final /* enum */ a sX = new a();
        public static final /* enum */ a sY = new a();
        public static final /* enum */ a sZ = new a();
        public static final /* enum */ a ta = new a();
        public static final /* enum */ a tb = new a();
        private static final /* synthetic */ a[] $VALUES;

        public static a[] values() {
            return (a[])$VALUES.clone();
        }

        public static a E(String string) {
            return Enum.valueOf(a.class, string);
        }

        private static /* synthetic */ a[] eX() {
            return new a[]{sW, sX, sY, sZ, ta, tb};
        }

        static {
            $VALUES = a.eX();
        }
    }
}

