/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.code.layout;

import com.oracle.svm.core.util.ConcurrentIdentityHashMap;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.concurrent.ConcurrentMap;
import jdk.graal.compiler.debug.Assertions;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class a {
    private ConcurrentMap<HostedMethod, EconomicMap<HostedMethod, Long>> sC = new ConcurrentIdentityHashMap();

    public boolean r(HostedMethod hostedMethod) {
        return !this.sC.containsKey(hostedMethod);
    }

    public void a(HostedMethod hostedMethod, EconomicMap<HostedMethod, Long> economicMap) {
        this.sC.put(hostedMethod, economicMap);
    }

    public void eD() {
        EconomicSet economicSet = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
        economicSet.addAll(this.sC.keySet());
        for (HostedMethod hostedMethod : this.sC.keySet()) {
            economicSet.addAll(((EconomicMap)this.sC.get(hostedMethod)).getKeys());
        }
        assert (this.sC.keySet().size() == economicSet.size()) : "The number of methods for which the CalculateCallEdgeCountPhase/CalculateCallEdgeInfoPhase was called is not the same as the number of methods that are profiled/considered.\nPhase called for " + this.sC.keySet().size() + " methods, while the number of profiled/considered methods is " + economicSet.size() + "\nPhase not called for: " + this.d((EconomicSet<HostedMethod>)economicSet);
    }

    String d(EconomicSet<HostedMethod> economicSet) {
        StringBuilder stringBuilder = new StringBuilder();
        for (HostedMethod hostedMethod : economicSet) {
            if (this.sC.containsKey(hostedMethod)) continue;
            stringBuilder.append(System.lineSeparator()).append(hostedMethod);
            for (HostedMethod hostedMethod2 : this.sC.keySet()) {
                if (!((EconomicMap)this.sC.get(hostedMethod2)).containsKey((Object)hostedMethod)) continue;
                stringBuilder.append(System.lineSeparator()).append("  ").append(" called by").append(System.lineSeparator()).append(hostedMethod2);
            }
            stringBuilder.append(System.lineSeparator()).append("------------------");
        }
        return stringBuilder.toString();
    }

    public UnmodifiableEconomicMap<HostedMethod, UnmodifiableEconomicMap<HostedMethod, Long>> eE() {
        if (this.sC == null) {
            throw VMError.shouldNotReachHere((Throwable)new NullPointerException("Access to callEdgeMap after it's been cleared."));
        }
        if (Assertions.assertionsEnabled()) {
            this.eD();
        }
        EconomicMap economicMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        for (HostedMethod hostedMethod : this.sC.keySet()) {
            economicMap.put((Object)hostedMethod, (Object)((UnmodifiableEconomicMap)this.sC.get(hostedMethod)));
        }
        return economicMap;
    }

    public void clear() {
        if (this.sC != null) {
            this.sC.clear();
            this.sC = null;
        }
    }
}

