/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.code.layout;

import com.oracle.svm.core.nodes.SubstrateIndirectCallTargetNode;
import com.oracle.svm.enterprise.hosted.code.layout.a;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.ArrayList;
import java.util.function.Function;
import jdk.graal.compiler.core.common.cfg.AbstractControlFlowGraph;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.JavaMethodProfile;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class CalculateCallEdgeCountPhase
extends BasePhase<CoreProviders> {
    final PGOProfilesLookup sz;
    final a sA;

    public CalculateCallEdgeCountPhase(PGOProfilesLookup pGOProfilesLookup, a a2) {
        this.sz = pGOProfilesLookup;
        this.sA = a2;
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        HostedMethod hostedMethod = (HostedMethod)structuredGraph.method();
        assert (this.sA.r(hostedMethod)) : "CalculateCallEdgeCountPhase: Caller-callee count should not be overwritten: double entry for " + String.valueOf(hostedMethod);
        if (!this.sz.isExecuted(hostedMethod)) {
            return;
        }
        ControlFlowGraph controlFlowGraph = CalculateCallEdgeCountPhase.d(structuredGraph);
        Function<HIRBlock, Iterable<? extends Node>> function = CalculateCallEdgeCountPhase.a(controlFlowGraph);
        EconomicMap economicMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        for (HIRBlock hIRBlock : controlFlowGraph.getBlocks()) {
            double d2 = hIRBlock.getRelativeFrequency();
            for (Node node : function.apply(hIRBlock)) {
                if (!(node instanceof Invoke)) continue;
                long l2 = this.sz.getCallCountProfile(hostedMethod).map(PGOProfilesLookup.ProfiledValue::value).orElse(0L);
                this.a((Invoke)node, (EconomicMap<HostedMethod, Long>)economicMap, l2, d2);
            }
        }
        this.sA.a(hostedMethod, (EconomicMap<HostedMethod, Long>)economicMap);
    }

    private static ControlFlowGraph d(StructuredGraph structuredGraph) {
        if (structuredGraph.getLastSchedule() == null) {
            return ControlFlowGraph.newBuilder((StructuredGraph)structuredGraph).connectBlocks(true).computeLoops(true).computeFrequency(true).build();
        }
        return structuredGraph.getLastSchedule().getCFG();
    }

    private static Function<HIRBlock, Iterable<? extends Node>> a(ControlFlowGraph controlFlowGraph) {
        BlockMap blockMap = new BlockMap((AbstractControlFlowGraph)controlFlowGraph);
        for (HIRBlock hIRBlock : controlFlowGraph.getBlocks()) {
            ArrayList<FixedNode> arrayList = new ArrayList<FixedNode>();
            for (FixedNode fixedNode : hIRBlock.getNodes()) {
                arrayList.add(fixedNode);
            }
            blockMap.put((BasicBlock)hIRBlock, arrayList);
        }
        return arg_0 -> ((BlockMap)blockMap).get(arg_0);
    }

    private void a(Invoke invoke, EconomicMap<HostedMethod, Long> economicMap, long l2, double d2) {
        if (invoke.callTarget() == null) {
            return;
        }
        if (invoke.getInvokeKind().isDirect()) {
            this.b(invoke, economicMap, l2, d2);
        } else {
            this.c(invoke, economicMap, l2, d2);
        }
    }

    private void b(Invoke invoke, EconomicMap<HostedMethod, Long> economicMap, long l2, double d2) {
        if (invoke.getTargetMethod() == null) {
            return;
        }
        HostedMethod hostedMethod = (HostedMethod)invoke.getTargetMethod();
        this.a(hostedMethod, economicMap, l2, d2, 1.0);
    }

    private void c(Invoke invoke, EconomicMap<HostedMethod, Long> economicMap, long l2, double d2) {
        SubstrateIndirectCallTargetNode substrateIndirectCallTargetNode = (SubstrateIndirectCallTargetNode)invoke.callTarget();
        if (substrateIndirectCallTargetNode.getMethodProfile() == null) {
            return;
        }
        for (JavaMethodProfile.ProfiledMethod profiledMethod : substrateIndirectCallTargetNode.getMethodProfile().getMethods()) {
            HostedMethod hostedMethod = (HostedMethod)profiledMethod.getMethod();
            this.a(hostedMethod, economicMap, l2, d2, profiledMethod.getProbability());
        }
    }

    private void a(HostedMethod hostedMethod, EconomicMap<HostedMethod, Long> economicMap, long l2, double d2, double d3) {
        if (!this.sz.isExecuted(hostedMethod)) {
            return;
        }
        long l3 = Math.round((double)l2 * d2 * d3);
        if (l3 > 0L) {
            Long l4 = (Long)economicMap.get((Object)hostedMethod, (Object)0L);
            economicMap.put((Object)hostedMethod, (Object)(l4 + l3));
        }
    }
}

