/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.buildreport.data;

import com.oracle.graal.reporter.data.TableData;
import com.oracle.svm.hosted.ByteFormattingUtil;
import com.oracle.svm.hosted.EmbeddedResourceExporter;
import com.oracle.svm.hosted.EmbeddedResourcesInfo;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.util.json.JsonWriter;

public final class d {
    private static final String qV = "unnamed";
    private static final String qW = "<ul>\n    <li>Shows the resource module</li>\n    <li>Entries marked as <i>unnamed</i> are not from module</li>\n</ul>\n";
    private static final String qX = "<ul>\n    <li>Shows the resource name</li>\n    <li>Number in the brackets represents number of different resources with same name and module values</li>\n</ul>\n";
    private static final String qY = "<ul>\n    <li>Shows the number of occurrences for the particular resource</li>\n    <li>A number greater than one can indicate a problem, because it means that a resource was embedded multiple times</li>\n</ul>\n";
    private static final String qZ = "Injected";
    private static final String ra = "n/a";
    private static final String rb = "<ul>\n    <li>Shows the resource location on the system</li>\n    <li>Entries marked as <i>Injected</i> were added programmatically</li>\n    <li>Browsers cannot open all types of resources (e.g. jars)</li>\n</ul>\n";
    private static final String[] rc = new String[]{"Show injected resources"};
    private static final String[] rd = new String[]{"Shows resources registered programmatically through the GraalVM SDK, typically used by a framework to assist Native Image compilation."};
    private static final String re = "directory";
    private static final String rf = "file";
    private static final String rg = "missing";
    private static final String rh = "<ul>\n    <li>\n        <span>Shows the resource type</span>\n        <ul>\n            <li><span class=\"directory\"></span>: directory resource</div></li>\n            <li><span class=\"file\"></span>: file resource</div></li>\n            <li><span class=\"missing\"></span>: missing resource - was tried to be registered but does not exist on the system</div></li>\n        </ul>\n    </li>\n</ul>\n";
    private static final String[] ri = new String[]{"Shows missing resources", "Shows directory resources"};
    private static final String[] rj = new String[]{"Shows resources that failed to be registered because they were missing on the system.", "Shows resources that represent a directory. These resources are typically small as they only contain the names of files and directories within that directory."};
    private static final String rk = "Shows the resource size. The size of directory resources depends on the size of all directory entry names.";
    private final EmbeddedResourcesInfo rl;

    public d(EmbeddedResourcesInfo embeddedResourcesInfo) {
        this.rl = embeddedResourcesInfo;
    }

    private static TableData.RowData a(String string, String string2, int n2, String string3, String string4, int n3, double d2, boolean bl2) {
        return new TableData.RowData(List.of(new TableData.TextCellData(string, "resource-module text-truncate" + (string.equals(qV) ? " text-italic" : "")), new TableData.TextCellData(string2, "resource-name text-truncate"), new TableData.TextCellData(Integer.toString(n2), "resource-occurrences"), string3.equals("INJECTED") ? new TableData.BadgesCellData(List.of(qZ)) : (string3.equals(ra) ? new TableData.TextCellData(string3, "resource-origin") : new TableData.LinksCellData(List.of(string3), List.of(string3), "resource-origin text-truncate")), new TableData.IconCellData(string4, "resource-type text-center"), new TableData.SizeCellData(ByteFormattingUtil.bytesToHuman((long)n3), d2)), bl2);
    }

    private static String dX() throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        EmbeddedResourceExporter.printReport((JsonWriter)jsonWriter);
        return stringWriter.toString();
    }

    public TableData dW() {
        Object object2;
        List list = EmbeddedResourceExporter.getResourceReportEntryList((ConcurrentHashMap)this.rl.getRegisteredResources());
        int n2 = 0;
        for (Object object2 : list) {
            for (EmbeddedResourceExporter.SourceSizePair sourceSizePair : object2.entries()) {
                n2 += sourceSizePair.size();
            }
        }
        TableData.HeaderRowData headerRowData = new TableData.HeaderRowData(List.of(new TableData.TextHeaderCellData("Module", null, qW, true, TableData.HeaderCellData.SortType.STRING), new TableData.TextHeaderCellData("Name", null, qX, true, TableData.HeaderCellData.SortType.STRING), new TableData.TextHeaderCellData("Count", null, qY, true, TableData.HeaderCellData.SortType.NUMBER), new TableData.TextHeaderCellData("Origin", null, rb, true, TableData.HeaderCellData.SortType.STRING, true, new String[]{qZ}, rc, rd), new TableData.TextHeaderCellData("Type", "text-center", rh, true, TableData.HeaderCellData.SortType.STRING, true, new String[]{rg, re}, ri, rj), new TableData.TotalHeaderCellData("Size", ByteFormattingUtil.bytesToHuman((long)n2), "text-end", rk, true)));
        object2 = new ArrayList();
        for (EmbeddedResourceExporter.SourceSizePair sourceSizePair : list) {
            String string = sourceSizePair.module() != null ? sourceSizePair.module() : qV;
            String string2 = sourceSizePair.resourceName();
            if (sourceSizePair.isMissing()) {
                object2.add(d.a(string, string2, 1, ra, rg, 0, 0.0, false));
                continue;
            }
            for (EmbeddedResourceExporter.SourceSizePair sourceSizePair2 : sourceSizePair.entries()) {
                String string3 = sourceSizePair2.source();
                boolean bl2 = string3.equals("INJECTED");
                boolean bl3 = sourceSizePair.isDirectory();
                double d2 = 100.0 * (double)sourceSizePair2.size() / (double)n2;
                object2.add(d.a(string, string2, sourceSizePair.entries().size(), string3, bl3 ? re : rf, sourceSizePair2.size(), d2, !bl2 && !bl3));
            }
        }
        Object object3 = null;
        try {
            object3 = d.dX();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new TableData(List.of(headerRowData), (List)object2, null, true, (String)object3);
    }
}

