/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.buildreport.data;

import com.oracle.graal.reporter.data.BreakdownData;
import com.oracle.graal.reporter.data.SunburstChartData;
import com.oracle.graal.reporter.data.TableData;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.hosted.ByteFormattingUtil;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.code.SourceMapping;
import jdk.graal.compiler.util.json.JsonBuilder;

public final class a {
    private static final String pJ = "Method-based code area breakdown";
    private static final String pK = "The chart below shows how different packages <i>relate</i> to each other depending on the selected breakdown type.<br><br>\n<i>Note: A fixed threshold (0.1% of total percentage relative to current root package) is used to <i>limit</i> the amount of data shown on the chart.</i>";
    private static final String pL = "Represents different breakdown types. Each type is represented by a specific method set and a metric by which the package percentages are calculated.";
    private static final String pM = "Packages and classes";
    private static final String pN = "Bytecode size of methods found reachable by the static analysis";
    private static final String pO = "";
    private static final String pP = "Bytecode size";
    private static final String pQ = "Machine code size of methods that are AOT compiled";
    private static final String pR = "";
    private static final String pS = "Machine code size";
    private static final String pT = "Machine code size of root and inlined source methods";
    private static final String pU = "";
    private static final String pV = "Machine code size";
    private static final String pW = "Class methods";
    private static final String pX = "Name";
    private static final String pY = "Origin";
    private static final String pZ = "Number of inlinings";
    private final Set<HostedMethod> qa;
    private final Map<HostedMethod, Integer> qb;
    private final Map<HostedMethod, c> qc;

    public a(Collection<HostedMethod> collection, Map<HostedMethod, CompileQueue.CompileTask> map) {
        this.qa = collection.stream().filter(hostedMethod -> hostedMethod.getWrapped().isReachable()).collect(Collectors.toSet());
        this.qa.addAll(map.keySet());
        this.qb = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((CompileQueue.CompileTask)entry.getValue()).result.getTargetCodeSize()));
        if (com.oracle.svm.enterprise.hosted.buildreport.a.dx()) {
            this.qc = new HashMap<HostedMethod, c>();
            this.a(map);
        } else {
            this.qc = null;
        }
    }

    private void a(Map<HostedMethod, CompileQueue.CompileTask> map) {
        map.forEach((hostedMethod2, compileTask) -> {
            CompilationResult compilationResult = compileTask.result;
            int n2 = 0;
            HashSet<HostedMethod> hashSet = new HashSet<HostedMethod>();
            for (SourceMapping sourceMapping : compilationResult.getSourceMappings()) {
                HostedMethod hostedMethod3 = (HostedMethod)sourceMapping.getSourcePosition().getMethod();
                this.qa.add(hostedMethod3);
                c c2 = this.qc.computeIfAbsent(hostedMethod3, hostedMethod -> new c());
                int n3 = sourceMapping.getEndOffset() - sourceMapping.getStartOffset();
                if (sourceMapping.getSourcePosition().getCaller() == null) {
                    c2.s(n3);
                } else {
                    c2.t(n3);
                    hashSet.add(hostedMethod3);
                }
                n2 += n3;
            }
            this.qc.computeIfAbsent((HostedMethod)hostedMethod2, hostedMethod -> new c()).u(compilationResult.getTargetCodeSize() - n2);
            for (HostedMethod hostedMethod4 : hashSet) {
                this.qc.get(hostedMethod4).dO();
            }
        });
    }

    private boolean dG() {
        return this.qc != null;
    }

    private static void a(SunburstChartData.ArcData arcData2, Function<Integer, List<TableData.HeaderRowData>> function) {
        if (arcData2.hasPayload()) {
            d d2 = (d)arcData2.getPayload();
            d2.c(function.apply(d2.dP()));
        }
        arcData2.traverseChildrenArcs(arcData -> a.a(arcData, function));
    }

    private SunburstChartData a(Function<HostedMethod, Boolean> function, Function<HostedMethod, Integer> function2, Function<HostedMethod, d.b> function3, Function<Integer, List<TableData.HeaderRowData>> function4) {
        SunburstChartData.ArcData arcData = new SunburstChartData.ArcData("Total");
        for (HostedMethod hostedMethod : this.qa) {
            Object object;
            if (!function.apply(hostedMethod).booleanValue()) continue;
            int n2 = function2.apply(hostedMethod);
            arcData.addValue(n2);
            HostedType hostedType = hostedMethod.getDeclaringClass();
            String[] stringArray = hostedType.toJavaName().split("\\.");
            SunburstChartData.ArcData arcData2 = arcData;
            for (String string : stringArray) {
                if (!arcData2.containsChildArc(string)) {
                    arcData2.putChildArc(string, new SunburstChartData.ArcData(string));
                }
                SunburstChartData.ArcData arcData3 = arcData2.getChildArc(string);
                arcData3.addValue(n2);
                arcData2 = arcData3;
            }
            if (!arcData2.hasPayload()) {
                object = new d();
                arcData2.setPayload((SunburstChartData.ArcPayload)object);
            } else {
                object = (d)arcData2.getPayload();
            }
            ((d)((Object)object)).a(function3.apply(hostedMethod));
        }
        a.a(arcData, function4);
        return new SunburstChartData(arcData);
    }

    private SunburstChartData a(Function<HostedMethod, Boolean> function, Function<HostedMethod, Integer> function2, Function<HostedMethod, Integer> function3, Function<HostedMethod, d.b> function4, Function<Integer, List<TableData.HeaderRowData>> function5) {
        a a2 = new a("Total");
        for (HostedMethod hostedMethod : this.qa) {
            Object object;
            if (!function.apply(hostedMethod).booleanValue()) continue;
            int n2 = function2.apply(hostedMethod);
            int n3 = function3.apply(hostedMethod);
            a2.r(n3);
            a2.addValue(n2);
            HostedType hostedType = hostedMethod.getDeclaringClass();
            String[] stringArray = hostedType.toJavaName().split("\\.");
            a a3 = a2;
            for (String string : stringArray) {
                if (!a3.containsChildArc(string)) {
                    a3.putChildArc(string, new a(string));
                }
                a a4 = (a)a3.getChildArc(string);
                a4.r(n3);
                a4.addValue(n2);
                a3 = a4;
            }
            if (!a3.hasPayload()) {
                object = new d();
                a3.setPayload((SunburstChartData.ArcPayload)object);
            } else {
                object = (d)a3.getPayload();
            }
            ((d)((Object)object)).a(function4.apply(hostedMethod));
        }
        a.a(a2, function5);
        return new SunburstChartData((SunburstChartData.ArcData)a2);
    }

    public BreakdownData dH() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<SunburstChartData> arrayList2 = new ArrayList<SunburstChartData>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList.add(new BreakdownData.BreakdownType(pN, ""));
        SunburstChartData sunburstChartData = this.a(MultiMethod::isOriginalMethod, HostedMethod::getCodeSize, hostedMethod -> new d.b(hostedMethod.format("%n(%p): %r"), d.b.a.qE, hostedMethod.getCodeSize()), n2 -> List.of(new TableData.HeaderRowData(List.of(new TableData.TextHeaderCellData(pW, Integer.valueOf(3)))), new TableData.HeaderRowData(List.of(new TableData.TextHeaderCellData(pX, null, null, true, TableData.HeaderCellData.SortType.STRING), new TableData.TextHeaderCellData(pY, null, null, true, TableData.HeaderCellData.SortType.STRING), new TableData.TotalHeaderCellData(pP, ByteFormattingUtil.bytesToHuman((long)n2.intValue()), null, null, true)))));
        arrayList2.add(sunburstChartData);
        arrayList3.add(pP);
        arrayList.add(new BreakdownData.BreakdownType(pQ, ""));
        SunburstChartData sunburstChartData2 = this.a(this.qb::containsKey, this.qb::get, hostedMethod -> new d.b(hostedMethod.format("%n(%p): %r"), d.b.a.qF, this.qb.get(hostedMethod)), n2 -> List.of(new TableData.HeaderRowData(List.of(new TableData.TextHeaderCellData(pW, Integer.valueOf(3)))), new TableData.HeaderRowData(List.of(new TableData.TextHeaderCellData(pX, null, null, true, TableData.HeaderCellData.SortType.STRING), new TableData.TextHeaderCellData(pY, "text-center", null, true, TableData.HeaderCellData.SortType.STRING), new TableData.TotalHeaderCellData("Machine code size", ByteFormattingUtil.bytesToHuman((long)n2.intValue()), null, null, true)))));
        arrayList2.add(sunburstChartData2);
        arrayList3.add("Machine code size");
        if (this.dG()) {
            arrayList.add(new BreakdownData.ExpertBreakdownType(pT, ""));
            SunburstChartData sunburstChartData3 = this.a(this.qc::containsKey, hostedMethod -> this.qc.get(hostedMethod).dM(), hostedMethod -> this.qc.get(hostedMethod).dK(), hostedMethod -> {
                c c2 = this.qc.get(hostedMethod);
                LinkedHashSet<d.b.a> linkedHashSet = new LinkedHashSet<d.b.a>();
                if (c2.dI() > 0) {
                    linkedHashSet.add(d.b.a.qG);
                }
                if (c2.dJ() > 0) {
                    linkedHashSet.add(d.b.a.qH);
                }
                return new d.a(hostedMethod.format("%n(%p): %r"), linkedHashSet, c2.dI(), c2.dJ(), c2.dL(), c2.dN());
            }, n2 -> List.of(new TableData.HeaderRowData(List.of(new TableData.TextHeaderCellData(pW, Integer.valueOf(4)))), new TableData.HeaderRowData(List.of(new TableData.TextHeaderCellData(pX, null, null, true, TableData.HeaderCellData.SortType.STRING), new TableData.TextHeaderCellData(pY, "text-center", null, true, TableData.HeaderCellData.SortType.STRING), new TableData.TextHeaderCellData(pZ, "text-center", null, true, TableData.HeaderCellData.SortType.NUMBER), new TableData.TotalHeaderCellData("Machine code size", ByteFormattingUtil.bytesToHuman((long)n2.intValue()), null, null, true)))));
            arrayList2.add(sunburstChartData3);
            arrayList3.add("Machine code size");
        }
        return new BreakdownData(pJ, pK, pM, arrayList, pL, arrayList2, arrayList3, 1);
    }

    private static final class d
    extends SunburstChartData.ArcPayload {
        private static final String qt = "table";
        private List<TableData.HeaderRowData> qu;
        private final List<b> qv = new ArrayList<b>();
        private int qw = 0;

        private d() {
        }

        public void c(List<TableData.HeaderRowData> list) {
            this.qu = list;
        }

        public void a(b b2) {
            this.qv.add(b2);
            this.qw += b2.value;
        }

        public int dP() {
            return this.qw;
        }

        private List<TableData.RowData> dQ() {
            ArrayList<TableData.RowData> arrayList = new ArrayList<TableData.RowData>();
            for (b b2 : this.qv.stream().sorted(Comparator.comparingInt(b::value).reversed()).toList()) {
                arrayList.add(b2.v(this.qw));
            }
            return arrayList;
        }

        public void toJson(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
            try (JsonBuilder.ObjectBuilder objectBuilder2 = objectBuilder.append(qt).object();){
                TableData tableData = new TableData(this.qu, this.dQ(), null, true, null);
                tableData.toJson(objectBuilder2);
            }
        }

        private static class b {
            protected final String qC;
            protected final a qD;
            protected final int value;

            private b(String string, a a2, int n2) {
                this.qC = string;
                this.qD = a2;
                this.value = n2;
            }

            int value() {
                return this.value;
            }

            protected TableData.RowData v(int n2) {
                return new TableData.RowData(List.of(new TableData.TextCellData(this.qC, "breakdown-item-name text-truncate"), new TableData.BadgesCellData(List.of(this.qD.dR()), List.of(this.qD.dS()), "text-center"), new TableData.SizeCellData(ByteFormattingUtil.bytesToHuman((long)this.value), n2 > 0 ? 100.0 * (double)this.value / (double)n2 : 0.0)));
            }

            static final class a
            extends Enum<a> {
                public static final /* enum */ a qE = new a("Reachable", "reachable-origin-badge");
                public static final /* enum */ a qF = new a("Compilation", "compilation-origin-badge");
                public static final /* enum */ a qG = new a("Root", "root-origin-badge");
                public static final /* enum */ a qH = new a("Inlined", "inlined-origin-badge");
                private final String qI;
                private final String qJ;
                private static final /* synthetic */ a[] $VALUES;

                public static a[] values() {
                    return (a[])$VALUES.clone();
                }

                public static a A(String string) {
                    return Enum.valueOf(a.class, string);
                }

                private a(String string2, String string3) {
                    this.qI = string2;
                    this.qJ = string3;
                }

                public String dR() {
                    return this.qI;
                }

                public String dS() {
                    return this.qJ;
                }

                private static /* synthetic */ a[] dT() {
                    return new a[]{qE, qF, qG, qH};
                }

                static {
                    $VALUES = a.dT();
                }
            }
        }

        private static final class a
        extends b {
            private final Set<b.a> qx;
            private final int qy;
            private final int qz;
            private final int qA;
            private final int qB;

            private a(String string, Set<b.a> set, int n2, int n3, int n4, int n5) {
                super(string, null, n2 + n3 + n4);
                this.qx = set;
                this.qy = n2;
                this.qz = n3;
                this.qA = n4;
                this.qB = n5;
            }

            @Override
            protected TableData.RowData v(int n2) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("breakdown-item-name");
                arrayList.add("text-truncate");
                if (this.qx.contains((Object)b.a.qG)) {
                    arrayList.add("text-underline");
                }
                if (this.qx.contains((Object)b.a.qH)) {
                    arrayList.add("text-italic");
                }
                return new TableData.RowData(List.of(new TableData.TextCellData(this.qC, String.join((CharSequence)" ", arrayList)), !this.qx.isEmpty() ? new TableData.BadgesCellData(this.qx.stream().map(b.a::dR).toList(), this.qx.stream().map(b.a::dS).toList(), "text-center") : new TableData.TextCellData(""), new TableData.TextCellData(String.valueOf(this.qB), "text-center"), new com.oracle.svm.enterprise.hosted.buildreport.data.a$b(ByteFormattingUtil.bytesToHuman((long)this.value), this.qy > 0 ? ByteFormattingUtil.bytesToHuman((long)this.qy) : null, this.qz > 0 ? ByteFormattingUtil.bytesToHuman((long)this.qz) : null, this.qA > 0 ? ByteFormattingUtil.bytesToHuman((long)this.qA) : null, n2 > 0 ? 100.0 * (double)this.value / (double)n2 : 0.0, n2 > 0 ? 100.0 * (double)this.qy / (double)this.value : 0.0, n2 > 0 ? 100.0 * (double)this.qz / (double)this.value : 0.0)));
            }
        }
    }

    private static final class a
    extends SunburstChartData.ArcData {
        private static final String qd = "mappedValue";
        private int qe = 0;

        private a(String string) {
            super(string);
        }

        public void r(int n2) {
            this.qe += n2;
        }

        public void toJson(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
            super.toJson(objectBuilder);
            objectBuilder.append(qd, (Object)this.qe);
        }
    }

    private static final class c {
        private int qp = 0;
        private int qq = 0;
        private int qr = 0;
        private int qs = 0;

        private c() {
        }

        public int dI() {
            return this.qp;
        }

        public int dJ() {
            return this.qq;
        }

        public int dK() {
            return this.qp + this.qq;
        }

        public int dL() {
            return this.qr;
        }

        public int dM() {
            return this.dK() + this.dL();
        }

        public int dN() {
            return this.qs;
        }

        public void s(int n2) {
            this.qp += n2;
        }

        public void t(int n2) {
            this.qq += n2;
        }

        public void u(int n2) {
            this.qr = n2;
        }

        public void dO() {
            ++this.qs;
        }
    }

    private static final class b
    extends TableData.SizeCellData {
        static final String qf = "rootText";
        static final String qg = "inlinedText";
        static final String qh = "unmappedText";
        static final String qi = "rootPercentage";
        static final String qj = "inlinedPercentage";
        private final String qk;
        private final String ql;
        private final String qm;
        private final double qn;
        private final double qo;

        private b(String string, String string2, String string3, String string4, double d2, double d3, double d4) {
            super(string, d2);
            this.qk = string2;
            this.ql = string3;
            this.qm = string4;
            this.qn = d3;
            this.qo = d4;
        }

        public void toJson(JsonBuilder.ObjectBuilder objectBuilder) throws IOException {
            super.toJson(objectBuilder);
            if (this.qk != null) {
                objectBuilder.append(qf, (Object)this.qk);
            }
            if (this.ql != null) {
                objectBuilder.append(qg, (Object)this.ql);
            }
            if (this.qm != null) {
                objectBuilder.append(qh, (Object)this.qm);
            }
            objectBuilder.append(qi, (Object)this.qn);
            objectBuilder.append(qj, (Object)this.qo);
        }
    }
}

