/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.aq;
import com.oracle.svm.enterprise.gc.g1.e;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.replacements.ReplacementsUtil;
import jdk.graal.compiler.word.ObjectAccess;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.CodeUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class i
extends ObjectHeader {
    private final int lL;
    private final int lM;
    private final int lN;
    private final int lO;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public i() {
        assert (ReferenceAccess.singleton().haveCompressedReferences()) : "G1 requires compressed references";
        this.lL = CodeUtil.log2((int)ConfigurationValues.getObjectLayout().getAlignment());
        if (aq.useCompressedReferences()) {
            this.lM = 27;
            this.lN = 37;
            this.lO = 5;
        } else {
            this.lM = 32;
            this.lN = 0;
            this.lO = 0;
        }
    }

    @Fold
    public static i get() {
        return (i)e.get().getObjectHeader();
    }

    @Fold
    public static int getMarkWordOffset() {
        return 0;
    }

    public int getReservedHubBitsMask() {
        return (1 << this.lO) - 1;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long cn() {
        return (1L << this.lN) - 1L;
    }

    public Word encodeAsTLABObjectHeader(DynamicHub dynamicHub) {
        return this.a(dynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Word a(DynamicHub dynamicHub) {
        Word word = Word.objectToUntrackedPointer((Object)dynamicHub).subtract((UnsignedWord)KnownIntrinsics.heapBase());
        this.b(word);
        if (aq.useCompressedReferences()) {
            Word word2 = word.shiftLeft(this.lN - this.lL);
            this.a(word2);
            return word2;
        }
        return word;
    }

    public long encodeAsTLABObjectHeader(long l2) {
        if (aq.useCompressedReferences()) {
            return l2 << this.lN - this.lL;
        }
        return l2;
    }

    public int constantHeaderSize() {
        return aq.useCompressedReferences() ? 8 : 4;
    }

    public long encodeHubPointerForImageHeap(ImageHeapObject imageHeapObject, long l2) {
        assert (this.d(l2)) : l2;
        if (aq.useCompressedReferences()) {
            long l3 = l2 << this.lO - this.lL;
            assert ((l3 & (long)this.getReservedHubBitsMask()) == 0L) : "all reserved bits must be zero";
            return l3;
        }
        return l2;
    }

    public void verifyDynamicHubOffsetInImageHeap(long l2) {
        if (!this.d(l2)) {
            throw VMError.shouldNotReachHere((String)("Hub is too far from heap base for encoding in object header: " + l2));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word readHeaderFromPointer(Pointer pointer) {
        if (aq.useCompressedReferences()) {
            return (Word)pointer.readWord(i.getMarkWordOffset());
        }
        return (Word)Word.unsigned((int)pointer.readInt(i.getHubOffset()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word readHeaderFromObject(Object object) {
        if (aq.useCompressedReferences()) {
            return (Word)ObjectAccess.readWord((Object)object, (int)i.getMarkWordOffset());
        }
        return (Word)Word.unsigned((int)ObjectAccess.readInt((Object)object, (int)i.getHubOffset()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Pointer extractPotentialDynamicHubFromHeader(Word word) {
        if (aq.useCompressedReferences()) {
            Word word2 = word.unsignedShiftRight(this.lN);
            UnsignedWord unsignedWord = word2.shiftLeft(this.lL);
            return KnownIntrinsics.heapBase().add(unsignedWord);
        }
        return word.add((UnsignedWord)KnownIntrinsics.heapBase());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Word encodeAsUnmanagedObjectHeader(DynamicHub dynamicHub) {
        return this.a(dynamicHub);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    @AlwaysInline(value="Methods that write to INIT_LOCATION must be inlined into a caller that emits an ALLOCATION_INIT barrier.")
    protected void initializeObjectHeader(Pointer pointer, Word word, boolean bl2, ObjectHeader.MemWriter memWriter) {
        if (aq.useCompressedReferences()) {
            this.a(word);
            memWriter.writeWord(pointer, i.getMarkWordOffset(), word);
        } else {
            this.b(word);
            memWriter.writeWord(pointer, i.getMarkWordOffset(), (Word)Word.zero());
            memWriter.writeInt(pointer, i.getHubOffset(), (int)word.rawValue());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasOptionalIdentityHashField(Word word) {
        if (GraalDirectives.inIntrinsic()) {
            ReplacementsUtil.staticAssert((boolean)false, (String)"all objects have the identity hash code field in the object header");
            return false;
        }
        throw VMError.shouldNotReachHereAtRuntime();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasIdentityHashFromAddress(Word word) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"all objects have the identity hash code field in the object header");
        return false;
    }

    @Uninterruptible(reason="Prevent a GC interfering with the object's identity hash state.", callerMustBe=true)
    public void setIdentityHashFromAddress(Pointer pointer, Word word) {
        ReplacementsUtil.staticAssert((boolean)false, (String)"identity hash codes are never computed from addresses");
    }

    @AlwaysInline(value="Otherwise, there is no guarantee that this is optimized away if assertions are disabled.")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void a(Word word) {
        if (!GraalDirectives.inIntrinsic()) {
            assert (this.c(word)) : "all reserved bits must be zero";
        } else if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
            ReplacementsUtil.dynamicAssert((boolean)this.c(word), (String)"all reserved bits must be zero");
        }
    }

    @AlwaysInline(value="Otherwise, there is no guarantee that this is optimized away if assertions are disabled.")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void b(Word word) {
        if (!GraalDirectives.inIntrinsic()) {
            assert (this.d(word.rawValue())) : "must be in hub-specific address space";
        } else if (ReplacementsUtil.REPLACEMENTS_ASSERTIONS_ENABLED) {
            ReplacementsUtil.dynamicAssert((boolean)this.d(word.rawValue()), (String)"must be in hub-specific address space");
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean c(Word word) {
        return word.and((Word)Word.unsigned((long)this.cn())).isNull();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private boolean d(long l2) {
        long l3 = this.co();
        return Long.compareUnsigned(l3, l2) > 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private long co() {
        int n2 = this.lM;
        if (aq.useCompressedReferences()) {
            n2 += this.lL;
        }
        return (1L << n2) - 1L;
    }
}

