/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1.graal;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.GCAllocationSupport;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.OutOfMemoryUtil;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.ContinuationSupport;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.gc.g1.b;
import com.oracle.svm.enterprise.gc.g1.e;
import com.oracle.svm.enterprise.gc.g1.i;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.UnsignedWord;

public class a
implements GCAllocationSupport {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor nC = SnippetRuntime.findForeignCall(a.class, (String)"slowPathNewInstance", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor nD = SnippetRuntime.findForeignCall(a.class, (String)"slowPathNewArray", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor nE = SnippetRuntime.findForeignCall(a.class, (String)"slowPathNewStoredContinuation", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor nF = SnippetRuntime.findForeignCall(a.class, (String)"slowPathNewPodInstance", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.NO_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[0]);
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] nG = new SnippetRuntime.SubstrateForeignCallDescriptor[]{nC, nD};
    public static final FastThreadLocalObject<Object> nH = FastThreadLocalFactory.createObject(Object.class, (String)"podReferenceMap");

    public static void registerForeignCalls(SubstrateForeignCallsProvider substrateForeignCallsProvider) {
        substrateForeignCallsProvider.register(nG);
        if (ContinuationSupport.isSupported()) {
            substrateForeignCallsProvider.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{nE});
        }
        if (Pod.RuntimeSupport.isPresent()) {
            substrateForeignCallsProvider.register(new SnippetRuntime.SubstrateForeignCallDescriptor[]{nF});
        }
    }

    public ForeignCallDescriptor getNewInstanceStub() {
        return nC;
    }

    public ForeignCallDescriptor getNewArrayStub() {
        return nD;
    }

    public ForeignCallDescriptor getNewStoredContinuationStub() {
        return nE;
    }

    public ForeignCallDescriptor getNewPodInstanceStub() {
        return nF;
    }

    public ForeignCallDescriptor getNewDynamicHub() {
        throw VMError.unimplemented((String)"GR-59690: Runtime DynamicHub allocation not implemented for G1");
    }

    public boolean useTLAB() {
        return (Boolean)SubstrateGCOptions.TlabOptions.UseTLAB.getValue();
    }

    public boolean shouldAllocateInTLAB(UnsignedWord unsignedWord, boolean bl2) {
        return true;
    }

    public Word getTLABInfo() {
        return (Word)e.lr.getAddress();
    }

    public int tlabTopOffset() {
        return b.tlabTopOffset();
    }

    public int tlabEndOffset() {
        return b.tlabEndOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.")
    private static Object slowPathNewInstance(Word word) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            DynamicHub dynamicHub = i.get().dynamicHubFromObjectHeader(word);
            a.a("allocateInstance", dynamicHub);
            Object object = a.b(dynamicHub);
            Object object2 = a.p(object);
            return object2;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.")
    private static Object slowPathNewArray(Word word, int n2) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            DynamicHub dynamicHub = i.get().dynamicHubFromObjectHeader(word);
            a.a("allocateArray", dynamicHub);
            a.p(n2);
            Object object = a.a(n2, dynamicHub);
            Object object2 = a.p(object);
            return object2;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.")
    private static Object slowPathNewStoredContinuation(Word word, int n2) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            DynamicHub dynamicHub = i.get().dynamicHubFromObjectHeader(word);
            a.a("allocateStoredContinuation", dynamicHub);
            a.p(n2);
            Object object = a.b(n2, dynamicHub);
            Object object2 = a.p(object);
            return object2;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubstrateForeignCallTarget(stubCallingConvention=false)
    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.")
    private static Object slowPathNewPodInstance(Word word, int n2, byte[] byArray) {
        StackOverflowCheck.singleton().makeYellowZoneAvailable();
        try {
            DynamicHub dynamicHub = i.get().dynamicHubFromObjectHeader(word);
            a.a("allocatePod", dynamicHub);
            a.p(n2);
            nH.set((Object)byArray);
            Object object = a.c(n2, dynamicHub);
            nH.set(null);
            Object object2 = a.p(object);
            return object2;
        }
        finally {
            StackOverflowCheck.singleton().protectYellowZone();
        }
    }

    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.", callerMustBe=true, calleeMustBe=false)
    private static Object b(DynamicHub dynamicHub) {
        Word word = com.oracle.svm.enterprise.gc.g1.nativelib.b.allocateInstance(Word.objectToUntrackedPointer((Object)dynamicHub));
        return word.toObject();
    }

    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.", callerMustBe=true, calleeMustBe=false)
    private static Object a(int n2, DynamicHub dynamicHub) {
        Word word = com.oracle.svm.enterprise.gc.g1.nativelib.b.allocateArray(Word.objectToUntrackedPointer((Object)dynamicHub), n2);
        return word.toObject();
    }

    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.", callerMustBe=true, calleeMustBe=false)
    private static Object b(int n2, DynamicHub dynamicHub) {
        Word word = com.oracle.svm.enterprise.gc.g1.nativelib.b.allocateStoredContinuation(Word.objectToUntrackedPointer((Object)dynamicHub), n2);
        return word.toObject();
    }

    @Uninterruptible(reason="The newly allocated object must be young or all its covered cards must be dirty.", callerMustBe=true, calleeMustBe=false)
    private static Object c(int n2, DynamicHub dynamicHub) {
        Word word = com.oracle.svm.enterprise.gc.g1.nativelib.b.allocatePod(Word.objectToUntrackedPointer((Object)dynamicHub), n2);
        return word.toObject();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void p(int n2) {
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (n2 < 0 ? 1 : 0) != 0)) {
            a.cG();
        }
    }

    @Uninterruptible(reason="No need to be uninterruptible because no object was allocated.", calleeMustBe=false)
    private static void cG() {
        a.cH();
    }

    private static void cH() {
        throw new NegativeArraySizeException();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void a(String string, DynamicHub dynamicHub) {
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (boolean)e.get().isAllocationDisallowed())) {
            a.b(string, dynamicHub);
        }
    }

    @Uninterruptible(reason="No need to be uninterruptible because it kills the process.", calleeMustBe=false)
    private static void b(String string, DynamicHub dynamicHub) {
        throw NoAllocationVerifier.exit((String)string, (String)DynamicHub.toClass((DynamicHub)dynamicHub).getName());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Object p(Object object) {
        if (BranchProbabilityNode.probability((double)0.0010000000000000009, (object == null ? 1 : 0) != 0)) {
            a.cI();
        }
        return object;
    }

    @Uninterruptible(reason="No need to be uninterruptible because no object was allocated.", calleeMustBe=false)
    private static void cI() {
        throw OutOfMemoryUtil.heapSizeExceeded();
    }
}

