/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.fuzzing;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.fuzzing.c;
import com.oracle.svm.enterprise.profiling.framework.CommonInstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.InstrumentationData;
import com.oracle.svm.enterprise.profiling.framework.UninstrumentedLibC;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.List;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;

public class b
extends CommonInstrumentationData {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final String kO = "fuzzing-pc-table-size";
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final String kP = "afl-manual-init-triggered";
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private final c kQ;
    private final CGlobalData<CLongPointer> kR;
    private final boolean kS;
    private final CGlobalData<CIntPointer> kT;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean bO() {
        int n2 = ((CIntPointer)b.singleton().kT.get()).read();
        ((CIntPointer)b.singleton().kT.get()).write(n2 + 1);
        return n2 == 0;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public c bP() {
        return this.kQ;
    }

    @Fold
    public static b singleton() {
        return (b)ImageSingletons.lookup(InstrumentationData.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public b(boolean bl2, c c2, InstrumentationData.OffHeapStorage offHeapStorage) {
        super(offHeapStorage);
        this.kS = bl2;
        this.kR = CGlobalDataFactory.createWord((WordBase)Word.signed((int)offHeapStorage.getTotalNumberOfReservedCounterComponents()), (String)kO);
        this.kT = CGlobalDataFactory.createWord((WordBase)Word.signed((int)0), (String)kP);
        this.kQ = c2;
    }

    @Override
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public List<SnippetRuntime.SubstrateForeignCallDescriptor> foreignCalls() {
        List<SnippetRuntime.SubstrateForeignCallDescriptor> list = super.foreignCalls();
        List<SnippetRuntime.SubstrateForeignCallDescriptor> list2 = null;
        if (this.storage.counterWordSize() == InstrumentationData.CounterWordSize.Bits8) {
            list2 = list;
        } else if (this.storage.counterWordSize() == InstrumentationData.CounterWordSize.Bits32) {
            list2 = list;
            list2.add(com.oracle.svm.enterprise.fuzzing.a.bL());
        } else {
            throw VMError.shouldNotReachHere((String)"Illegal fuzzing counter size");
        }
        return list2;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static ForeignCallNode a(StructuredGraph structuredGraph, ValueNode valueNode, ValueNode valueNode2) {
        int n2 = PrimitiveStamp.getBits((Stamp)valueNode.stamp(NodeView.DEFAULT));
        int n3 = PrimitiveStamp.getBits((Stamp)valueNode2.stamp(NodeView.DEFAULT));
        int n4 = 1 + (n2 - 1) / 8;
        int n5 = 1 + (n3 - 1) / 8;
        assert (n4 >= 4);
        assert (n4 == n5);
        assert (!valueNode.isConstant() || valueNode2.isConstant());
        SnippetRuntime.SubstrateForeignCallDescriptor substrateForeignCallDescriptor = com.oracle.svm.enterprise.fuzzing.a.a(n4, valueNode.getStackKind().isNumericFloat(), valueNode2.isConstant());
        if (substrateForeignCallDescriptor != null) {
            if (valueNode2.isConstant()) {
                return (ForeignCallNode)structuredGraph.add((Node)new ForeignCallNode((ForeignCallDescriptor)substrateForeignCallDescriptor, new ValueNode[]{valueNode2, valueNode}));
            }
            return (ForeignCallNode)structuredGraph.add((Node)new ForeignCallNode((ForeignCallDescriptor)substrateForeignCallDescriptor, new ValueNode[]{valueNode, valueNode2}));
        }
        return null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static ForeignCallNode a(StructuredGraph structuredGraph, ValueNode valueNode, List<JavaConstant> list) {
        SubstrateTargetDescription substrateTargetDescription = ConfigurationValues.getTarget();
        int n2 = PrimitiveStamp.getBits((Stamp)valueNode.stamp(NodeView.DEFAULT));
        ValueNode valueNode2 = n2 == 64 ? valueNode : (ValueNode)structuredGraph.addOrUnique((Node)SignExtendNode.create((ValueNode)valueNode, (int)64, (NodeView)NodeView.DEFAULT));
        int n3 = (2 + list.size()) * substrateTargetDescription.wordSize;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3).order(substrateTargetDescription.arch.getByteOrder());
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        longBuffer.put(0, list.size());
        longBuffer.put(1, n2);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            longBuffer.put(i2 + 2, list.get(i2).asLong());
        }
        CGlobalData cGlobalData = CGlobalDataFactory.createBytes(byteBuffer::array);
        CGlobalDataInfo cGlobalDataInfo = CGlobalDataFeature.singleton().registerAsAccessedOrGet(cGlobalData);
        ValueNode valueNode3 = (ValueNode)structuredGraph.unique((Node)new CGlobalDataLoadAddressNode(cGlobalDataInfo));
        return (ForeignCallNode)structuredGraph.add((Node)new ForeignCallNode((ForeignCallDescriptor)com.oracle.svm.enterprise.fuzzing.a.kI, new ValueNode[]{valueNode2, valueNode3}));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static ForeignCallNode c(StructuredGraph structuredGraph) {
        return (ForeignCallNode)structuredGraph.add((Node)new ForeignCallNode((ForeignCallDescriptor)com.oracle.svm.enterprise.fuzzing.a.kL, new ValueNode[0]));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void onCounterMemoryAllocated(PointerBase pointerBase) {
        b b2 = b.singleton();
        long l2 = ((CLongPointer)InstrumentationData.OffHeapStorage.singleton().getProfilingCountersMemorySize().get()).read();
        if (b2.storage.counterWordSize() == InstrumentationData.CounterWordSize.Bits32) {
            var5_4 = (CIntPointer)Word.pointer((long)(pointerBase.rawValue() + l2));
            a.sanitizerCovTracePcGuardInit((CIntPointer)pointerBase, var5_4);
        } else if (b2.storage.counterWordSize() == InstrumentationData.CounterWordSize.Bits8) {
            var5_4 = Word.pointer((long)(pointerBase.rawValue() + l2));
            a.sanitizerCov8BitCountersInit(pointerBase, (PointerBase)var5_4);
        } else {
            throw VMError.shouldNotReachHere((String)"Fuzzing instrumentation only supports 8 and 32 bits counters");
        }
        if (b2.kS) {
            long l3 = ((CLongPointer)b2.kR.get()).read();
            long l4 = 2L * (long)ConfigurationValues.getTarget().wordSize;
            CLongPointer cLongPointer = (CLongPointer)UninstrumentedLibC.calloc(Word.unsigned((long)l3), Word.unsigned((long)l4));
            if (cLongPointer.isNull()) {
                UninstrumentedLibC.exitWithMessage(3, (CCharPointer)InstrumentationData.OffHeapStorage.singleton().getAllocationFailedErrorMessage().get());
            }
            int n2 = 0;
            while ((long)n2 < l3) {
                cLongPointer.write(2 * n2, (long)(n2 >> 1));
                ++n2;
            }
            long l5 = l4 * l3 / 8L;
            CLongPointer cLongPointer2 = cLongPointer.addressOf(Word.signed((long)l5));
            a.sanitizerCovPcsInit((PointerBase)cLongPointer, (PointerBase)cLongPointer2);
        }
    }

    @CLibrary(value="coverage", requireStatic=true)
    public static class a {
        @CFunction(value="__afl_manual_init", transition=CFunction.Transition.NO_TRANSITION)
        private static native void aflManualInit();

        @CFunction(value="__sanitizer_cov_trace_pc_guard", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTracePcGuard(CIntPointer var0);

        @CFunction(value="__sanitizer_cov_trace_pc_guard_init", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTracePcGuardInit(CIntPointer var0, CIntPointer var1);

        @CFunction(value="__sanitizer_cov_8bit_counters_init", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCov8BitCountersInit(PointerBase var0, PointerBase var1);

        @CFunction(value="__sanitizer_cov_pcs_init", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovPcsInit(PointerBase var0, PointerBase var1);

        @CFunction(value="__sanitizer_cov_trace_cmp1", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTraceCmp1(char var0, char var1);

        @CFunction(value="__sanitizer_cov_trace_cmp2", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTraceCmp2(short var0, short var1);

        @CFunction(value="__sanitizer_cov_trace_cmp4", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTraceCmp4(int var0, int var1);

        @CFunction(value="__sanitizer_cov_trace_cmp8", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTraceCmp8(long var0, long var2);

        @CFunction(value="__sanitizer_cov_trace_const_cmp1", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTraceConstCmp1(char var0, char var1);

        @CFunction(value="__sanitizer_cov_trace_const_cmp2", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTraceConstCmp2(short var0, short var1);

        @CFunction(value="__sanitizer_cov_trace_const_cmp4", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTraceConstCmp4(int var0, int var1);

        @CFunction(value="__sanitizer_cov_trace_const_cmp8", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTraceConstCmp8(long var0, long var2);

        @CFunction(value="__sanitizer_cov_trace_switch", transition=CFunction.Transition.NO_TRANSITION)
        private static native void sanitizerCovTraceSwitch(long var0, CLongPointer var2);

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        static void tracePCGuardForeignCall(CIntPointer cIntPointer) {
            a.sanitizerCovTracePcGuard(cIntPointer);
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceCmp1(char c2, char c3) {
            a.sanitizerCovTraceCmp1(c2, c3);
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceCmp2(short s2, short s3) {
            a.sanitizerCovTraceCmp2(s2, s3);
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceCmp4(int n2, int n3) {
            a.sanitizerCovTraceCmp4(n2, n3);
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceCmp8(long l2, long l3) {
            a.sanitizerCovTraceCmp8(l2, l3);
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceConstCmp1(char c2, char c3) {
            a.sanitizerCovTraceConstCmp1(c2, c3);
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceConstCmp2(short s2, short s3) {
            a.sanitizerCovTraceConstCmp2(s2, s3);
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceConstCmp4(int n2, int n3) {
            a.sanitizerCovTraceConstCmp4(n2, n3);
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceConstCmp8(long l2, long l3) {
            a.sanitizerCovTraceConstCmp8(l2, l3);
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceCmp4Float(float f2, float f3) {
            a.sanitizerCovTraceCmp4(Float.floatToIntBits(f2), Float.floatToIntBits(f3));
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceConstCmp4Float(float f2, float f3) {
            a.sanitizerCovTraceConstCmp4(Float.floatToIntBits(f2), Float.floatToIntBits(f3));
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceCmp8Double(double d2, double d3) {
            a.sanitizerCovTraceCmp8(Double.doubleToRawLongBits(d2), Double.doubleToRawLongBits(d3));
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceConstCmp8Double(double d2, double d3) {
            a.sanitizerCovTraceConstCmp8(Double.doubleToRawLongBits(d2), Double.doubleToRawLongBits(d3));
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void traceSwitch(long l2, CLongPointer cLongPointer) {
            a.sanitizerCovTraceSwitch(l2, cLongPointer);
        }

        @com.oracle.svm.enterprise.core.annotate.a
        @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static void callAFLManualInit() {
            if (b.bO()) {
                a.aflManualInit();
            }
        }
    }
}

