/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.sboutlining.concat;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.core.sboutlining.concat.SubstrateStringConcatHelper;
import com.oracle.svm.enterprise.core.sboutlining.concat.d;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.StringConcatException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class c {
    private static final char jr = '\u0001';
    private static final char js = '\u0002';
    private final Function<Class<?>, MethodHandle> jt = new Function<Class<?>, MethodHandle>(){

        public MethodHandle e(Class<?> clazz) {
            MethodHandle methodHandle = d.h(clazz);
            return methodHandle.bindTo(c.this.jw);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.e((Class)object);
        }
    };
    private final Function<Class<?>, MethodHandle> ju = new Function<Class<?>, MethodHandle>(){

        public MethodHandle e(Class<?> clazz) {
            return c.this.a(c.this.jz.computeIfAbsent(clazz, c.this.jt), 3, null);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.e((Class)object);
        }
    };
    private final Function<Class<?>, MethodHandle> jv = new Function<Class<?>, MethodHandle>(){

        public MethodHandle e(Class<?> clazz) {
            MethodHandle methodHandle = d.f(clazz);
            return methodHandle.bindTo(c.this.jw);
        }

        @Override
        public /* synthetic */ Object apply(Object object) {
            return this.e((Class)object);
        }
    };
    private MethodHandle iQ;
    private MethodHandle iR;
    private MethodHandle iS;
    private MethodHandle iT;
    private MethodHandle iU;
    private MethodHandle iV;
    private MethodHandle iW;
    private MethodHandle iX;
    private final HostedGraphKit jw;
    private static final Method jx = ReflectionUtil.lookupMethod(MethodHandles.class, (String)"foldArgumentsWithCombiner", (Class[])new Class[]{MethodHandle.class, Integer.TYPE, MethodHandle.class, int[].class});
    private static final Method jy = ReflectionUtil.lookupMethod(MethodHandles.class, (String)"filterArgumentsWithCombiner", (Class[])new Class[]{MethodHandle.class, Integer.TYPE, MethodHandle.class, int[].class});
    private final Map<Class<?>, MethodHandle> jz;
    private final Map<Class<?>, MethodHandle> jA;
    private final Map<Class<?>, MethodHandle> jB;
    private static final long jC = SubstrateStringConcatHelper.bJ();

    public MethodHandle b(MethodType methodType) throws StringConcatException {
        String string = "\u0001".repeat(methodType.parameterCount());
        return this.a(methodType, string, new Object[0]);
    }

    private MethodHandle a(MethodType methodType, String string2, Object ... objectArray) throws StringConcatException {
        Objects.requireNonNull(methodType, "Concat type is null");
        Objects.requireNonNull(objectArray, "Constants are null");
        assert (objectArray.length == 0) : "we expect no constants to be passed";
        for (Object object : objectArray) {
            Objects.requireNonNull(object, "Cannot accept null constants");
        }
        List<String> list = c.b(methodType, string2, objectArray);
        if (!((Class)methodType.returnType()).isAssignableFrom(String.class)) {
            throw new StringConcatException("The return type should be compatible with String, but it is " + String.valueOf(methodType.returnType()));
        }
        assert (list.stream().allMatch(string -> string == null)) : "the recipe should be only TAG_ARGs";
        try {
            return this.b(methodType, list);
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new StringConcatException("Generator failed", throwable);
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static List<String> b(MethodType methodType, String string, Object[] objectArray) throws StringConcatException {
        Objects.requireNonNull(string, "Recipe is null");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\u0002') {
                if (n2 == objectArray.length) {
                    throw c.a(objectArray, n2);
                }
                stringBuilder.append(objectArray[n2++]);
                continue;
            }
            if (c2 == '\u0001') {
                if (stringBuilder.length() > 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                arrayList.add(null);
                ++n3;
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        if (n3 != methodType.parameterCount()) {
            throw c.b(methodType, n3);
        }
        if (n2 < objectArray.length) {
            throw c.a(objectArray, n2);
        }
        return arrayList;
    }

    private static StringConcatException b(MethodType methodType, int n2) {
        return new StringConcatException("Mismatched number of concat arguments: recipe wants " + n2 + " arguments, but signature provides " + methodType.parameterCount());
    }

    private static StringConcatException a(Object[] objectArray, int n2) {
        return new StringConcatException("Mismatched number of concat constants: recipe wants " + n2 + " constants, but only " + objectArray.length + " are passed");
    }

    /*
     * WARNING - void declaration
     */
    private MethodHandle b(MethodType methodType, List<String> list) {
        void var12_18;
        Object object;
        MethodHandle[] methodHandleArray;
        Object object3;
        if (list.size() == 1) {
            String string = list.get(0);
            if (string == null) {
                return this.g((Class<?>)methodType.parameterType(0));
            }
            return this.a(this.g(Object.class), 0, string);
        }
        if (list.size() == 2) {
            object3 = list.get(0);
            methodHandleArray = list.get(1);
            if (methodType.parameterCount() == 2 && !((Class)methodType.parameterType(0)).isPrimitive() && !((Class)methodType.parameterType(1)).isPrimitive() && object3 == null && methodHandleArray == null) {
                return this.bH();
            }
            if (methodType.parameterCount() == 1) {
                int n2;
                Object object4;
                if (methodHandleArray == null) {
                    object4 = object3;
                    n2 = 0;
                } else {
                    object4 = methodHandleArray;
                    n2 = 1;
                }
                if (((String)object4).isEmpty()) {
                    return this.g((Class<?>)methodType.parameterType(0));
                }
                if (!((Class)methodType.parameterType(0)).isPrimitive()) {
                    return this.a(this.bH(), n2, (String)object4);
                }
            }
        }
        object3 = methodType.erase().parameterArray();
        methodHandleArray = null;
        for (int i2 = 0; i2 < ((Class<?>[])object3).length; ++i2) {
            MethodHandle methodHandle = this.d(object3[i2]);
            if (methodHandle == null) continue;
            if (methodHandleArray == null) {
                methodHandleArray = new MethodHandle[((Class<?>[])object3).length];
            }
            methodHandleArray[i2] = methodHandle;
            object3[i2] = String.class;
        }
        Object[] objectArray = new Class[((Class<?>[])object3).length];
        Arrays.fill(objectArray, ValueNode.class);
        MethodHandle methodHandle = MethodHandles.dropArguments(this.bI(), 2, objectArray);
        long l2 = jC;
        String string = null;
        int n3 = 0;
        for (String object22 : list) {
            if (object22 != null) {
                l2 = SubstrateStringConcatHelper.mix(l2, object22);
                assert (string == null);
                string = object22;
                continue;
            }
            methodHandle = c.b(methodHandle, 1, this.a(string, object3[n3]), 1, 0, 2 + n3);
            string = null;
            ++n3;
        }
        if (string != null) {
            l2 -= (long)string.length();
            object = this.g(string);
        } else {
            object = this.br();
        }
        methodHandle = c.a(methodHandle, 0, (MethodHandle)object, 1);
        n3 = -1;
        Object var12_17 = null;
        for (String string2 : list) {
            if (string2 != null) continue;
            if (n3 >= 0) {
                methodHandle = c.b(methodHandle, 0, (MethodHandle)var12_18, 0, 1 + n3);
            }
            Class<?> clazz = object3[++n3];
            MethodHandle methodHandle2 = this.c(clazz);
        }
        if (n3 >= 0) {
            MethodHandle methodHandle3 = this.a((MethodHandle)var12_18, 0, l2);
            methodHandle = c.a(methodHandle, 0, methodHandle3, 1 + n3);
        } else {
            methodHandle = this.a(methodHandle, 0, l2);
        }
        if (methodHandleArray != null) {
            methodHandle = MethodHandles.filterArguments(methodHandle, 0, methodHandleArray);
        }
        return methodHandle;
    }

    private MethodHandle a(String string, Class<?> clazz) {
        if (string == null) {
            return this.jA.computeIfAbsent(clazz, this.ju);
        }
        return this.a(this.jz.computeIfAbsent(clazz, this.jt), 3, string);
    }

    private MethodHandle c(Class<?> clazz) {
        return this.jB.computeIfAbsent(clazz, this.jv);
    }

    private MethodHandle bH() {
        return d.jR.bindTo(this.jw);
    }

    private MethodHandle bI() {
        return d.jS.bindTo(this.jw);
    }

    private MethodHandle g(String string) {
        MethodHandle methodHandle = d.jT.bindTo(this.jw);
        return this.a(methodHandle, 0, string);
    }

    private MethodHandle br() {
        return d.jU.bindTo(this.jw);
    }

    private MethodHandle bs() {
        MethodHandle methodHandle = this.iQ;
        if (methodHandle == null) {
            this.iQ = methodHandle = d.jP.bindTo(this.jw);
        }
        return methodHandle;
    }

    private MethodHandle bt() {
        MethodHandle methodHandle = this.iR;
        if (methodHandle == null) {
            this.iR = methodHandle = d.jN.bindTo(this.jw);
        }
        return methodHandle;
    }

    private MethodHandle bu() {
        MethodHandle methodHandle = this.iS;
        if (methodHandle == null) {
            this.iS = methodHandle = d.jO.bindTo(this.jw);
        }
        return methodHandle;
    }

    private MethodHandle bv() {
        MethodHandle methodHandle = this.iT;
        if (methodHandle == null) {
            this.iT = methodHandle = d.jL.bindTo(this.jw);
        }
        return methodHandle;
    }

    private MethodHandle bw() {
        MethodHandle methodHandle = this.iU;
        if (methodHandle == null) {
            this.iU = methodHandle = d.jM.bindTo(this.jw);
        }
        return methodHandle;
    }

    private MethodHandle bx() {
        MethodHandle methodHandle = this.iV;
        if (methodHandle == null) {
            this.iV = methodHandle = d.jK.bindTo(this.jw);
        }
        return methodHandle;
    }

    private MethodHandle by() {
        MethodHandle methodHandle = this.iW;
        if (methodHandle == null) {
            this.iW = methodHandle = d.jJ.bindTo(this.jw);
        }
        return methodHandle;
    }

    private MethodHandle bz() {
        MethodHandle methodHandle = this.iX;
        if (methodHandle == null) {
            this.iX = methodHandle = d.jQ.bindTo(this.jw);
        }
        return methodHandle;
    }

    private MethodHandle g(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return this.bz();
        }
        if (clazz == Integer.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE) {
            return this.bv();
        }
        if (clazz == Long.TYPE) {
            return this.bw();
        }
        if (clazz == Character.TYPE) {
            return this.bx();
        }
        if (clazz == Boolean.TYPE) {
            return this.by();
        }
        if (clazz == Float.TYPE) {
            return this.bt();
        }
        if (clazz == Double.TYPE) {
            return this.bu();
        }
        throw new InternalError("Unhandled type for unary concatenation: " + String.valueOf(clazz));
    }

    private MethodHandle d(Class<?> clazz) {
        if (clazz == Object.class) {
            return this.bs();
        }
        if (clazz == Float.TYPE) {
            return this.bt();
        }
        if (clazz == Double.TYPE) {
            return this.bu();
        }
        return null;
    }

    public c(HostedGraphKit hostedGraphKit) {
        this.jw = hostedGraphKit;
        this.jz = new HashMap();
        this.jA = new HashMap();
        this.jB = new HashMap();
    }

    private MethodHandle a(MethodHandle methodHandle, int n2, String string) {
        ConstantNode constantNode = this.jw.createObject((Object)string);
        return MethodHandles.insertArguments(methodHandle, n2, constantNode);
    }

    private MethodHandle a(MethodHandle methodHandle, int n2, long l2) {
        ConstantNode constantNode = this.jw.createLong(l2);
        return MethodHandles.insertArguments(methodHandle, n2, constantNode);
    }

    private static MethodHandle a(MethodHandle methodHandle, int n2, MethodHandle methodHandle2, int ... nArray) {
        try {
            methodHandle = (MethodHandle)jx.invoke(null, methodHandle, n2, methodHandle2, nArray);
            return methodHandle;
        }
        catch (Throwable throwable) {
            throw VMError.shouldNotReachHere((Throwable)throwable);
        }
    }

    private static MethodHandle b(MethodHandle methodHandle, int n2, MethodHandle methodHandle2, int ... nArray) {
        try {
            methodHandle = (MethodHandle)jy.invoke(null, methodHandle, n2, methodHandle2, nArray);
            return methodHandle;
        }
        catch (Throwable throwable) {
            throw VMError.shouldNotReachHere((Throwable)throwable);
        }
    }
}

