/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.sboutlining.concat;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.util.BasedOnJDKClass;
import com.oracle.svm.util.ReflectionUtil;
import jdk.internal.misc.Unsafe;

@BasedOnJDKClass(className="java.lang.StringConcatHelper")
public final class SubstrateStringConcatHelper {
    static final long jV = (long)a.ka << 32;
    static final long jW = (long)a.jZ << 32;
    private static final Unsafe jX = Unsafe.getUnsafe();

    public static int stringSize(int n2) {
        return Target_jdk_internal_util_DecimalDigits.stringSize(n2);
    }

    public static int stringSize(long l2) {
        return Target_jdk_internal_util_DecimalDigits.stringSize(l2);
    }

    private SubstrateStringConcatHelper() {
    }

    private static long a(long l2) {
        if ((int)l2 >= 0) {
            return l2;
        }
        throw new OutOfMemoryError("Overflow: String length out of range");
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, boolean bl2) {
        return SubstrateStringConcatHelper.a(l2 + (long)(bl2 ? 4 : 5));
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, byte by) {
        return SubstrateStringConcatHelper.mix(l2, (int)by);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, char c2) {
        return SubstrateStringConcatHelper.a(l2 + 1L) | (Target_java_lang_StringLatin1.canEncode(c2) ? 0L : jW);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, short s2) {
        return SubstrateStringConcatHelper.mix(l2, (int)s2);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, int n2) {
        return SubstrateStringConcatHelper.a(l2 + (long)SubstrateStringConcatHelper.stringSize(n2));
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, long l3) {
        return SubstrateStringConcatHelper.a(l2 + (long)SubstrateStringConcatHelper.stringSize(l3));
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long mix(long l2, String string) {
        l2 += (long)string.length();
        if (UninterruptibleUtils.String.coder((String)string) == a.jZ) {
            l2 |= jW;
        }
        return SubstrateStringConcatHelper.a(l2);
    }

    @com.oracle.svm.enterprise.core.annotate.a
    private static long prepend(long l2, byte[] byArray, boolean bl2) {
        int n2 = (int)l2;
        if (l2 < jW) {
            if (bl2) {
                byArray[--n2] = 101;
                byArray[--n2] = 117;
                byArray[--n2] = 114;
                byArray[--n2] = 116;
            } else {
                byArray[--n2] = 101;
                byArray[--n2] = 115;
                byArray[--n2] = 108;
                byArray[--n2] = 97;
                byArray[--n2] = 102;
            }
            return n2;
        }
        if (bl2) {
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 101);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 117);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 114);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 116);
        } else {
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 101);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 115);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 108);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 97);
            Target_java_lang_StringUTF16.putChar(byArray, --n2, 102);
        }
        return (long)n2 | jW;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, boolean bl2, String string) {
        l2 = SubstrateStringConcatHelper.prepend(l2, byArray, bl2);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, byte by, String string) {
        l2 = SubstrateStringConcatHelper.a(l2, byArray, by);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    private static long prepend(long l2, byte[] byArray, char c2) {
        if (l2 < jW) {
            byArray[(int)(--l2)] = (byte)(c2 & 0xFF);
        } else {
            Target_java_lang_StringUTF16.putChar(byArray, (int)(--l2), c2);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, char c2, String string) {
        l2 = SubstrateStringConcatHelper.prepend(l2, byArray, c2);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, short s2, String string) {
        l2 = SubstrateStringConcatHelper.a(l2, byArray, s2);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    private static long a(long l2, byte[] byArray, int n2) {
        if (l2 < jW) {
            return Target_jdk_internal_util_DecimalDigits.uncheckedGetCharsLatin1(n2, (int)l2, byArray);
        }
        return (long)Target_jdk_internal_util_DecimalDigits.uncheckedGetCharsUTF16(n2, (int)l2, byArray) | jW;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, int n2, String string) {
        l2 = SubstrateStringConcatHelper.a(l2, byArray, n2);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    private static long a(long l2, byte[] byArray, long l3) {
        if (l2 < jW) {
            return Target_jdk_internal_util_DecimalDigits.uncheckedGetCharsLatin1(l3, (int)l2, byArray);
        }
        return (long)Target_jdk_internal_util_DecimalDigits.uncheckedGetCharsUTF16(l3, (int)l2, byArray) | jW;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, long l3, String string) {
        l2 = SubstrateStringConcatHelper.a(l2, byArray, l3);
        if (string != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        }
        return l2;
    }

    private static long a(long l2, byte[] byArray, String string) {
        if ((l2 -= (long)string.length()) < jW) {
            a.a(string, byArray, (int)l2, a.ka);
        } else {
            a.a(string, byArray, (int)l2, a.jZ);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static long prepend(long l2, byte[] byArray, String string, String string2) {
        l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        if (string2 != null) {
            l2 = SubstrateStringConcatHelper.a(l2, byArray, string2);
        }
        return l2;
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static String newString(byte[] byArray, long l2) {
        if (l2 == jV) {
            return a.a(byArray, a.ka);
        }
        if (l2 == jW) {
            return a.a(byArray, a.jZ);
        }
        throw new InternalError("Storage is not completely initialized, " + (int)l2 + " bytes left");
    }

    @AlwaysInline(value="@ForceInline in JDK")
    @com.oracle.svm.enterprise.core.annotate.a
    static String simpleConcat(Object object, Object object2) {
        String string = SubstrateStringConcatHelper.stringOf(object);
        String string2 = SubstrateStringConcatHelper.stringOf(object2);
        if (string.isEmpty()) {
            return new String(string2);
        }
        if (string2.isEmpty()) {
            return new String(string);
        }
        long l2 = SubstrateStringConcatHelper.mix(SubstrateStringConcatHelper.bJ(), string);
        l2 = SubstrateStringConcatHelper.mix(l2, string2);
        byte[] byArray = SubstrateStringConcatHelper.newArray(l2);
        l2 = SubstrateStringConcatHelper.a(l2, byArray, string2);
        l2 = SubstrateStringConcatHelper.a(l2, byArray, string);
        return SubstrateStringConcatHelper.newString(byArray, l2);
    }

    @AlwaysInline(value="@ForceInline in JDK")
    @com.oracle.svm.enterprise.core.annotate.a
    static String newStringOf(Object object) {
        return new String(SubstrateStringConcatHelper.stringOf(object));
    }

    @com.oracle.svm.enterprise.core.annotate.a
    static String stringOf(Object object) {
        String string;
        return object == null || (string = object.toString()) == null ? "null" : string;
    }

    @AlwaysInline(value="@ForceInline in JDK")
    @com.oracle.svm.enterprise.core.annotate.a
    static byte[] newArrayWithSuffix(String string, long l2) {
        byte[] byArray = SubstrateStringConcatHelper.newArray(l2 + (long)string.length());
        if (l2 < jW) {
            a.a(string, byArray, (int)l2, a.ka);
        } else {
            a.a(string, byArray, (int)l2, a.jZ);
        }
        return byArray;
    }

    @AlwaysInline(value="@ForceInline in JDK")
    @com.oracle.svm.enterprise.core.annotate.a
    static byte[] newArray(long l2) {
        byte by = (byte)(l2 >> 32);
        int n2 = (int)l2 << by;
        if (n2 < 0) {
            throw new OutOfMemoryError("Overflow: String length out of range");
        }
        return (byte[])jX.allocateUninitializedArray(Byte.TYPE, n2);
    }

    static long bJ() {
        return a.jY ? jV : jW;
    }

    @TargetClass(className="jdk.internal.util.DecimalDigits")
    static final class Target_jdk_internal_util_DecimalDigits {
        Target_jdk_internal_util_DecimalDigits() {
        }

        @Alias
        public static native int stringSize(int var0);

        @Alias
        public static native int stringSize(long var0);

        @Alias
        static native int uncheckedGetCharsLatin1(int var0, int var1, byte[] var2);

        @Alias
        static native int uncheckedGetCharsLatin1(long var0, int var2, byte[] var3);

        @Alias
        static native int uncheckedGetCharsUTF16(long var0, int var2, byte[] var3);
    }

    @TargetClass(className="java.lang.StringLatin1")
    static final class Target_java_lang_StringLatin1 {
        Target_java_lang_StringLatin1() {
        }

        @Alias
        static native boolean canEncode(int var0);

        @Alias
        static native int length(byte[] var0);
    }

    static class a {
        static final boolean jY;
        static final byte jZ;
        static final byte ka;

        a() {
        }

        static void a(String string, byte[] byArray, int n2, byte by) {
            ((Target_java_lang_String)SubstrateUtil.cast((Object)string, Target_java_lang_String.class)).getBytes(byArray, n2, by);
        }

        static String a(byte[] byArray, byte by) {
            return (String)SubstrateUtil.cast((Object)new Target_java_lang_String(byArray, by), String.class);
        }

        static {
            ka = (Byte)ReflectionUtil.readStaticField(String.class, (String)"LATIN1");
            jZ = (Byte)ReflectionUtil.readStaticField(String.class, (String)"UTF16");
            jY = (Boolean)ReflectionUtil.readStaticField(String.class, (String)"COMPACT_STRINGS");
        }
    }

    @TargetClass(className="java.lang.StringUTF16")
    static final class Target_java_lang_StringUTF16 {
        Target_java_lang_StringUTF16() {
        }

        @Alias
        static native void putChar(byte[] var0, int var1, int var2);

        @Alias
        static native int length(byte[] var0);
    }

    @TargetClass(value=String.class)
    static final class Target_java_lang_String {
        @Alias
        Target_java_lang_String(byte[] byArray, byte by) {
        }

        @Alias
        native void getBytes(byte[] var1, int var2, byte var3);
    }
}

