/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

@TargetClass(value=ArrayList.class)
public final class Target_java_util_ArrayList {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.None, isFinal=true)
    private static Object[] EMPTY_ELEMENTDATA;
    @Alias
    Object[] elementData;
    @Alias
    private int size;

    @Substitute
    public Target_java_util_ArrayList(Collection<?> collection) {
        if (collection.getClass() == ArrayList.class) {
            Target_java_util_ArrayList target_java_util_ArrayList = (Target_java_util_ArrayList)SubstrateUtil.cast(collection, Target_java_util_ArrayList.class);
            this.size = target_java_util_ArrayList.size;
            this.elementData = this.size != 0 ? Arrays.copyOf(target_java_util_ArrayList.elementData, target_java_util_ArrayList.size) : EMPTY_ELEMENTDATA;
        } else {
            Object[] objectArray = collection.toArray();
            this.size = objectArray.length;
            this.elementData = this.size != 0 ? Arrays.copyOf(objectArray, this.size, Object[].class) : EMPTY_ELEMENTDATA;
        }
    }
}

