/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.core.copying;

import com.oracle.svm.enterprise.core.copying.o;
import java.util.Arrays;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GetObjectAddressNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueNodeInterface;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.memory.AbstractMemoryCheckpoint;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public final class RawMemCopyCallNode
extends AbstractMemoryCheckpoint
implements MemoryAccess,
SingleMemoryKill,
Canonicalizable,
Lowerable {
    public static final NodeClass<RawMemCopyCallNode> TYPE = NodeClass.create(RawMemCopyCallNode.class);
    @Node.Input
    protected ValueNode dN;
    @Node.Input
    protected ValueNode dO;
    @Node.Input
    protected ValueNode dP;
    @Node.Input
    protected ValueNode dQ;
    @Node.Input
    protected ValueNode dR;
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill dS;
    private final o dT;
    private final LocationIdentity dU;
    private final LocationIdentity dV;
    private boolean J;
    private final boolean dW;

    public RawMemCopyCallNode(o o2, ValueNode valueNode, ValueNode valueNode2, ValueNode valueNode3, ValueNode valueNode4, ValueNode valueNode5, LocationIdentity locationIdentity, LocationIdentity locationIdentity2, boolean bl2, boolean bl3) {
        super(TYPE, StampFactory.forVoid());
        this.dN = valueNode;
        this.dO = valueNode2;
        this.dP = valueNode3;
        this.dQ = valueNode4;
        this.dR = valueNode5;
        this.dU = locationIdentity;
        this.dV = locationIdentity2;
        this.J = bl2;
        this.dT = o2;
        this.dW = bl3;
    }

    public ValueNode U() {
        return this.dN;
    }

    public ValueNode V() {
        return this.dO;
    }

    public ValueNode W() {
        return this.dP;
    }

    public ValueNode X() {
        return this.dQ;
    }

    public ValueNode Y() {
        return this.dR;
    }

    public boolean Z() {
        return this.J;
    }

    public boolean aa() {
        return this.dW;
    }

    public MemoryKill getLastLocationAccess() {
        return this.dS;
    }

    public void setLastLocationAccess(MemoryKill memoryKill) {
        this.updateUsagesInterface((ValueNodeInterface)this.dS, (ValueNodeInterface)memoryKill);
        this.dS = memoryKill;
    }

    public LocationIdentity getLocationIdentity() {
        return this.dU;
    }

    public LocationIdentity getKilledLocationIdentity() {
        return this.dV;
    }

    public boolean hasSideEffect() {
        return !this.dV.isInit();
    }

    public Node canonical(CanonicalizerTool canonicalizerTool) {
        if (this.Y().isConstant() && this.Y().asConstant().isDefaultForKind()) {
            if (this.dS != null) {
                this.replaceAtUsages((Node)this.dS.asNode(), InputType.Memory);
            }
            return null;
        }
        return this;
    }

    public void lower(LoweringTool loweringTool) {
        if (this.graph().getGuardsStage().areFrameStatesAtDeopts()) {
            ForeignCallNode foreignCallNode;
            Object[] objectArray;
            StructuredGraph structuredGraph = this.graph();
            if (this.aa()) {
                objectArray = this.dT.b(this.Z(), this.getKilledLocationIdentity());
                assert (objectArray != null) : "no descriptor for rawmemcopy, disjoint " + this.Z() + ", object";
                foreignCallNode = (ForeignCallNode)structuredGraph.add((Node)new ForeignCallNode((ForeignCallDescriptor)objectArray, new ValueNode[]{this.U(), this.V(), this.W(), this.X(), this.Y()}));
            } else {
                objectArray = this.dT.a(this.Z(), this.getKilledLocationIdentity());
                assert (objectArray != null) : "no descriptor for rawmemcopy, disjoint " + this.Z() + ", primitive";
                ValueNode valueNode = this.a(this.U(), this.V());
                ValueNode valueNode2 = this.a(this.W(), this.X());
                foreignCallNode = (ForeignCallNode)structuredGraph.add((Node)new ForeignCallNode((ForeignCallDescriptor)objectArray, new ValueNode[]{valueNode, valueNode2, this.Y()}));
            }
            objectArray = foreignCallNode.getKilledLocationIdentities();
            assert (objectArray.length == 1 && objectArray[0].equals(this.getKilledLocationIdentity())) : String.format("%s: should kill %s, unexpected kills: %s", foreignCallNode, this.getKilledLocationIdentity(), Arrays.toString(objectArray));
            structuredGraph.replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)foreignCallNode);
        }
    }

    private ValueNode a(ValueNode valueNode, ValueNode valueNode2) {
        FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)this.graph().add((Node)new GetObjectAddressNode(valueNode));
        this.graph().addBeforeFixed((FixedNode)this, fixedWithNextNode);
        return (ValueNode)this.graph().unique((Node)new OffsetAddressNode((ValueNode)fixedWithNextNode, valueNode2));
    }
}

